/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.oauth.OAuthService;
import org.wso2.apimgt.gateway.cli.oauth.builder.DCRRequestBuilder;
import org.wso2.apimgt.gateway.cli.oauth.builder.OAuthTokenRequestBuilder;
import org.wso2.apimgt.gateway.cli.utils.TokenManagementUtil;

public class OAuthServiceImpl
implements OAuthService {
    private static final Logger logger = LoggerFactory.getLogger(OAuthServiceImpl.class);

    @Override
    public String generateAccessToken(String tokenEndpoint, String username, char[] password, String clientId, String clientSecret) {
        HttpURLConnection urlConn = null;
        try {
            URL url = new URL(tokenEndpoint);
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("POST");
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String clientEncoded = DatatypeConverter.printBase64Binary((byte[])(clientId + ':' + clientSecret).getBytes(StandardCharsets.UTF_8));
            urlConn.setRequestProperty("Authorization", "Basic " + clientEncoded);
            urlConn.setDoOutput(true);
            String postBody = new OAuthTokenRequestBuilder().setClientKey(clientId).setClientSecret(clientSecret.toCharArray()).setGrantType("password").setPassword(password).setScopes(new String[]{"apim:tier_view", "apim:api_view"}).setUsername(username).requestBody();
            urlConn.getOutputStream().write(postBody.getBytes("UTF-8"));
            int responseCode = urlConn.getResponseCode();
            if (responseCode == 200) {
                String accessToken;
                ObjectMapper mapper = new ObjectMapper();
                String responseStr = TokenManagementUtil.getResponseString(urlConn.getInputStream());
                JsonNode rootNode = mapper.readTree(responseStr);
                String string = accessToken = rootNode.path("access_token").asText();
                return string;
            }
            try {
                logger.error("Error occurred while getting token. Status code: {} ", (Object)responseCode);
                throw new CLIRuntimeException();
            }
            catch (IOException e) {
                logger.error("Error occurred while communicate with token endpoint {}", (Object)tokenEndpoint);
                throw new CLIRuntimeException();
            }
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
        }
    }

    @Override
    public String[] generateClientIdAndSecret(String dcrEndpoint, String username, char[] password) {
        HttpURLConnection urlConn = null;
        try {
            String requestBody = new DCRRequestBuilder().setCallbackUrl("https://wso2.org").setClientName("Micro Gateway Cli").setOwner(username).setSaasApp(true).setGrantTypes(new String[]{"password"}).setTokenScope("PRODUCTION").requestBody();
            ObjectMapper mapper = new ObjectMapper();
            URL url = new URL(dcrEndpoint);
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("POST");
            urlConn.setRequestProperty("Content-Type", "application/json");
            urlConn.setDoOutput(true);
            String clientEncoded = DatatypeConverter.printBase64Binary((byte[])(username + ':' + new String(password)).getBytes(StandardCharsets.UTF_8));
            urlConn.setRequestProperty("Authorization", "Basic " + clientEncoded);
            urlConn.getOutputStream().write(requestBody.getBytes("UTF-8"));
            int responseCode = urlConn.getResponseCode();
            if (responseCode == 200) {
                String[] clientInfo;
                String responseStr = TokenManagementUtil.getResponseString(urlConn.getInputStream());
                JsonNode rootNode = mapper.readTree(responseStr);
                JsonNode clientIdNode = rootNode.path("clientId");
                JsonNode clientSecretNode = rootNode.path("clientSecret");
                String clientId = clientIdNode.asText();
                String clientSecret = clientSecretNode.asText();
                String[] stringArray = clientInfo = new String[]{clientId, clientSecret};
                return stringArray;
            }
            try {
                logger.error("Error occurred while creating oAuth application. Status code: {} ", (Object)responseCode);
                throw new CLIRuntimeException("Error occurred while creating oAuth application");
            }
            catch (IOException e) {
                logger.error("Error occurred while communicate with DCR endpoint {}", (Object)dcrEndpoint);
                throw new CLIRuntimeException("Error occurred while communicate with DCR endpoint");
            }
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
        }
    }
}

