/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.oauth.builder;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.wso2.apimgt.gateway.cli.model.oauth.DCRRequest;

public class DCRRequestBuilder {
    private DCRRequest dcrRequest = new DCRRequest();
    ObjectMapper mapper = new ObjectMapper();
    ObjectNode request = this.mapper.createObjectNode();

    public DCRRequest build() {
        return this.dcrRequest;
    }

    public String requestBody() {
        return this.request.toString();
    }

    public DCRRequestBuilder setCallbackUrl(String callbackUrl) {
        this.request.put("callbackUrl", callbackUrl);
        this.dcrRequest.setCallbackUrl(callbackUrl);
        return this;
    }

    public DCRRequestBuilder setClientName(String clientName) {
        this.request.put("clientName", clientName);
        this.dcrRequest.setClientName(clientName);
        return this;
    }

    public DCRRequestBuilder setOwner(String owner) {
        this.request.put("owner", owner);
        this.dcrRequest.setOwner(owner);
        return this;
    }

    public DCRRequestBuilder setGrantTypes(String[] grantTypes) {
        String grantTypesStr = "";
        int grantTypesLength = grantTypes.length;
        int i = 0;
        for (String grant : grantTypes) {
            grantTypesStr = grantTypesStr + grant;
            if (grantTypesLength == ++i) continue;
            grantTypesStr = grantTypesStr + " ";
        }
        this.dcrRequest.setGrantTypes(grantTypes);
        this.request.put("grantType", grantTypesStr);
        return this;
    }

    public DCRRequestBuilder setTokenScope(String tokenScope) {
        this.request.put("tokenScope", tokenScope);
        this.dcrRequest.setTokenScope(tokenScope);
        return this;
    }

    public DCRRequestBuilder setSaasApp(boolean saasApp) {
        this.request.put("saasApp", saasApp);
        this.dcrRequest.setSaasApp(saasApp);
        return this;
    }
}

