/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.oauth.builder;

import org.wso2.apimgt.gateway.cli.model.oauth.OAuthTokenRequest;

public class OAuthTokenRequestBuilder {
    private OAuthTokenRequest oAuthTokenRequest = new OAuthTokenRequest();
    private String request;

    public OAuthTokenRequest build() {
        return this.oAuthTokenRequest;
    }

    public String requestBody() {
        return this.request;
    }

    public OAuthTokenRequestBuilder setClientSecret(char[] clientSecret) {
        this.request = this.request + "&clientSecret=" + new String(clientSecret);
        this.oAuthTokenRequest.setClientSecret(clientSecret);
        return this;
    }

    public OAuthTokenRequestBuilder setClientKey(String clientKey) {
        this.request = this.request + "&clientId=" + clientKey;
        this.oAuthTokenRequest.setClientKey(clientKey);
        return this;
    }

    public OAuthTokenRequestBuilder setScopes(String[] scopes) {
        String scopesStr = "";
        int scopesLength = scopes.length;
        int i = 0;
        for (String scope : scopes) {
            scopesStr = scopesStr + scope;
            if (scopesLength == ++i) continue;
            scopesStr = scopesStr + " ";
        }
        this.request = this.request + "&scope=" + scopesStr;
        this.oAuthTokenRequest.setScopes(scopes);
        return this;
    }

    public OAuthTokenRequestBuilder setPassword(char[] password) {
        this.request = this.request + "&password=" + new String(password);
        this.oAuthTokenRequest.setPassword(password);
        return this;
    }

    public OAuthTokenRequestBuilder setUsername(String username) {
        this.request = this.request + "&username=" + username;
        this.oAuthTokenRequest.setUsername(username);
        return this;
    }

    public OAuthTokenRequestBuilder setGrantType(String grantType) {
        this.request = "grant_type=" + grantType;
        this.oAuthTokenRequest.setGrantType(grantType);
        return this;
    }
}

