/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.rest.APIListDTO;
import org.wso2.apimgt.gateway.cli.model.rest.Endpoint;
import org.wso2.apimgt.gateway.cli.model.rest.EndpointConfig;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyListDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyListDTO;
import org.wso2.apimgt.gateway.cli.rest.RESTAPIService;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.TokenManagementUtil;

public class RESTAPIServiceImpl
implements RESTAPIService {
    private String publisherEp;
    private String adminEp;

    public RESTAPIServiceImpl(String publisherEp, String adminEp) {
        this.publisherEp = publisherEp;
        this.adminEp = adminEp;
    }

    @Override
    public List<ExtendedAPI> getAPIs(String labelName, String accessToken) {
        APIListDTO apiListDTO;
        block9: {
            HttpURLConnection urlConn = null;
            apiListDTO = null;
            try {
                this.publisherEp = this.publisherEp.endsWith("/") ? this.publisherEp : this.publisherEp + "/";
                String urlStr = this.publisherEp + "apis?query=label:${label}%20status:PUBLISHED&expand=true".replace("${label}", URLEncoder.encode(labelName, "UTF-8"));
                URL url = new URL(urlStr);
                urlConn = (HttpURLConnection)url.openConnection();
                urlConn.setDoOutput(true);
                urlConn.setRequestMethod("GET");
                urlConn.setRequestProperty("Authorization", "Bearer " + accessToken);
                int responseCode = urlConn.getResponseCode();
                if (responseCode == 200) {
                    ObjectMapper mapper = new ObjectMapper();
                    String responseStr = TokenManagementUtil.getResponseString(urlConn.getInputStream());
                    apiListDTO = (APIListDTO)mapper.readValue(responseStr, APIListDTO.class);
                    for (ExtendedAPI api : apiListDTO.getList()) {
                        String endpointConfig = api.getEndpointConfig();
                        api.setEndpointConfigRepresentation(this.getEndpointConfig(endpointConfig));
                        Config config = GatewayCmdUtils.getConfig();
                        if (config == null) {
                            if (api.getCorsConfiguration().getCorsConfigurationEnabled().booleanValue()) continue;
                            api.setCorsConfiguration(GatewayCmdUtils.getDefaultCorsConfig());
                            continue;
                        }
                        if (!config.getCorsConfiguration().getCorsConfigurationEnabled().booleanValue() || api.getCorsConfiguration().getCorsConfigurationEnabled().booleanValue()) continue;
                        api.setCorsConfiguration(config.getCorsConfiguration());
                    }
                    break block9;
                }
                throw new RuntimeException("Error occurred while getting token. Status code: " + responseCode);
            }
            catch (Exception e) {
                String msg = "Error while getting all APIs with label " + labelName;
                throw new RuntimeException(msg, e);
            }
            finally {
                if (urlConn != null) {
                    urlConn.disconnect();
                }
            }
        }
        return apiListDTO.getList();
    }

    @Override
    public List<ApplicationThrottlePolicyDTO> getApplicationPolicies(String accessToken) {
        ArrayList<ApplicationThrottlePolicyDTO> filteredPolicyDTOS;
        block8: {
            HttpURLConnection urlConn = null;
            filteredPolicyDTOS = new ArrayList<ApplicationThrottlePolicyDTO>();
            this.adminEp = this.adminEp.endsWith("/") ? this.adminEp : this.adminEp + "/";
            try {
                String urlStr = this.adminEp + "throttling/policies/application";
                URL url = new URL(urlStr);
                urlConn = (HttpURLConnection)url.openConnection();
                urlConn.setDoOutput(true);
                urlConn.setRequestMethod("GET");
                urlConn.setRequestProperty("Authorization", "Bearer " + accessToken);
                int responseCode = urlConn.getResponseCode();
                if (responseCode == 200) {
                    ObjectMapper mapper = new ObjectMapper();
                    String responseStr = TokenManagementUtil.getResponseString(urlConn.getInputStream());
                    ApplicationThrottlePolicyListDTO appsList = (ApplicationThrottlePolicyListDTO)mapper.readValue(responseStr, ApplicationThrottlePolicyListDTO.class);
                    List<ApplicationThrottlePolicyDTO> policyDTOS = appsList.getList();
                    for (ApplicationThrottlePolicyDTO policyDTO : policyDTOS) {
                        if ("Unlimited".equalsIgnoreCase(policyDTO.getPolicyName())) continue;
                        filteredPolicyDTOS.add(policyDTO);
                    }
                    break block8;
                }
                throw new RuntimeException("Error occurred while getting token. Status code: " + responseCode);
            }
            catch (Exception e) {
                String msg = "Error while creating the new token for token regeneration.";
                throw new RuntimeException(msg, e);
            }
            finally {
                if (urlConn != null) {
                    urlConn.disconnect();
                }
            }
        }
        return filteredPolicyDTOS;
    }

    @Override
    public List<SubscriptionThrottlePolicyDTO> getSubscriptionPolicies(String accessToken) {
        ArrayList<SubscriptionThrottlePolicyDTO> filteredPolicyDTOS;
        block8: {
            HttpURLConnection urlConn = null;
            filteredPolicyDTOS = new ArrayList<SubscriptionThrottlePolicyDTO>();
            this.adminEp = this.adminEp.endsWith("/") ? this.adminEp : this.adminEp + "/";
            try {
                String urlStr = this.adminEp + "throttling/policies/subscription";
                URL url = new URL(urlStr);
                urlConn = (HttpURLConnection)url.openConnection();
                urlConn.setDoOutput(true);
                urlConn.setRequestMethod("GET");
                urlConn.setRequestProperty("Authorization", "Bearer " + accessToken);
                int responseCode = urlConn.getResponseCode();
                if (responseCode == 200) {
                    ObjectMapper mapper = new ObjectMapper();
                    String responseStr = TokenManagementUtil.getResponseString(urlConn.getInputStream());
                    SubscriptionThrottlePolicyListDTO subsList = (SubscriptionThrottlePolicyListDTO)mapper.readValue(responseStr, SubscriptionThrottlePolicyListDTO.class);
                    List<SubscriptionThrottlePolicyDTO> policyDTOS = subsList.getList();
                    for (SubscriptionThrottlePolicyDTO policyDTO : policyDTOS) {
                        if ("Unlimited".equalsIgnoreCase(policyDTO.getPolicyName())) continue;
                        filteredPolicyDTOS.add(policyDTO);
                    }
                    break block8;
                }
                throw new RuntimeException("Error occurred while getting token. Status code: " + responseCode);
            }
            catch (Exception e) {
                String msg = "Error while creating the new token for token regeneration.";
                throw new RuntimeException(msg, e);
            }
            finally {
                if (urlConn != null) {
                    urlConn.disconnect();
                }
            }
        }
        return filteredPolicyDTOS;
    }

    private EndpointConfig getEndpointConfig(String endpointConfig) throws IOException {
        EndpointConfig endpointConf;
        block12: {
            String endpointType;
            JsonNode rootNode;
            block11: {
                JsonNode sandFailoverEndpointNode;
                JsonNode sandEndpointNode;
                ObjectMapper mapper = new ObjectMapper();
                rootNode = null;
                endpointConf = new EndpointConfig();
                rootNode = mapper.readTree(endpointConfig);
                endpointType = rootNode.path("endpoint_type").asText();
                endpointConf.setEndpointType(endpointType);
                if (!"http".equalsIgnoreCase(endpointType) && !"failover".equalsIgnoreCase(endpointType)) break block11;
                JsonNode prodEndpointNode = rootNode.get("production_endpoints");
                if (prodEndpointNode != null) {
                    Endpoint prod = new Endpoint();
                    prod.setEndpointUrl(prodEndpointNode.get("url").asText());
                    endpointConf.addProdEndpoint(prod);
                }
                if ((sandEndpointNode = rootNode.get("sandbox_endpoints")) != null) {
                    Endpoint sandbox = new Endpoint();
                    sandbox.setEndpointUrl(sandEndpointNode.get("url").asText());
                    endpointConf.addSandEndpoint(sandbox);
                }
                if (!"failover".equalsIgnoreCase(endpointType)) break block12;
                JsonNode prodFailoverEndpointNode = rootNode.withArray("production_failovers");
                if (prodFailoverEndpointNode != null) {
                    for (JsonNode node : prodFailoverEndpointNode) {
                        Endpoint endpoint = new Endpoint();
                        endpoint.setEndpointUrl(node.get("url").asText());
                        endpointConf.addProdFailoverEndpoint(endpoint);
                    }
                }
                if ((sandFailoverEndpointNode = rootNode.withArray("sandbox_failovers")) != null) {
                    for (JsonNode node : sandFailoverEndpointNode) {
                        Endpoint endpoint = new Endpoint();
                        endpoint.setEndpointUrl(node.get("url").asText());
                        endpointConf.addSandFailoverEndpoint(endpoint);
                    }
                }
                break block12;
            }
            if ("load_balance".equalsIgnoreCase(endpointType)) {
                JsonNode sandboxEndpoints;
                JsonNode prodEndpoints = rootNode.withArray("production_endpoints");
                if (prodEndpoints != null) {
                    for (JsonNode node : prodEndpoints) {
                        Endpoint endpoint = new Endpoint();
                        endpoint.setEndpointUrl(node.get("url").asText());
                        endpointConf.addProdEndpoint(endpoint);
                    }
                }
                if ((sandboxEndpoints = rootNode.withArray("sandbox_endpoints")) != null) {
                    for (JsonNode node : sandboxEndpoints) {
                        Endpoint endpoint = new Endpoint();
                        endpoint.setEndpointUrl(node.get("url").asText());
                        endpointConf.addSandEndpoint(endpoint);
                    }
                }
            }
        }
        return endpointConf;
    }
}

