/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import org.wso2.apimgt.gateway.cli.model.template.GenSrcFile;

public class CodegenUtils {
    public static void writeFile(Path filePath, String content) throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(filePath.toString(), "UTF-8");
            writer.print(content);
        }
    }

    public static Template compileTemplate(String defaultTemplateDir, String templateName) throws IOException {
        String templatesDirPath = System.getProperty("templates.dir.path", defaultTemplateDir);
        ClassPathTemplateLoader cpTemplateLoader = new ClassPathTemplateLoader(templatesDirPath);
        FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(templatesDirPath);
        cpTemplateLoader.setSuffix(".mustache");
        fileTemplateLoader.setSuffix(".mustache");
        Handlebars handlebars = new Handlebars().with(new TemplateLoader[]{cpTemplateLoader, fileTemplateLoader});
        handlebars.registerHelpers(StringHelpers.class);
        handlebars.registerHelper("equals", (object, options) -> {
            Object param0 = options.param(0);
            if (param0 == null) {
                throw new IllegalArgumentException("found 'null', expected 'string'");
            }
            CharSequence result = object != null ? (object.toString().equals(param0.toString()) ? options.fn(options.context) : options.inverse()) : null;
            return result;
        });
        return handlebars.compile(templateName);
    }

    public static void writeGeneratedSources(List<GenSrcFile> sources, Path srcPath, boolean overwrite) throws IOException {
        for (GenSrcFile file : sources) {
            Path filePath = srcPath.resolve(file.getFileName());
            if (Files.notExists(filePath, new LinkOption[0])) {
                CodegenUtils.writeFile(filePath, file.getContent());
                continue;
            }
            if (!overwrite) continue;
            Files.delete(filePath);
            CodegenUtils.writeFile(filePath, file.getContent());
        }
    }

    public static String trim(String key) {
        if (key == null) {
            return null;
        }
        key = key.replaceAll(" ", "_");
        key = key.replaceAll("/", "_");
        key = key.replaceAll("\\{", "_");
        if ((key = key.replaceAll("}", "_")).contains("*")) {
            key = key.replaceAll("\\*", UUID.randomUUID().toString().replaceAll("-", "_"));
        }
        return key;
    }
}

