/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.FileUtils;
import org.ballerinalang.config.cipher.AESCipherTool;
import org.ballerinalang.config.cipher.AESCipherToolException;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerationContext;
import org.wso2.apimgt.gateway.cli.config.TOMLConfigParser;
import org.wso2.apimgt.gateway.cli.constants.GatewayCliConstants;
import org.wso2.apimgt.gateway.cli.exception.CliLauncherException;
import org.wso2.apimgt.gateway.cli.exception.ConfigParserException;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.ContainerConfig;
import org.wso2.apimgt.gateway.cli.model.rest.APICorsConfigurationDTO;
import org.wso2.apimgt.gateway.cli.utils.ZipUtils;

public class GatewayCmdUtils {
    private static Config config;
    private static ContainerConfig containerConfig;
    private static CodeGenerationContext codeGenerationContext;

    public static Config getConfig() {
        return config;
    }

    public static void setConfig(Config configFromFile) {
        config = configFromFile;
    }

    public static void setCodeGenerationContext(CodeGenerationContext codeGenerationContext) {
        GatewayCmdUtils.codeGenerationContext = codeGenerationContext;
    }

    public static CodeGenerationContext getCodeGenerationContext() {
        return codeGenerationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String path, boolean inResource) throws IOException {
        InputStream is = null;
        is = inResource ? ClassLoader.getSystemResourceAsStream(path) : new FileInputStream(new File(path));
        InputStreamReader inputStreamREader = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            inputStreamREader = new InputStreamReader(is, StandardCharsets.UTF_8);
            br = new BufferedReader(inputStreamREader);
            String content = br.readLine();
            if (content == null) {
                String string = sb.toString();
                return string;
            }
            sb.append(content);
            while ((content = br.readLine()) != null) {
                sb.append('\n').append(content);
            }
        }
        finally {
            if (inputStreamREader != null) {
                try {
                    inputStreamREader.close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public static CliLauncherException createUsageException(String errorMsg) {
        CliLauncherException launcherException = new CliLauncherException();
        launcherException.addMessage("micro-gw: " + errorMsg);
        launcherException.addMessage("Run 'micro-gw help' for usage.");
        return launcherException;
    }

    public static String makeFirstLetterLowerCase(String s) {
        if (s == null) {
            return null;
        }
        char[] c = s.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    public static String encrypt(String value, String secret) {
        try {
            AESCipherTool cipherTool = new AESCipherTool(secret);
            return cipherTool.encrypt(value);
        }
        catch (AESCipherToolException e) {
            throw GatewayCmdUtils.createUsageException("failed to encrypt client secret");
        }
    }

    public static String decrypt(String value, String secret) {
        try {
            AESCipherTool cipherTool = new AESCipherTool(secret);
            return cipherTool.decrypt(value);
        }
        catch (AESCipherToolException e) {
            throw GatewayCmdUtils.createUsageException("failed to decrypt client secret");
        }
    }

    public static void storeWorkspaceLocation(String workspacePath) throws IOException {
        String tempDirPath = GatewayCmdUtils.getTempFolderLocation();
        GatewayCmdUtils.createFolderIfNotExist(tempDirPath);
        String projectRootHolderFileLocation = GatewayCmdUtils.getProjectRootHolderFileLocation();
        File pathFile = new File(projectRootHolderFileLocation);
        if (!pathFile.exists()) {
            pathFile.createNewFile();
        }
        GatewayCmdUtils.writeContent(workspacePath, pathFile);
    }

    public static String getStoredWorkspaceLocation() throws IOException {
        String workspaceLocation = GatewayCmdUtils.getProjectRootHolderFileLocation();
        if (new File(workspaceLocation).exists()) {
            return GatewayCmdUtils.readFileAsString(workspaceLocation, false);
        }
        return null;
    }

    public static String getCLIHome() {
        return System.getProperty("cli.home");
    }

    public static String getResourceFolderLocation() {
        return System.getProperty("cli.home") + File.separator + "resources";
    }

    public static String getLoggingPropertiesFileLocation() {
        return System.getProperty("cli.home") + File.separator + "conf" + File.separator + "logging.properties";
    }

    public static String getFiltersFolderLocation() {
        return GatewayCmdUtils.getResourceFolderLocation() + File.separator + "filters";
    }

    public static String getConfigFolderLocation() {
        return GatewayCmdUtils.getResourceFolderLocation() + File.separator + "conf";
    }

    private static String getProjectRootHolderFileLocation() {
        return GatewayCmdUtils.getTempFolderLocation() + File.separator + "workspace.txt";
    }

    private static String getTempFolderLocation() {
        return GatewayCmdUtils.getCLIHome() + File.separator + "temp";
    }

    public static void createMainProjectStructure(String root) {
        GatewayCmdUtils.createFolderIfNotExist(root);
        String mainResourceDirPath = root + File.separator + "micro-gw-resources";
        GatewayCmdUtils.createFolderIfNotExist(mainResourceDirPath);
        String mainProjectDirPath = mainResourceDirPath + File.separator + "projects";
        GatewayCmdUtils.createFolderIfNotExist(mainProjectDirPath);
    }

    public static void createLabelProjectStructure(String root, String labelName) {
        String mainResourceDir = root + File.separator + "micro-gw-resources";
        String mainProjectDir = mainResourceDir + File.separator + "projects";
        File labelDir = GatewayCmdUtils.createFolderIfNotExist(mainProjectDir + File.separator + labelName);
        String labelSrcDirPath = labelDir + File.separator + "src";
        GatewayCmdUtils.createFolderIfNotExist(labelSrcDirPath);
        String labelPolicySrcDirPath = labelSrcDirPath + File.separator + "policies";
        GatewayCmdUtils.createFolderIfNotExist(labelPolicySrcDirPath);
        String labelTargetDirPath = labelDir + File.separator + "target";
        GatewayCmdUtils.createFolderIfNotExist(labelTargetDirPath);
        String labelConfDirPath = labelDir + File.separator + "conf";
        GatewayCmdUtils.createFolderIfNotExist(labelConfDirPath);
    }

    public static void createLabelGWDistribution(String projectRoot, String labelName) throws IOException {
        GatewayCmdUtils.createTargetGatewayDistStructure(projectRoot, labelName);
        String distPath = GatewayCmdUtils.getTargetDistPath(projectRoot, labelName);
        String gwDistPath = GatewayCmdUtils.getTargetGatewayDistPath(projectRoot, labelName);
        GatewayCmdUtils.copyFolder(GatewayCmdUtils.getCLIHome() + File.separator + "lib" + File.separator + "runtime", gwDistPath + File.separator + "runtime");
        GatewayCmdUtils.copyTargetDistBinScripts(projectRoot, labelName);
        GatewayCmdUtils.copyTargetDistBalx(projectRoot, labelName);
        GatewayCmdUtils.copyFilesToSources(GatewayCmdUtils.getConfigFolderLocation() + File.separator + "micro-gw.conf", gwDistPath + File.separator + "conf" + File.separator + "micro-gw.conf");
        ZipUtils.zip(distPath, GatewayCmdUtils.getLabelTargetDirectoryPath(projectRoot, labelName) + File.separator + File.separator + "micro-gw-" + labelName + ".zip");
    }

    private static void createTargetGatewayDistStructure(String projectRoot, String labelName) {
        String labelTargetPath = GatewayCmdUtils.getLabelTargetDirectoryPath(projectRoot, labelName);
        GatewayCmdUtils.createFolderIfNotExist(labelTargetPath);
        String distPath = GatewayCmdUtils.getTargetDistPath(projectRoot, labelName);
        GatewayCmdUtils.createFolderIfNotExist(distPath);
        String distMicroGWPath = GatewayCmdUtils.getTargetGatewayDistPath(projectRoot, labelName);
        GatewayCmdUtils.createFolderIfNotExist(distMicroGWPath);
        String distBinPath = distMicroGWPath + File.separator + "bin";
        GatewayCmdUtils.createFolderIfNotExist(distBinPath);
        String distConfPath = distMicroGWPath + File.separator + "conf";
        GatewayCmdUtils.createFolderIfNotExist(distConfPath);
        String logsDirPath = distMicroGWPath + File.separator + "logs";
        GatewayCmdUtils.createFolderIfNotExist(logsDirPath);
        GatewayCmdUtils.createFileIfNotExist(logsDirPath, "access_logs");
        String distExec = distMicroGWPath + File.separator + "exec";
        GatewayCmdUtils.createFolderIfNotExist(distExec);
    }

    public static String loadStoredResourceHashes() throws IOException {
        String resourceHashFileLocation = GatewayCmdUtils.getResourceHashHolderFileLocation();
        String content = null;
        if (new File(resourceHashFileLocation).exists()) {
            content = GatewayCmdUtils.readFileAsString(resourceHashFileLocation, false);
        }
        return content;
    }

    public static void storeResourceHashesFileContent(String content) throws IOException {
        String tempDirPath = GatewayCmdUtils.getTempFolderLocation();
        GatewayCmdUtils.createFolderIfNotExist(tempDirPath);
        String resourceHashesFileLocation = GatewayCmdUtils.getResourceHashHolderFileLocation();
        File pathFile = new File(resourceHashesFileLocation);
        if (!pathFile.exists()) {
            pathFile.createNewFile();
        }
        GatewayCmdUtils.writeContent(content, pathFile);
    }

    private static String getResourceHashHolderFileLocation() {
        return GatewayCmdUtils.getTempFolderLocation() + File.separator + "hashes.json";
    }

    private static String getTargetDistPath(String projectRoot, String labelName) {
        String labelTargetPath = GatewayCmdUtils.getLabelTargetDirectoryPath(projectRoot, labelName);
        return labelTargetPath + File.separator + "distribution";
    }

    private static String getTargetGatewayDistPath(String projectRoot, String labelName) {
        String labelTargetPath = GatewayCmdUtils.getTargetDistPath(projectRoot, labelName);
        return labelTargetPath + File.separator + "micro-gw-" + labelName;
    }

    private static void copyTargetDistBinScripts(String projectRoot, String labelName) throws IOException {
        String linuxShContent = GatewayCmdUtils.readFileAsString(GatewayCliConstants.GW_DIST_SH_PATH, true);
        linuxShContent = linuxShContent.replace("${label}", labelName);
        String shTargetPath = GatewayCmdUtils.getTargetGatewayDistPath(projectRoot, labelName);
        File pathFile = new File(shTargetPath + File.separator + "bin" + File.separator + "micro-gw.sh");
        try (FileWriter writer = new FileWriter(pathFile);){
            writer.write(linuxShContent);
            pathFile.setExecutable(true);
        }
    }

    private static void copyTargetDistBalx(String projectRoot, String labelName) throws IOException {
        String labelTargetPath = GatewayCmdUtils.getLabelTargetDirectoryPath(projectRoot, labelName);
        String gatewayDistExecPath = GatewayCmdUtils.getTargetGatewayDistPath(projectRoot, labelName) + File.separator + "exec";
        File gatewayDistExecPathFile = new File(gatewayDistExecPath + File.separator + labelName + ".balx");
        File balxSourceFile = new File(labelTargetPath + File.separator + labelName + ".balx");
        if (balxSourceFile.exists()) {
            FileUtils.copyFile((File)balxSourceFile, (File)gatewayDistExecPathFile);
        } else {
            System.err.println(labelName + ".balx could not be found in " + labelTargetPath);
        }
    }

    public static String getMainConfigDirPath(String root) {
        return root + File.separator + "micro-gw-resources" + File.separator + "conf";
    }

    public static String getMainConfigLocation() {
        return GatewayCmdUtils.getCLIHome() + File.separator + "resources" + File.separator + "conf" + File.separator + "cli-config.toml";
    }

    public static String getLabelConfigDirPath(String root, String label) {
        return GatewayCmdUtils.getLabelDirectoryPath(root, label) + File.separator + "conf";
    }

    public static String getLabelConfigLocation(String root, String labelName) {
        return GatewayCmdUtils.getLabelConfigDirPath(root, labelName) + File.separator + "label-config.toml";
    }

    public static String getLabelDirectoryPath(String root, String labelName) {
        return root + File.separator + "micro-gw-resources" + File.separator + "projects" + File.separator + labelName;
    }

    public static String getLabelSrcDirectoryPath(String root, String labelName) {
        return GatewayCmdUtils.getLabelDirectoryPath(root, labelName) + File.separator + "src";
    }

    private static String getLabelTargetDirectoryPath(String root, String labelName) {
        return GatewayCmdUtils.getLabelDirectoryPath(root, labelName) + File.separator + "target";
    }

    public static void copyFolder(String source, String destination) throws IOException {
        File sourceFolder = new File(source);
        File destinationFolder = new File(destination);
        GatewayCmdUtils.copyFolder(sourceFolder, destinationFolder);
    }

    public static void copyFilesToSources(String sourcePath, String destinationPath) throws IOException {
        Files.copy(Paths.get(sourcePath, new String[0]), Paths.get(destinationPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    private static void copyFolder(File sourceFolder, File destinationFolder) throws IOException {
        if (sourceFolder.isDirectory()) {
            String[] files;
            if (!destinationFolder.exists()) {
                destinationFolder.mkdir();
            }
            if ((files = sourceFolder.list()) != null) {
                for (String file : files) {
                    File srcFile = new File(sourceFolder, file);
                    File destFile = new File(destinationFolder, file);
                    GatewayCmdUtils.copyFolder(srcFile, destFile);
                }
            }
        } else {
            Files.copy(sourceFolder.toPath(), destinationFolder.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static File createFolderIfNotExist(String path) {
        File folder = new File(path);
        if (!folder.exists() && !folder.isDirectory()) {
            folder.mkdir();
        }
        return folder;
    }

    private static void writeContent(String content, File file) throws IOException {
        try (FileWriter writer = null;){
            writer = new FileWriter(file);
            writer.write(content);
        }
    }

    private static void createFileIfNotExist(String path, String fileName) {
        String filePath = path + File.separator + fileName;
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void createLabelConfig(String root, String label) throws IOException {
        String mainConfig = GatewayCmdUtils.getLabelConfigDirPath(root, label) + File.separator + "label-config.toml";
        File file = new File(mainConfig);
        if (!file.exists()) {
            file.createNewFile();
            String defaultConfig = GatewayCmdUtils.readFileAsString("default-label-config.toml", true);
            GatewayCmdUtils.writeContent(defaultConfig, file);
        }
    }

    public static ContainerConfig getContainerConfig() {
        return containerConfig;
    }

    public static void setContainerConfig(ContainerConfig containerConfig) {
        GatewayCmdUtils.containerConfig = containerConfig;
    }

    public static void saveConfig(Config config, String configPath) {
        try {
            TOMLConfigParser.write(configPath, config);
        }
        catch (ConfigParserException e) {
            System.err.println("Error occurred while parsing configuration, when persisting.");
        }
    }

    public static APICorsConfigurationDTO getDefaultCorsConfig() {
        APICorsConfigurationDTO corsConfigurationDTO = new APICorsConfigurationDTO();
        corsConfigurationDTO.setAccessControlAllowCredentials(true);
        corsConfigurationDTO.setAccessControlAllowOrigins(GatewayCliConstants.accessControlAllowOrigins);
        corsConfigurationDTO.setAccessControlAllowMethods(GatewayCliConstants.accessControlAllowMethods);
        corsConfigurationDTO.setAccessControlAllowHeaders(GatewayCliConstants.accessControlAllowHeaders);
        corsConfigurationDTO.setAccessControlAllowCredentials(false);
        return corsConfigurationDTO;
    }
}

