/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;

@Parameters(commandNames={"build"}, commandDescription="micro gateway build information")
public class BuildCmd
implements GatewayLauncherCmd {
    private static final Logger logger = LoggerFactory.getLogger(BuildCmd.class);
    private static PrintStream outStream = System.err;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    @Parameter(hidden=true, required=true)
    private List<String> mainArgs;
    private String projectName;
    @Parameter(names={"--help", "-h", "?"}, hidden=true, description="for more information")
    private boolean helpFlag;

    @Override
    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = this.getCommandUsageInfo("build");
            outStream.println(commandUsageInfo);
            return;
        }
        try {
            this.projectName = GatewayCmdUtils.getProjectName(this.mainArgs);
            File projectLocation = new File(GatewayCmdUtils.getProjectDirectoryPath(this.projectName));
            if (!projectLocation.exists()) {
                throw new CLIRuntimeException("Project " + this.projectName + " does not exist.");
            }
            GatewayCmdUtils.createProjectGWDistribution(this.projectName);
            outStream.println("Build successful for the project - " + this.projectName);
        }
        catch (IOException e) {
            logger.error("Error occurred while creating the micro gateway distribution for the project {}.", (Object)this.projectName, (Object)e);
            throw new CLIInternalException("Error occurred while creating the micro gateway distribution for the project");
        }
    }

    @Override
    public String getName() {
        return "build";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }
}

