/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.packerina.init.InitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerationContext;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerator;
import org.wso2.apimgt.gateway.cli.codegen.ThrottlePolicyGenerator;
import org.wso2.apimgt.gateway.cli.config.TOMLConfigParser;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.exception.CliLauncherException;
import org.wso2.apimgt.gateway.cli.exception.ConfigParserException;
import org.wso2.apimgt.gateway.cli.exception.HashingException;
import org.wso2.apimgt.gateway.cli.hashing.HashUtils;
import org.wso2.apimgt.gateway.cli.model.config.Client;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.ContainerConfig;
import org.wso2.apimgt.gateway.cli.model.config.Token;
import org.wso2.apimgt.gateway.cli.model.config.TokenBuilder;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.oauth.OAuthServiceImpl;
import org.wso2.apimgt.gateway.cli.rest.RESTAPIServiceImpl;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;

@Parameters(commandNames={"setup"}, commandDescription="setup information")
public class SetupCmd
implements GatewayLauncherCmd {
    private static final Logger logger = LoggerFactory.getLogger(SetupCmd.class);
    private static PrintStream outStream = System.err;
    @Parameter(hidden=true, required=true)
    private List<String> mainArgs;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    @Parameter(names={"-u", "--username"}, hidden=true)
    private String username;
    @Parameter(names={"-p", "--password"}, hidden=true)
    private String password;
    @Parameter(names={"-l", "--label"}, hidden=true)
    private String label;
    @Parameter(names={"-s", "--server-url"}, hidden=true)
    private String baseUrl;
    @Parameter(names={"-t", "--truststore"}, hidden=true)
    private String trustStoreLocation;
    @Parameter(names={"-w", "--truststore-pass"}, hidden=true)
    private String trustStorePassword;
    @Parameter(names={"-c", "--config"}, hidden=true)
    private String toolkitConfigPath;
    @Parameter(names={"-d", "--deployment-config"}, hidden=true)
    private String deploymentConfigPath;
    @Parameter(names={"-a", "--api-name"}, hidden=true)
    private String apiName;
    @Parameter(names={"-v", "--version"}, hidden=true)
    private String version;
    @Parameter(names={"-f", "--force"}, hidden=true, arity=0)
    private boolean isForcefully;
    @Parameter(names={"-k", "--insecure"}, hidden=true, arity=0)
    private boolean isInsecure;
    private String publisherEndpoint;
    private String adminEndpoint;
    private String registrationEndpoint;
    private String tokenEndpoint;
    private String clientSecret;

    @Override
    public void execute() {
        boolean changesDetected;
        File trustStoreFile;
        String configuredTrustStorePass;
        String encryptedPass;
        String configuredTrustStore;
        String workspace = GatewayCmdUtils.getUserDir();
        String projectName = GatewayCmdUtils.getProjectName(this.mainArgs);
        this.validateAPIGetRequestParams(this.label, this.apiName, this.version);
        if (StringUtils.isEmpty((CharSequence)this.toolkitConfigPath)) {
            this.toolkitConfigPath = GatewayCmdUtils.getMainConfigLocation();
        }
        if (new File(workspace + File.separator + projectName).exists() && !this.isForcefully) {
            throw GatewayCmdUtils.createUsageException("Project name `" + projectName + "` already exist. use -f or --force to forcefully update the project directory.");
        }
        SetupCmd.init(projectName, this.toolkitConfigPath, this.deploymentConfigPath);
        Config config = GatewayCmdUtils.getConfig();
        boolean isOverwriteRequired = false;
        String configuredUser = config.getToken().getUsername();
        if (StringUtils.isEmpty((CharSequence)configuredUser)) {
            if (StringUtils.isEmpty((CharSequence)this.username)) {
                isOverwriteRequired = true;
                this.username = this.promptForTextInput("Enter Username: ");
                if (this.username.trim().isEmpty()) {
                    throw GatewayCmdUtils.createUsageException("Micro gateway setup failed: empty username.");
                }
            }
        } else {
            this.username = configuredUser;
        }
        if (StringUtils.isEmpty((CharSequence)this.password) && (this.password = this.promptForPasswordInput("Enter Password for " + this.username + ": ")).trim().isEmpty() && StringUtils.isEmpty((CharSequence)this.password)) {
            this.password = this.promptForPasswordInput("Password can't be empty; enter password for " + this.username + ": ");
            if (this.password.trim().isEmpty()) {
                throw GatewayCmdUtils.createUsageException("Micro gateway setup failed: empty password.");
            }
        }
        this.publisherEndpoint = config.getToken().getPublisherEndpoint();
        this.adminEndpoint = config.getToken().getAdminEndpoint();
        this.registrationEndpoint = config.getToken().getRegistrationEndpoint();
        this.tokenEndpoint = config.getToken().getTokenEndpoint();
        if (StringUtils.isEmpty((CharSequence)this.publisherEndpoint) || StringUtils.isEmpty((CharSequence)this.adminEndpoint) || StringUtils.isEmpty((CharSequence)this.registrationEndpoint) || StringUtils.isEmpty((CharSequence)this.tokenEndpoint)) {
            if (StringUtils.isEmpty((CharSequence)this.baseUrl)) {
                isOverwriteRequired = true;
                this.baseUrl = this.promptForTextInput("Enter APIM base URL [https://localhost:9443/]: ");
                if (this.baseUrl.trim().isEmpty()) {
                    this.baseUrl = "https://localhost:9443/";
                }
            }
            this.populateHosts(this.baseUrl);
        }
        if (StringUtils.isEmpty((CharSequence)(configuredTrustStore = config.getToken().getTrustStoreLocation()))) {
            if (StringUtils.isEmpty((CharSequence)this.trustStoreLocation)) {
                isOverwriteRequired = true;
                this.trustStoreLocation = this.promptForTextInput("Enter Trust store location: [lib/platform/bre/security/ballerinaTruststore.p12]");
                if (this.trustStoreLocation.trim().isEmpty()) {
                    this.trustStoreLocation = "lib/platform/bre/security/ballerinaTruststore.p12";
                }
            }
        } else {
            this.trustStoreLocation = configuredTrustStore;
        }
        if (StringUtils.isEmpty((CharSequence)(encryptedPass = config.getToken().getTrustStorePassword()))) {
            configuredTrustStorePass = null;
        } else {
            try {
                configuredTrustStorePass = GatewayCmdUtils.decrypt(encryptedPass, this.password);
            }
            catch (CliLauncherException e) {
                configuredTrustStorePass = null;
            }
        }
        if (StringUtils.isEmpty(configuredTrustStorePass)) {
            if (StringUtils.isEmpty((CharSequence)this.trustStorePassword)) {
                isOverwriteRequired = true;
                this.trustStorePassword = this.promptForPasswordInput("Enter Trust store password: [ use default? ]");
                if (this.trustStorePassword.trim().isEmpty()) {
                    this.trustStorePassword = "ballerina";
                }
            }
        } else {
            this.trustStorePassword = configuredTrustStorePass;
        }
        if (!(trustStoreFile = new File(this.trustStoreLocation)).isAbsolute()) {
            this.trustStoreLocation = GatewayCmdUtils.getUnixPath(GatewayCmdUtils.getCLIHome() + File.separator + this.trustStoreLocation);
        }
        if (!(trustStoreFile = new File(this.trustStoreLocation)).exists()) {
            logger.error("Provided trust store location {} does not exist.", (Object)this.trustStoreLocation);
            throw new CLIRuntimeException("Provided trust store location does not exist.");
        }
        System.setProperty("javax.net.ssl.keyStoreType", "pkcs12");
        System.setProperty("javax.net.ssl.trustStore", this.trustStoreLocation);
        System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
        OAuthServiceImpl manager = new OAuthServiceImpl();
        String clientID = config.getToken().getClientId();
        String encryptedSecret = config.getToken().getClientSecret();
        if (!StringUtils.isEmpty((CharSequence)clientID.trim()) && !StringUtils.isEmpty((CharSequence)encryptedSecret.trim())) {
            try {
                this.clientSecret = GatewayCmdUtils.decrypt(encryptedSecret, this.password);
            }
            catch (CliLauncherException e) {
                this.clientSecret = null;
            }
        }
        if (StringUtils.isEmpty((CharSequence)clientID) || StringUtils.isEmpty((CharSequence)this.clientSecret)) {
            String[] clientInfo = manager.generateClientIdAndSecret(this.registrationEndpoint, this.username, this.password.toCharArray(), this.isInsecure);
            clientID = clientInfo[0];
            this.clientSecret = clientInfo[1];
        }
        String accessToken = manager.generateAccessToken(this.tokenEndpoint, this.username, this.password.toCharArray(), clientID, this.clientSecret, this.isInsecure);
        List<Object> apis = new ArrayList();
        RESTAPIServiceImpl service = new RESTAPIServiceImpl(this.publisherEndpoint, this.adminEndpoint, this.isInsecure);
        if (this.label != null) {
            apis = service.getAPIs(this.label, accessToken);
        } else {
            ExtendedAPI api = service.getAPI(this.apiName, this.version, accessToken);
            if (api != null) {
                apis.add(api);
            }
        }
        if (apis == null || apis != null && apis.isEmpty()) {
            GatewayCmdUtils.deleteProject(workspace + File.separator + projectName);
            String errorMsg = this.label != null ? "No APIs found for the given label: " + this.label : "No Published APIs matched for name:" + this.apiName + ", version:" + this.version;
            throw new CLIRuntimeException(errorMsg);
        }
        List<ApplicationThrottlePolicyDTO> applicationPolicies = service.getApplicationPolicies(accessToken);
        List<SubscriptionThrottlePolicyDTO> subscriptionPolicies = service.getSubscriptionPolicies(accessToken);
        ThrottlePolicyGenerator policyGenerator = new ThrottlePolicyGenerator();
        CodeGenerator codeGenerator = new CodeGenerator();
        try {
            policyGenerator.generate(GatewayCmdUtils.getProjectSrcDirectoryPath(projectName) + File.separator + "policies", applicationPolicies, subscriptionPolicies);
            codeGenerator.generate(projectName, apis, true);
            InitHandler.initialize((Path)Paths.get(GatewayCmdUtils.getProjectDirectoryPath(projectName), new String[0]), null, new ArrayList(), null);
            try {
                changesDetected = HashUtils.detectChanges(apis, subscriptionPolicies, applicationPolicies, projectName);
            }
            catch (HashingException e) {
                logger.error("Error while checking for changes of resources. Skipping no-change detection..");
                throw new CLIInternalException("Error while checking for changes of resources. Skipping no-change detection..");
            }
        }
        catch (IOException | BallerinaServiceGenException e) {
            logger.error("Error while generating ballerina source.");
            throw new CLIInternalException("Error while generating ballerina source.");
        }
        if (isOverwriteRequired) {
            Config newConfig = new Config();
            Client client = new Client();
            client.setHttpRequestTimeout(1000000);
            newConfig.setClient(client);
            String encryptedCS = GatewayCmdUtils.encrypt(this.clientSecret, this.password);
            String encryptedTrustStorePass = GatewayCmdUtils.encrypt(this.trustStorePassword, this.password);
            Token token = new TokenBuilder().setPublisherEndpoint(this.publisherEndpoint).setAdminEndpoint(this.adminEndpoint).setRegistrationEndpoint(this.registrationEndpoint).setTokenEndpoint(this.tokenEndpoint).setUsername(this.username).setClientId(clientID).setClientSecret(encryptedCS).setTrustStoreLocation(this.trustStoreLocation).setTrustStorePassword(encryptedTrustStorePass).build();
            newConfig.setToken(token);
            newConfig.setCorsConfiguration(GatewayCmdUtils.getDefaultCorsConfig());
            GatewayCmdUtils.saveConfig(newConfig, this.toolkitConfigPath);
        }
        if (!changesDetected) {
            outStream.println("No changes received from the server since the previous setup. If you have already a built distribution, it can be reused.");
        }
        outStream.println("Setting up project " + projectName + " is successful.");
        if (!changesDetected) {
            Runtime.getRuntime().exit(34);
        }
    }

    private void validateAPIGetRequestParams(String label, String apiName, String version) {
        if (StringUtils.isEmpty((CharSequence)label) && (StringUtils.isEmpty((CharSequence)apiName) || StringUtils.isEmpty((CharSequence)version)) || StringUtils.isNotEmpty((CharSequence)label) && (StringUtils.isNotEmpty((CharSequence)apiName) || StringUtils.isNotEmpty((CharSequence)version)) || StringUtils.isEmpty((CharSequence)apiName) && StringUtils.isNotEmpty((CharSequence)version) || StringUtils.isNotEmpty((CharSequence)apiName) && StringUtils.isEmpty((CharSequence)version)) {
            throw GatewayCmdUtils.createUsageException("Either label (-l <label>) or API name (-a <api-name>) with version (-v <version>) should be provided.\n\nEx:\tmicro-gw setup accounts-project -l accounts\n\tmicro-gw setup pizzashack-project -a Pizzashack -v 1.0.0");
        }
    }

    @Override
    public String getName() {
        return "setup";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }

    private String promptForTextInput(String msg) {
        outStream.println(msg);
        return System.console().readLine();
    }

    private String promptForPasswordInput(String msg) {
        outStream.println(msg);
        return new String(System.console().readPassword());
    }

    private void populateHosts(String host) {
        try {
            this.publisherEndpoint = new URL(new URL(host), "/api/am/publisher/v0.13").toString();
            this.adminEndpoint = new URL(new URL(host), "/api/am/admin/v0.13").toString();
            this.registrationEndpoint = new URL(new URL(host), "/client-registration/v0.13/register").toString();
            this.tokenEndpoint = new URL(new URL(host), "/oauth2/token").toString();
        }
        catch (MalformedURLException e) {
            logger.error("Malformed URL provided {}", (Object)host);
            throw new CLIInternalException("Error occurred while setting up URL configurations.");
        }
    }

    private static void init(String projectName, String configPath, String deploymentConfigPath) {
        try {
            GatewayCmdUtils.createProjectStructure(projectName);
            GatewayCmdUtils.createDeploymentConfig(projectName, deploymentConfigPath);
            Path configurationFile = Paths.get(configPath, new String[0]);
            if (!Files.exists(configurationFile, new LinkOption[0])) {
                logger.error("Configuration: {} Not found.", (Object)configPath);
                throw new CLIInternalException("Error occurred while loading configurations.");
            }
            Config config = TOMLConfigParser.parse(configPath, Config.class);
            GatewayCmdUtils.setConfig(config);
            deploymentConfigPath = GatewayCmdUtils.getDeploymentConfigLocation(projectName);
            ContainerConfig containerConfig = TOMLConfigParser.parse(deploymentConfigPath, ContainerConfig.class);
            GatewayCmdUtils.setContainerConfig(containerConfig);
            CodeGenerationContext codeGenerationContext = new CodeGenerationContext();
            codeGenerationContext.setProjectName(projectName);
            GatewayCmdUtils.setCodeGenerationContext(codeGenerationContext);
        }
        catch (ConfigParserException e) {
            logger.error("Error occurred while parsing the configurations {}", (Object)configPath, (Object)e);
            throw new CLIInternalException("Error occurred while loading configurations.");
        }
        catch (IOException e) {
            logger.error("Error occurred while generating project configurationss", (Throwable)e);
            throw new CLIInternalException("Error occurred while loading configurations.");
        }
    }
}

