/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.codegen;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.wso2.apimgt.gateway.cli.constants.GeneratorConstants;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.template.GenSrcFile;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaService;
import org.wso2.apimgt.gateway.cli.model.template.service.ListenerEndpoint;
import org.wso2.apimgt.gateway.cli.utils.CodegenUtils;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;

public class CodeGenerator {
    public void generate(String projectName, List<ExtendedAPI> apis, boolean overwrite) throws IOException, BallerinaServiceGenException {
        String projectSrcPath = GatewayCmdUtils.getProjectSrcDirectoryPath(projectName);
        ArrayList<GenSrcFile> genFiles = new ArrayList<GenSrcFile>();
        Iterator<ExtendedAPI> iterator = apis.iterator();
        while (iterator.hasNext()) {
            SwaggerParser parser = new SwaggerParser();
            ExtendedAPI api = iterator.next();
            Swagger swagger = parser.parse(api.getApiDefinition());
            BallerinaService definitionContext = new BallerinaService().buildContext(swagger, api);
            if (definitionContext.getApi().getIsDefaultVersion().booleanValue()) {
                definitionContext.getApi().setIsDefaultVersion(false);
                genFiles.add(this.generateService(definitionContext));
                definitionContext.getApi().setIsDefaultVersion(true);
                definitionContext.setQualifiedServiceName(CodegenUtils.trim(api.getName()));
            }
            genFiles.add(this.generateService(definitionContext));
        }
        genFiles.add(this.generateCommonEndpoints());
        CodegenUtils.writeGeneratedSources(genFiles, Paths.get(projectSrcPath, new String[0]), overwrite);
        GatewayCmdUtils.copyFilesToSources(GatewayCmdUtils.getFiltersFolderLocation() + File.separator + "extension_filter.bal", projectSrcPath + File.separator + "extension_filter.bal");
    }

    private GenSrcFile generateService(BallerinaService context) throws IOException {
        String concatTitle = context.getQualifiedServiceName();
        String srcFile = concatTitle + ".bal";
        String mainContent = this.getContent(context, GeneratorConstants.DEFAULT_TEMPLATE_DIR, "service");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, mainContent);
    }

    private GenSrcFile generateCommonEndpoints() throws IOException {
        String srcFile = "listeners.bal";
        ListenerEndpoint listnerEndpoint = new ListenerEndpoint().buildContext();
        String endpointContent = this.getContent(listnerEndpoint, GeneratorConstants.DEFAULT_TEMPLATE_DIR, "listeners");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, endpointContent);
    }

    private String getContent(Object endpoints, String templateDir, String templateName) throws IOException {
        Template template = CodegenUtils.compileTemplate(templateDir, templateName);
        Context context = Context.newBuilder((Object)endpoints).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE}).build();
        return template.apply(context);
    }
}

