/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.codegen;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.wso2.apimgt.gateway.cli.constants.GeneratorConstants;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.template.GenSrcFile;
import org.wso2.apimgt.gateway.cli.model.template.policy.ThrottlePolicy;
import org.wso2.apimgt.gateway.cli.model.template.policy.ThrottlePolicyInitializer;
import org.wso2.apimgt.gateway.cli.utils.CodegenUtils;

public class ThrottlePolicyGenerator {
    public void generate(String outPath, List<ApplicationThrottlePolicyDTO> applicationPolicies, List<SubscriptionThrottlePolicyDTO> subscriptionPolicies) throws IOException, BallerinaServiceGenException {
        List<GenSrcFile> genFiles = this.generateApplicationPolicies(applicationPolicies);
        List<GenSrcFile> genSubsFiles = this.generateSubscriptionPolicies(subscriptionPolicies);
        genFiles.addAll(genSubsFiles);
        GenSrcFile initGenFile = this.generateInitBal(applicationPolicies, subscriptionPolicies);
        genFiles.add(initGenFile);
        CodegenUtils.writeGeneratedSources(genFiles, Paths.get(outPath, new String[0]), true);
    }

    private List<GenSrcFile> generateApplicationPolicies(List<ApplicationThrottlePolicyDTO> applicationPolicies) throws IOException {
        ArrayList<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        for (ApplicationThrottlePolicyDTO applicationPolicy : applicationPolicies) {
            ThrottlePolicy policyContext = new ThrottlePolicy().buildContext(applicationPolicy);
            sourceFiles.add(this.generatePolicy(policyContext));
        }
        return sourceFiles;
    }

    private List<GenSrcFile> generateSubscriptionPolicies(List<SubscriptionThrottlePolicyDTO> subscriptionPolicies) throws IOException, BallerinaServiceGenException {
        ArrayList<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        for (SubscriptionThrottlePolicyDTO subscriptionPolicy : subscriptionPolicies) {
            ThrottlePolicy policyContext = new ThrottlePolicy().buildContext(subscriptionPolicy);
            sourceFiles.add(this.generatePolicy(policyContext));
        }
        return sourceFiles;
    }

    private GenSrcFile generateInitBal(List<ApplicationThrottlePolicyDTO> applicationPolicies, List<SubscriptionThrottlePolicyDTO> subscriptionPolicies) throws IOException {
        ThrottlePolicyInitializer context = new ThrottlePolicyInitializer().buildAppContext(applicationPolicies).buildSubsContext(subscriptionPolicies);
        return this.generateInitBalFile(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void writeBallerina(Object object, String templateDir, String templateName, String outPath) throws IOException {
        try (PrintWriter writer = null;){
            Template template = CodegenUtils.compileTemplate(templateDir, templateName);
            Context context = Context.newBuilder((Object)object).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE}).build();
            writer = new PrintWriter(outPath, "UTF-8");
            writer.println(template.apply(context));
        }
    }

    private GenSrcFile generatePolicy(ThrottlePolicy context) throws IOException {
        String concatTitle = context.getPolicyType() + "_" + context.getName();
        String srcFile = concatTitle + ".bal";
        String mainContent = this.getContent(context, GeneratorConstants.DEFAULT_TEMPLATE_DIR, "policy");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, mainContent);
    }

    private GenSrcFile generateInitBalFile(ThrottlePolicyInitializer context) throws IOException {
        String concatTitle = "throttle_policy_initializer";
        String srcFile = concatTitle + ".bal";
        String mainContent = this.getPolicyInitContent(context, GeneratorConstants.DEFAULT_TEMPLATE_DIR, "policy_init");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, mainContent);
    }

    private String getContent(ThrottlePolicy object, String templateDir, String templateName) throws IOException {
        Template template = CodegenUtils.compileTemplate(templateDir, templateName);
        Context context = Context.newBuilder((Object)object).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE}).build();
        return template.apply(context);
    }

    private String getPolicyInitContent(ThrottlePolicyInitializer object, String templateDir, String templateName) throws IOException {
        Template template = CodegenUtils.compileTemplate(templateDir, templateName);
        Context context = Context.newBuilder((Object)object).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE}).build();
        return template.apply(context);
    }
}

