/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.model.template.service;

import io.swagger.models.ExternalDocs;
import io.swagger.models.Operation;
import io.swagger.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaParameter;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaSwaggerObject;

public class BallerinaOperation
implements BallerinaSwaggerObject<BallerinaOperation, Operation> {
    public static final String X_THROTTLING_TIER = "x-throttling-tier";
    public static final String X_SCOPE = "x-scope";
    public static final String X_AUTH_TYPE = "x-auth-type";
    public static final String AUTH_TYPE_NONE = "None";
    private List<String> tags;
    private String summary;
    private String description;
    private String resourceTier;
    private ExternalDocs externalDocs;
    private String operationId;
    private List<BallerinaParameter> parameters;
    private List<String> methods;
    private String scope;
    private boolean isSecured = true;
    private final List<String> allMethods = Arrays.asList("HEAD", "OPTIONS", "PATCH", "DELETE", "POST", "PUT", "GET");

    @Override
    public BallerinaOperation buildContext(Operation operation, ExtendedAPI api) throws BallerinaServiceGenException {
        if (operation == null) {
            return this.getDefaultValue();
        }
        this.operationId = this.getTrimmedOperationId(operation.getOperationId());
        this.tags = operation.getTags();
        this.summary = operation.getSummary();
        this.description = operation.getDescription();
        this.externalDocs = operation.getExternalDocs();
        this.parameters = new ArrayList<BallerinaParameter>();
        this.methods = null;
        Map extension = operation.getVendorExtensions();
        Optional resourceTier = Optional.ofNullable(extension.get(X_THROTTLING_TIER));
        resourceTier.ifPresent(value -> {
            this.resourceTier = value.toString();
        });
        Optional scopes = Optional.ofNullable(extension.get(X_SCOPE));
        scopes.ifPresent(value -> {
            this.scope = value.toString();
        });
        Optional authType = Optional.ofNullable(extension.get(X_AUTH_TYPE));
        authType.ifPresent(value -> {
            if (AUTH_TYPE_NONE.equals(value)) {
                this.isSecured = false;
            }
        });
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                this.parameters.add(new BallerinaParameter().buildContext(parameter, api));
            }
        }
        return this;
    }

    @Override
    public BallerinaOperation buildContext(Operation operation) throws BallerinaServiceGenException {
        return this.buildContext(operation, (ExtendedAPI)null);
    }

    private String getTrimmedOperationId(String operationId) {
        if (operationId == null) {
            return null;
        }
        return operationId.replaceAll(" ", "_");
    }

    @Override
    public BallerinaOperation getDefaultValue() {
        return new BallerinaOperation();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public List<BallerinaParameter> getParameters() {
        return this.parameters;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public List<String> getAllMethods() {
        return this.allMethods;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
    }

    public String getResourceTier() {
        return this.resourceTier;
    }

    public void setResourceTier(String resourceTier) {
        this.resourceTier = resourceTier;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isSecured() {
        return this.isSecured;
    }

    public void setSecured(boolean secured) {
        this.isSecured = secured;
    }
}

