/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.model.template.service;

import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;
import org.wso2.apimgt.gateway.cli.model.config.ContainerConfig;
import org.wso2.apimgt.gateway.cli.model.rest.EndpointConfig;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaOperation;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaPath;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaSwaggerObject;
import org.wso2.apimgt.gateway.cli.utils.CodegenUtils;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;

public class BallerinaService
implements BallerinaSwaggerObject<BallerinaService, Swagger> {
    private String name;
    private ExtendedAPI api;
    private ContainerConfig containerConfig;
    private EndpointConfig endpointConfig;
    private String srcPackage;
    private String modelPackage;
    private String qualifiedServiceName;
    private Info info = null;
    private ExternalDocs externalDocs = null;
    private Set<Map.Entry<String, String>> security = null;
    private List<Tag> tags = null;
    private Set<Map.Entry<String, BallerinaPath>> paths = null;

    @Override
    public BallerinaService buildContext(Swagger swagger) throws BallerinaServiceGenException {
        this.info = swagger.getInfo();
        this.externalDocs = swagger.getExternalDocs();
        this.tags = swagger.getTags();
        this.containerConfig = GatewayCmdUtils.getContainerConfig();
        this.setPaths(swagger);
        return this;
    }

    @Override
    public BallerinaService buildContext(Swagger definition, ExtendedAPI api) throws BallerinaServiceGenException {
        this.name = CodegenUtils.trim(api.getName());
        this.api = api;
        this.qualifiedServiceName = CodegenUtils.trim(api.getName()) + "_" + this.replaceAllNonAlphaNumeric(api.getVersion());
        this.endpointConfig = api.getEndpointConfigRepresentation();
        return this.buildContext(definition);
    }

    @Override
    public BallerinaService getDefaultValue() {
        return null;
    }

    private void setPaths(Swagger swagger) throws BallerinaServiceGenException {
        if (swagger.getPaths() == null) {
            return;
        }
        this.paths = new LinkedHashSet<Map.Entry<String, BallerinaPath>>();
        Map pathList = swagger.getPaths();
        for (Map.Entry path : pathList.entrySet()) {
            BallerinaPath balPath = new BallerinaPath().buildContext((Path)path.getValue(), this.api);
            balPath.getOperations().forEach(operation -> {
                if (((BallerinaOperation)operation.getValue()).getOperationId() == null) {
                    String operationId = (String)operation.getKey() + "_" + UUID.randomUUID().toString().replaceAll("-", "_");
                    ((BallerinaOperation)operation.getValue()).setOperationId(operationId);
                }
            });
            this.paths.add(new AbstractMap.SimpleEntry(path.getKey(), balPath));
        }
    }

    public BallerinaService srcPackage(String srcPackage) {
        if (srcPackage != null) {
            this.srcPackage = srcPackage.replaceFirst("\\.", "/");
        }
        return this;
    }

    public BallerinaService modelPackage(String modelPackage) {
        if (modelPackage != null) {
            this.modelPackage = modelPackage.replaceFirst("\\.", "/");
        }
        return this;
    }

    public String getSrcPackage() {
        return this.srcPackage;
    }

    public String getModelPackage() {
        return this.modelPackage;
    }

    public Info getInfo() {
        return this.info;
    }

    public Set<Map.Entry<String, String>> getSecurity() {
        return this.security;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Set<Map.Entry<String, BallerinaPath>> getPaths() {
        return this.paths;
    }

    private String replaceAllNonAlphaNumeric(String value) {
        return value.replaceAll("[^a-zA-Z0-9]+", "_");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EndpointConfig getEndpointConfig() {
        return this.endpointConfig;
    }

    public void setEndpointConfig(EndpointConfig endpointConfig) {
        this.endpointConfig = endpointConfig;
    }

    public ExtendedAPI getApi() {
        return this.api;
    }

    public void setApi(ExtendedAPI api) {
        this.api = api;
    }

    public String getQualifiedServiceName() {
        return this.qualifiedServiceName;
    }

    public void setQualifiedServiceName(String qualifiedServiceName) {
        this.qualifiedServiceName = qualifiedServiceName;
    }

    public ContainerConfig getContainerConfig() {
        return this.containerConfig;
    }

    public void setContainerConfig(ContainerConfig containerConfig) {
        this.containerConfig = containerConfig;
    }
}

