/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.oauth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.oauth.OAuthService;
import org.wso2.apimgt.gateway.cli.oauth.builder.DCRRequestBuilder;
import org.wso2.apimgt.gateway.cli.oauth.builder.OAuthTokenRequestBuilder;
import org.wso2.apimgt.gateway.cli.utils.TokenManagementUtil;

public class OAuthServiceImpl
implements OAuthService {
    private static final Logger logger = LoggerFactory.getLogger(OAuthServiceImpl.class);

    @Override
    public String generateAccessToken(String tokenEndpoint, String username, char[] password, String clientId, String clientSecret, boolean inSecure) {
        HttpURLConnection urlConn = null;
        try {
            URL url = new URL(tokenEndpoint);
            urlConn = (HttpsURLConnection)url.openConnection();
            if (inSecure) {
                ((HttpsURLConnection)urlConn).setHostnameVerifier((s, sslSession) -> true);
            }
            urlConn.setRequestMethod("POST");
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String clientEncoded = DatatypeConverter.printBase64Binary((byte[])(clientId + ':' + clientSecret).getBytes(StandardCharsets.UTF_8));
            urlConn.setRequestProperty("Authorization", "Basic " + clientEncoded);
            urlConn.setDoOutput(true);
            String postBody = new OAuthTokenRequestBuilder().setClientKey(clientId).setClientSecret(clientSecret.toCharArray()).setGrantType("password").setPassword(password).setScopes(new String[]{"apim:tier_view", "apim:api_view"}).setUsername(username).requestBody();
            urlConn.getOutputStream().write(postBody.getBytes("UTF-8"));
            int responseCode = urlConn.getResponseCode();
            if (responseCode == 200) {
                ObjectMapper mapper = new ObjectMapper();
                String responseStr = TokenManagementUtil.getResponseString(urlConn.getInputStream());
                JsonNode rootNode = mapper.readTree(responseStr);
                String string = rootNode.path("access_token").asText();
                return string;
            }
            try {
                throw new CLIInternalException("Error occurred while getting the token. Status code: " + responseCode);
            }
            catch (IOException e) {
                String serverUrl = this.getServerUrl(tokenEndpoint);
                throw new CLIRuntimeException("Error occurred while trying to connect with server. Is the server running at " + serverUrl + "?", "Error occurred while trying to connect with token endpoint: " + tokenEndpoint, 1, e);
            }
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
        }
    }

    @Override
    public String[] generateClientIdAndSecret(String dcrEndpoint, String username, char[] password, boolean inSecure) {
        HttpURLConnection urlConn = null;
        try {
            String requestBody = new DCRRequestBuilder().setCallbackUrl("https://wso2.org").setClientName("Micro Gateway Cli").setOwner(username).setSaasApp(true).setGrantTypes(new String[]{"password"}).setTokenScope("PRODUCTION").requestBody();
            ObjectMapper mapper = new ObjectMapper();
            URL url = new URL(dcrEndpoint);
            urlConn = (HttpsURLConnection)url.openConnection();
            if (inSecure) {
                ((HttpsURLConnection)urlConn).setHostnameVerifier((s, sslSession) -> true);
            }
            urlConn.setRequestMethod("POST");
            urlConn.setRequestProperty("Content-Type", "application/json");
            urlConn.setDoOutput(true);
            String clientEncoded = DatatypeConverter.printBase64Binary((byte[])(username + ':' + new String(password)).getBytes(StandardCharsets.UTF_8));
            urlConn.setRequestProperty("Authorization", "Basic " + clientEncoded);
            urlConn.getOutputStream().write(requestBody.getBytes("UTF-8"));
            logger.debug("DCR URL: {}", (Object)dcrEndpoint);
            logger.trace("Request body for DCR call: {}", (Object)requestBody);
            int responseCode = urlConn.getResponseCode();
            if (responseCode == 200) {
                String responseStr = TokenManagementUtil.getResponseString(urlConn.getInputStream());
                logger.debug("Received response status code for DCR call: {}", (Object)responseCode);
                logger.trace("Received response body for DCR call: {}", (Object)responseStr);
                JsonNode rootNode = mapper.readTree(responseStr);
                JsonNode clientIdNode = rootNode.path("clientId");
                JsonNode clientSecretNode = rootNode.path("clientSecret");
                String clientId = clientIdNode.asText();
                String clientSecret = clientSecretNode.asText();
                String[] clientInfo = new String[]{clientId, clientSecret};
                logger.debug("Successfully received client id:{} from DCR endpoint", (Object)clientId);
                String[] stringArray = clientInfo;
                return stringArray;
            }
            try {
                if (responseCode == 401) {
                    throw new CLIRuntimeException("Invalid user credentials or the user does not have required permissions");
                }
                throw new CLIInternalException("Error occurred while creating oAuth application Status code: " + responseCode);
            }
            catch (IOException e) {
                String serverUrl = this.getServerUrl(dcrEndpoint);
                throw new CLIRuntimeException("Error occurred while trying to connect with server. Is the server running at " + serverUrl + "?", "Error occurred while communicate with DCR endpoint: " + dcrEndpoint, 1, e);
            }
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
        }
    }

    private String getServerUrl(String dcrEndpoint) {
        String[] serverUrlParts;
        return String.join((CharSequence)"/", Arrays.copyOfRange(serverUrlParts, 0, (serverUrlParts = dcrEndpoint.split("/", 4)).length >= 3 ? 3 : serverUrlParts.length));
    }
}

