/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.ballerinalang.config.cipher.AESCipherTool;
import org.ballerinalang.config.cipher.AESCipherToolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerationContext;
import org.wso2.apimgt.gateway.cli.config.TOMLConfigParser;
import org.wso2.apimgt.gateway.cli.constants.GatewayCliConstants;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.exception.CliLauncherException;
import org.wso2.apimgt.gateway.cli.exception.ConfigParserException;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.ContainerConfig;
import org.wso2.apimgt.gateway.cli.model.rest.APICorsConfigurationDTO;
import org.wso2.apimgt.gateway.cli.utils.ZipUtils;

public class GatewayCmdUtils {
    private static final Logger logger = LoggerFactory.getLogger(GatewayCmdUtils.class);
    private static Config config;
    private static ContainerConfig containerConfig;
    private static CodeGenerationContext codeGenerationContext;

    public static Config getConfig() {
        return config;
    }

    public static void setConfig(Config configFromFile) {
        config = configFromFile;
    }

    public static void setCodeGenerationContext(CodeGenerationContext codeGenerationContext) {
        GatewayCmdUtils.codeGenerationContext = codeGenerationContext;
    }

    public static CodeGenerationContext getCodeGenerationContext() {
        return codeGenerationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String path, boolean inResource) throws IOException {
        InputStream is;
        if (inResource) {
            path = GatewayCmdUtils.getUnixPath(path);
            is = ClassLoader.getSystemResourceAsStream(path);
        } else {
            is = new FileInputStream(new File(path));
        }
        InputStreamReader inputStreamREader = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            inputStreamREader = new InputStreamReader(is, StandardCharsets.UTF_8);
            br = new BufferedReader(inputStreamREader);
            String content = br.readLine();
            if (content == null) {
                String string = sb.toString();
                return string;
            }
            sb.append(content);
            while ((content = br.readLine()) != null) {
                sb.append('\n').append(content);
            }
        }
        finally {
            if (inputStreamREader != null) {
                try {
                    inputStreamREader.close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public static CliLauncherException createUsageException(String errorMsg) {
        CliLauncherException launcherException = new CliLauncherException();
        launcherException.addMessage("micro-gw: " + errorMsg);
        launcherException.addMessage("Run 'micro-gw help' for usage.");
        return launcherException;
    }

    public static String makeFirstLetterLowerCase(String s) {
        if (s == null) {
            return null;
        }
        char[] c = s.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    public static String encrypt(String value, String secret) {
        try {
            AESCipherTool cipherTool = new AESCipherTool(secret);
            return cipherTool.encrypt(value);
        }
        catch (AESCipherToolException e) {
            throw GatewayCmdUtils.createUsageException("failed to encrypt client secret");
        }
    }

    public static String decrypt(String value, String secret) {
        try {
            AESCipherTool cipherTool = new AESCipherTool(secret);
            return cipherTool.decrypt(value);
        }
        catch (AESCipherToolException e) {
            throw GatewayCmdUtils.createUsageException("failed to decrypt client secret");
        }
    }

    public static String getUserDir() {
        String currentDirProp = System.getProperty("current.dir");
        if (currentDirProp != null) {
            return currentDirProp;
        }
        return System.getProperty("user.dir");
    }

    public static String getCLIHome() {
        return System.getProperty("cli.home");
    }

    private static String getResourceFolderLocation() {
        return System.getProperty("cli.home") + File.separator + "resources";
    }

    public static String getLoggingPropertiesFileLocation() {
        return System.getProperty("cli.home") + File.separator + "conf" + File.separator + "logging.properties";
    }

    public static String getFiltersFolderLocation() {
        return GatewayCmdUtils.getResourceFolderLocation() + File.separator + "filters";
    }

    private static String getConfigFolderLocation() {
        return GatewayCmdUtils.getResourceFolderLocation() + File.separator + "conf";
    }

    private static String getProjectTempFolderLocation(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "temp";
    }

    public static void createProjectStructure(String projectName) {
        File projectDir = GatewayCmdUtils.createFolderIfNotExist(GatewayCmdUtils.getUserDir() + File.separator + projectName);
        String srcDirPath = projectDir + File.separator + "src";
        GatewayCmdUtils.createFolderIfNotExist(srcDirPath);
        String policyDirPath = srcDirPath + File.separator + "policies";
        GatewayCmdUtils.createFolderIfNotExist(policyDirPath);
        String targetDirPath = projectDir + File.separator + "target";
        GatewayCmdUtils.createFolderIfNotExist(targetDirPath);
        String confDirPath = projectDir + File.separator + "conf";
        GatewayCmdUtils.createFolderIfNotExist(confDirPath);
    }

    public static void createProjectGWDistribution(String projectName) throws IOException {
        GatewayCmdUtils.createTargetGatewayDistStructure(projectName);
        String distPath = GatewayCmdUtils.getTargetDistPath(projectName);
        String gwDistPath = GatewayCmdUtils.getTargetGatewayDistPath(projectName);
        GatewayCmdUtils.copyFolder(GatewayCmdUtils.getCLIHome() + File.separator + "lib" + File.separator + "runtime", gwDistPath + File.separator + "runtime");
        GatewayCmdUtils.copyTargetDistBinScripts(projectName);
        GatewayCmdUtils.copyTargetDistBalx(projectName);
        GatewayCmdUtils.copyFilesToSources(GatewayCmdUtils.getConfigFolderLocation() + File.separator + "micro-gw.conf", gwDistPath + File.separator + "conf" + File.separator + "micro-gw.conf");
        String targetPath = GatewayCmdUtils.getProjectTargetDirectoryPath(projectName);
        String zipFileName = "micro-gw-" + projectName + ".zip";
        ZipUtils.zip(distPath, targetPath + File.separator + zipFileName);
        GatewayCmdUtils.cleanFolder(targetPath, (String[])ArrayUtils.add((Object[])GatewayCliConstants.PROJECTS_TARGET_DELETE_FILES, (Object)(projectName + ".balx")));
    }

    private static void createTargetGatewayDistStructure(String projectName) {
        String projectTargetPath = GatewayCmdUtils.getProjectTargetDirectoryPath(projectName);
        GatewayCmdUtils.createFolderIfNotExist(projectTargetPath);
        String distPath = GatewayCmdUtils.getTargetDistPath(projectName);
        GatewayCmdUtils.createFolderIfNotExist(distPath);
        String distMicroGWPath = GatewayCmdUtils.getTargetGatewayDistPath(projectName);
        GatewayCmdUtils.createFolderIfNotExist(distMicroGWPath);
        String distBinPath = distMicroGWPath + File.separator + "bin";
        GatewayCmdUtils.createFolderIfNotExist(distBinPath);
        String distConfPath = distMicroGWPath + File.separator + "conf";
        GatewayCmdUtils.createFolderIfNotExist(distConfPath);
        String logsDirPath = distMicroGWPath + File.separator + "logs";
        GatewayCmdUtils.createFolderIfNotExist(logsDirPath);
        GatewayCmdUtils.createFileIfNotExist(logsDirPath, "access_logs");
        String distExec = distMicroGWPath + File.separator + "exec";
        GatewayCmdUtils.createFolderIfNotExist(distExec);
        String apiUsageDir = distMicroGWPath + File.separator + "api-usage-data";
        GatewayCmdUtils.createFolderIfNotExist(apiUsageDir);
    }

    public static String loadStoredResourceHashes(String projectName) throws IOException {
        String resourceHashFileLocation = GatewayCmdUtils.getResourceHashHolderFileLocation(projectName);
        String content = null;
        if (new File(resourceHashFileLocation).exists()) {
            content = GatewayCmdUtils.readFileAsString(resourceHashFileLocation, false);
        }
        return content;
    }

    public static void storeResourceHashesFileContent(String content, String projectName) throws IOException {
        String tempDirPath = GatewayCmdUtils.getProjectTempFolderLocation(projectName);
        GatewayCmdUtils.createFolderIfNotExist(tempDirPath);
        String resourceHashesFileLocation = GatewayCmdUtils.getResourceHashHolderFileLocation(projectName);
        File pathFile = new File(resourceHashesFileLocation);
        if (!pathFile.exists()) {
            boolean created = pathFile.createNewFile();
            if (created) {
                logger.trace("Hashed file: {} created. ", (Object)resourceHashesFileLocation);
            } else {
                logger.error("Failed to create hash file: {} ", (Object)resourceHashesFileLocation);
                throw new CLIInternalException("Error occurred while setting up the workspace structure");
            }
        }
        GatewayCmdUtils.writeContent(content, pathFile);
    }

    public static String getProjectName(List<String> mainArgs) {
        if (mainArgs.size() != 1) {
            throw new CLIRuntimeException("Only one argument accepted as the project name, but provided: " + String.join((CharSequence)",", mainArgs));
        }
        return mainArgs.get(0);
    }

    private static String getResourceHashHolderFileLocation(String projectName) {
        return GatewayCmdUtils.getProjectTempFolderLocation(projectName) + File.separator + "hashes.json";
    }

    private static String getTargetDistPath(String projectName) {
        return GatewayCmdUtils.getProjectTargetDirectoryPath(projectName) + File.separator + "distribution";
    }

    private static String getTargetGatewayDistPath(String projectName) {
        return GatewayCmdUtils.getTargetDistPath(projectName) + File.separator + "micro-gw-" + projectName;
    }

    private static void copyTargetDistBinScripts(String projectName) throws IOException {
        String targetPath = GatewayCmdUtils.getTargetGatewayDistPath(projectName);
        String binDir = targetPath + File.separator + "bin" + File.separator;
        String linuxShContent = GatewayCmdUtils.readFileAsString(GatewayCliConstants.GW_DIST_SH_PATH, true);
        linuxShContent = linuxShContent.replace("${label}", projectName);
        File shPathFile = new File(binDir + "gateway");
        GatewayCmdUtils.saveScript(linuxShContent, shPathFile);
        String winBatContent = GatewayCmdUtils.readFileAsString(GatewayCliConstants.GW_DIST_BAT_PATH, true);
        winBatContent = winBatContent.replace("${label}", projectName);
        File batPathFile = new File(binDir + "gateway.bat");
        GatewayCmdUtils.saveScript(winBatContent, batPathFile);
    }

    private static void copyTargetDistBalx(String projectName) throws IOException {
        String projectTargetDirectoryPath = GatewayCmdUtils.getProjectTargetDirectoryPath(projectName);
        String gatewayDistExecPath = GatewayCmdUtils.getTargetGatewayDistPath(projectName) + File.separator + "exec";
        File gatewayDistExecPathFile = new File(gatewayDistExecPath + File.separator + projectName + ".balx");
        File balxSourceFile = new File(projectTargetDirectoryPath + File.separator + projectName + ".balx");
        if (!balxSourceFile.exists()) {
            throw new CLIInternalException(projectName + ".balx could not be found in " + projectTargetDirectoryPath);
        }
        FileUtils.copyFile((File)balxSourceFile, (File)gatewayDistExecPathFile);
    }

    public static String getMainConfigLocation() {
        return GatewayCmdUtils.getCLIHome() + File.separator + "conf" + File.separator + "toolkit-config.toml";
    }

    private static String getProjectConfigDirPath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "conf";
    }

    public static String getDeploymentConfigLocation(String projectName) {
        return GatewayCmdUtils.getProjectConfigDirPath(projectName) + File.separator + "deployment-config.toml";
    }

    public static String getProjectDirectoryPath(String projectName) {
        return GatewayCmdUtils.getUserDir() + File.separator + projectName;
    }

    public static String getProjectSrcDirectoryPath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "src";
    }

    private static String getProjectTargetDirectoryPath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "target";
    }

    private static void copyFolder(String source, String destination) throws IOException {
        File sourceFolder = new File(source);
        File destinationFolder = new File(destination);
        GatewayCmdUtils.copyFolder(sourceFolder, destinationFolder);
    }

    public static void copyFilesToSources(String sourcePath, String destinationPath) throws IOException {
        Files.copy(Paths.get(sourcePath, new String[0]), Paths.get(destinationPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    private static void cleanFolder(String targetPath, String ... delete) throws IOException {
        File targetFolder = new File(targetPath);
        logger.debug("Cleaning the target folder: {}", (Object)targetPath);
        if (!targetFolder.isDirectory()) {
            logger.warn("Nothing to delete. Target folder {} is not a directory.", (Object)targetPath);
            return;
        }
        String[] files = targetFolder.list();
        if (files == null) {
            logger.warn("Nothing to delete. Target folder {} is empty.", (Object)targetPath);
            return;
        }
        for (String file : files) {
            for (String deleteFile : delete) {
                boolean success;
                if (!file.equals(deleteFile)) {
                    logger.trace("Keeping file: {}", (Object)file);
                    continue;
                }
                logger.trace("Deleting file: {}", (Object)file);
                File fileToDelete = new File(targetFolder, file);
                if (fileToDelete.isDirectory()) {
                    FileUtils.deleteDirectory((File)fileToDelete);
                    success = !fileToDelete.exists();
                } else {
                    success = fileToDelete.delete();
                }
                if (success) {
                    logger.trace("Deleting file {} is successful.", (Object)file);
                    continue;
                }
                logger.trace("Deleting file {} failed.", (Object)file);
            }
        }
        logger.debug("Cleaning the target folder {} complete.", (Object)targetPath);
    }

    private static void copyFolder(File sourceFolder, File destinationFolder) throws IOException {
        if (sourceFolder.isDirectory()) {
            String[] files;
            if (!destinationFolder.exists()) {
                boolean created = destinationFolder.mkdir();
                if (created) {
                    logger.trace("Directory: {} created. ", (Object)destinationFolder.getAbsolutePath());
                } else {
                    logger.error("Failed to create directory: {} ", (Object)destinationFolder.getAbsolutePath());
                    throw new CLIInternalException("Error occurred while setting up the workspace structure");
                }
            }
            if ((files = sourceFolder.list()) != null) {
                for (String file : files) {
                    File srcFile = new File(sourceFolder, file);
                    File destFile = new File(destinationFolder, file);
                    GatewayCmdUtils.copyFolder(srcFile, destFile);
                }
            }
        } else {
            Files.copy(sourceFolder.toPath(), destinationFolder.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            boolean success = destinationFolder.setWritable(true);
            if (!success) {
                logger.debug("Setting write permission failed for {}", (Object)destinationFolder.getAbsolutePath());
            }
        }
    }

    private static File createFolderIfNotExist(String path) {
        File folder = new File(path);
        if (!folder.exists() && !folder.isDirectory()) {
            boolean created = folder.mkdir();
            if (created) {
                logger.trace("Directory: {} created. ", (Object)path);
            } else {
                logger.error("Failed to create directory: {} ", (Object)path);
                throw new CLIInternalException("Error occurred while setting up the workspace structure");
            }
        }
        return folder;
    }

    private static void writeContent(String content, File file) throws IOException {
        try (FileWriter writer = null;){
            writer = new FileWriter(file);
            writer.write(content);
        }
    }

    private static void createFileIfNotExist(String path, String fileName) {
        String filePath = path + File.separator + fileName;
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                boolean created = file.createNewFile();
                if (!created) {
                    logger.error("Failed to create file: {} ", (Object)path);
                    throw new CLIInternalException("Error occurred while setting up the workspace structure");
                }
                logger.trace("File: {} created. ", (Object)path);
            }
            catch (IOException e) {
                logger.error("Failed to create file: {} ", (Object)path, (Object)e);
                throw new CLIInternalException("Error occurred while setting up the workspace structure");
            }
        }
    }

    public static void createDeploymentConfig(String projectName, String deploymentConfPath) throws IOException {
        String depConfig = GatewayCmdUtils.getProjectConfigDirPath(projectName) + File.separator + "deployment-config.toml";
        File file = new File(depConfig);
        if (deploymentConfPath == null) {
            if (!file.exists()) {
                String defaultConfig = null;
                boolean created = file.createNewFile();
                if (!created) {
                    throw new CLIInternalException("Failed to create the deployment configuration file: " + depConfig);
                }
                logger.debug("Deployment configuration file: {} created.", (Object)depConfig);
                defaultConfig = GatewayCmdUtils.readFileAsString("default-deployment-config.toml", true);
                GatewayCmdUtils.writeContent(defaultConfig, file);
            }
        } else {
            File inputDepConfFile = new File(deploymentConfPath);
            if (inputDepConfFile.exists()) {
                String inputConfigContent = GatewayCmdUtils.readFileAsString(deploymentConfPath, false);
                try {
                    TOMLConfigParser.parse(deploymentConfPath, ContainerConfig.class);
                }
                catch (IllegalStateException | ConfigParserException e) {
                    throw new CLIRuntimeException("Error while reading deployment configuration file: " + deploymentConfPath + ". The content is invalid.", e);
                }
                GatewayCmdUtils.writeContent(inputConfigContent, file);
            } else {
                throw new CLIRuntimeException("Error while reading deployment configuration file. Probably the file path '" + deploymentConfPath + "' is invalid.");
            }
        }
    }

    public static ContainerConfig getContainerConfig() {
        return containerConfig;
    }

    public static void setContainerConfig(ContainerConfig containerConfig) {
        GatewayCmdUtils.containerConfig = containerConfig;
    }

    public static void saveConfig(Config config, String configPath) {
        try {
            TOMLConfigParser.write(configPath, config);
        }
        catch (ConfigParserException e) {
            System.err.println("Error occurred while parsing configuration, when persisting.");
        }
    }

    public static APICorsConfigurationDTO getDefaultCorsConfig() {
        APICorsConfigurationDTO corsConfigurationDTO = new APICorsConfigurationDTO();
        corsConfigurationDTO.setCorsConfigurationEnabled(true);
        corsConfigurationDTO.setAccessControlAllowOrigins(GatewayCliConstants.accessControlAllowOrigins);
        corsConfigurationDTO.setAccessControlAllowMethods(GatewayCliConstants.accessControlAllowMethods);
        corsConfigurationDTO.setAccessControlAllowHeaders(GatewayCliConstants.accessControlAllowHeaders);
        corsConfigurationDTO.setAccessControlAllowCredentials(false);
        return corsConfigurationDTO;
    }

    public static String getUnixPath(String path) {
        return path.replace(File.separator, "/");
    }

    private static void saveScript(String content, File path) throws IOException {
        block13: {
            try (FileWriter writer = new FileWriter(path);){
                writer.write(content);
                boolean success = path.setExecutable(true);
                if (success) {
                    logger.trace("File: {} is set to executable. ", (Object)path.getAbsolutePath());
                    break block13;
                }
                logger.error("Failed to set executable file: {} ", (Object)path.getAbsolutePath());
                throw new CLIInternalException("Error occurred while setting up the workspace structure");
            }
        }
    }

    public static void deleteProject(String projectPath) {
        File file = new File(projectPath);
        try {
            GatewayCmdUtils.delete(file);
        }
        catch (IOException e) {
            logger.error("Failed to delete project : {} ", (Object)projectPath, (Object)e);
        }
    }

    private static void delete(File file) throws IOException {
        for (File childFile : file.listFiles()) {
            if (childFile.isDirectory()) {
                GatewayCmdUtils.delete(childFile);
                continue;
            }
            if (childFile.delete()) continue;
            throw new IOException();
        }
        if (!file.delete()) {
            throw new IOException();
        }
    }
}

