/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.packerina.init.InitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerator;
import org.wso2.apimgt.gateway.cli.config.TOMLConfigParser;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.exception.CliLauncherException;
import org.wso2.apimgt.gateway.cli.exception.ConfigParserException;
import org.wso2.apimgt.gateway.cli.hashing.HashUtils;
import org.wso2.apimgt.gateway.cli.model.config.Client;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.Token;
import org.wso2.apimgt.gateway.cli.model.config.TokenBuilder;
import org.wso2.apimgt.gateway.cli.model.rest.ClientCertMetadataDTO;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.oauth.OAuthServiceImpl;
import org.wso2.apimgt.gateway.cli.rest.RESTAPIServiceImpl;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.JsonProcessingUtils;
import org.wso2.apimgt.gateway.cli.utils.OpenAPICodegenUtils;
import org.wso2.apimgt.gateway.cli.utils.RouteUtils;
import org.wso2.apimgt.gateway.cli.utils.grpc.GRPCUtils;

@Parameters(commandNames={"add api"}, commandDescription="add api to the microgateway")
public class AddAPICmd
implements GatewayLauncherCmd {
    private static final Logger logger = LoggerFactory.getLogger(AddAPICmd.class);
    private static PrintStream outStream = System.out;
    @Parameter(names={"--project"}, hidden=true)
    private String projectName;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    @Parameter(names={"-u", "--username"}, hidden=true)
    private String username;
    @Parameter(names={"-p", "--password"}, hidden=true)
    private String password;
    @Parameter(names={"-l", "--label"}, hidden=true)
    private String label;
    @Parameter(names={"-s", "--server-url"}, hidden=true)
    private String baseURL;
    @Parameter(names={"-oa", "--openapi"}, hidden=true)
    private String openApi;
    @Parameter(names={"-e", "--endpoint"}, hidden=true)
    private String endpoint;
    @Parameter(names={"-ec", "--endpoint-config"}, hidden=true)
    private String endpointConfig;
    @Parameter(names={"-t", "--truststore"}, hidden=true)
    private String trustStoreLocation;
    @Parameter(names={"-w", "--truststore-pass"}, hidden=true)
    private String trustStorePassword;
    @Parameter(names={"-c", "--config"}, hidden=true)
    private String toolkitConfigPath;
    @Parameter(names={"-d", "--deployment-config"}, hidden=true)
    private String deploymentConfigPath;
    @Parameter(names={"-a", "--api-name"}, hidden=true)
    private String apiName;
    @Parameter(names={"-v", "--version"}, hidden=true)
    private String version;
    @Parameter(names={"-f", "--force"}, hidden=true, arity=0)
    private boolean isForcefully;
    @Parameter(names={"-k", "--insecure"}, hidden=true, arity=0)
    private boolean isInsecure;
    @Parameter(names={"-sec", "--security"}, hidden=true)
    private String security;
    @Parameter(names={"-b", "--basepath"}, hidden=true)
    private String basepath;
    @Parameter(names={"-etcd", "--enable-etcd"}, hidden=true, arity=0)
    private boolean isEtcdEnabled;
    private String publisherEndpoint;
    private String adminEndpoint;
    private String registrationEndpoint;
    private String tokenEndpoint;
    private String clientSecret;
    private boolean isOverwriteRequired;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() {
        File trustStoreFile;
        String configuredTrustStorePass;
        String encryptedPass;
        boolean isOpenApi = StringUtils.isNotEmpty((CharSequence)this.openApi);
        this.isOverwriteRequired = false;
        this.projectName = GatewayCmdUtils.buildProjectName(this.projectName);
        RouteUtils.setRoutesConfigPath(GatewayCmdUtils.getProjectMgwDefinitionFilePath(this.projectName));
        if (!new File(File.separator + this.projectName).exists()) {
            throw GatewayCmdUtils.createUsageException("Project name `" + this.projectName + "` does not exist");
        }
        if (StringUtils.isEmpty((CharSequence)this.security)) {
            this.security = "oauth2";
        }
        if (StringUtils.isEmpty((CharSequence)this.toolkitConfigPath)) {
            this.toolkitConfigPath = GatewayCmdUtils.getMainConfigLocation();
        }
        AddAPICmd.init(this.toolkitConfigPath);
        Config config = GatewayCmdUtils.getConfig();
        if (isOpenApi) {
            String endpointConfigString;
            outStream.println("Loading Open Api Specification from Path: " + this.openApi);
            String api = OpenAPICodegenUtils.readJson(this.openApi);
            if (this.openApi.toLowerCase(Locale.ENGLISH).endsWith(".proto")) {
                String grpc = this.openApi;
                outStream.println("Loading ProtoBuff Api Specification from Path: " + grpc);
                GRPCUtils grpcUtils = new GRPCUtils(grpc);
                grpcUtils.execute();
                logger.debug("Successfully read the api definition file");
                CodeGenerator codeGenerator = new CodeGenerator();
                try {
                    if (StringUtils.isEmpty((CharSequence)this.endpointConfig) && StringUtils.isEmpty((CharSequence)this.endpoint) && (this.endpoint = GatewayCmdUtils.promptForTextInput(outStream, "Enter Endpoint URL: ")).trim().isEmpty()) {
                        throw GatewayCmdUtils.createUsageException("Micro gateway setup failed: empty endpoint.");
                    }
                    codeGenerator.generateGrpc(this.projectName, api, true);
                    logger.debug("Creating source artifacts");
                    InitHandler.initialize((Path)Paths.get(GatewayCmdUtils.getProjectDirectoryPath(this.projectName), new String[0]), null, new ArrayList(), null);
                    return;
                }
                catch (IOException | BallerinaServiceGenException e) {
                    logger.error("Error while generating ballerina source.", (Throwable)e);
                    throw new CLIInternalException("Error while generating ballerina source.");
                }
            }
            logger.debug("Successfully read the api definition file");
            String apiDefPath = Paths.get(this.openApi, new String[0]).toAbsolutePath().toString();
            String apiId = OpenAPICodegenUtils.generateAPIdForSwagger(apiDefPath);
            boolean isForcedUpdate = false;
            if (RouteUtils.hasApiInRoutesConfig(apiId) && !(isForcedUpdate = this.checkAPIAndProceed(apiId))) {
                outStream.println("add api command is aborted");
                return;
            }
            if (StringUtils.isEmpty((CharSequence)this.endpointConfig)) {
                if (StringUtils.isEmpty((CharSequence)this.endpoint) && (this.endpoint = GatewayCmdUtils.promptForTextInput(outStream, "Enter Endpoint URL: ")).trim().isEmpty()) {
                    throw GatewayCmdUtils.createUsageException("Micro gateway setup failed: empty endpoint.");
                }
                endpointConfigString = "{\"prod\": {\"type\": \"http\", \"endpoints\" : [\"" + this.endpoint.trim() + "\"]}}";
            } else {
                endpointConfigString = OpenAPICodegenUtils.readJson(this.endpointConfig);
            }
            if (StringUtils.isEmpty((CharSequence)this.basepath)) {
                this.basepath = OpenAPICodegenUtils.getBasePathFromSwagger(apiDefPath);
                if (StringUtils.isEmpty((CharSequence)this.basepath) && (this.basepath = GatewayCmdUtils.promptForTextInput(outStream, "Enter basePath: ")).trim().isEmpty()) {
                    throw GatewayCmdUtils.createUsageException("Micro gateway setup failed: empty basepath");
                }
            }
            try {
                GatewayCmdUtils.createPerAPIFolderStructure(this.projectName, apiId);
                JsonProcessingUtils.saveAPIMetadata(this.projectName, apiId, this.security);
                RouteUtils.saveGlobalEpAndBasepath(apiDefPath, this.basepath, endpointConfigString);
            }
            catch (Exception e) {
                if (isForcedUpdate) throw e;
                GatewayCmdUtils.deletePerAPIFolder(this.projectName, apiId);
                throw e;
            }
            try {
                String policyDir = GatewayCmdUtils.getProjectGenDirectoryPath(this.projectName) + File.separator + "policies";
                if (new File(policyDir).list().length != 0) return;
                GatewayCmdUtils.copyFolder(GatewayCmdUtils.getPoliciesFolderLocation(), GatewayCmdUtils.getProjectGenDirectoryPath(this.projectName) + File.separator + "policies");
                return;
            }
            catch (IOException e) {
                throw new CLIRuntimeException("cannot read source directory");
            }
        }
        this.validateAPIGetRequestParams(this.label, this.apiName, this.version);
        String configuredUser = config.getToken().getUsername();
        if (StringUtils.isEmpty((CharSequence)configuredUser)) {
            if (StringUtils.isEmpty((CharSequence)this.username)) {
                this.isOverwriteRequired = true;
                this.username = GatewayCmdUtils.promptForTextInput(outStream, "Enter Username: ");
                if (this.username.trim().isEmpty()) {
                    throw GatewayCmdUtils.createUsageException("Micro gateway setup failed: empty username.");
                }
            }
        } else {
            this.username = configuredUser;
        }
        if (StringUtils.isEmpty((CharSequence)this.password) && (this.password = this.promptForPasswordInput("Enter Password for " + this.username + ": ")).trim().isEmpty() && StringUtils.isEmpty((CharSequence)this.password)) {
            this.password = this.promptForPasswordInput("Password can't be empty; enter password for " + this.username + ": ");
            if (this.password.trim().isEmpty()) {
                throw GatewayCmdUtils.createUsageException("Micro gateway setup failed: empty password.");
            }
        }
        Token configToken = config.getToken();
        TokenBuilder configTokenValues = this.setEndpoints(configToken);
        String configuredTrustStore = config.getToken().getTrustStoreLocation();
        if (StringUtils.isEmpty((CharSequence)configuredTrustStore)) {
            if (StringUtils.isEmpty((CharSequence)this.trustStoreLocation)) {
                this.isOverwriteRequired = true;
                this.trustStoreLocation = GatewayCmdUtils.promptForTextInput(outStream, "Enter Trust store location: [lib/platform/bre/security/ballerinaTruststore.p12]");
                if (this.trustStoreLocation.trim().isEmpty()) {
                    this.trustStoreLocation = "lib/platform/bre/security/ballerinaTruststore.p12";
                }
            }
        } else {
            this.trustStoreLocation = configuredTrustStore;
        }
        if (StringUtils.isEmpty((CharSequence)(encryptedPass = config.getToken().getTrustStorePassword()))) {
            configuredTrustStorePass = null;
        } else {
            try {
                configuredTrustStorePass = GatewayCmdUtils.decrypt(encryptedPass, this.password);
            }
            catch (CliLauncherException e) {
                configuredTrustStorePass = null;
            }
        }
        if (StringUtils.isEmpty(configuredTrustStorePass)) {
            if (StringUtils.isEmpty((CharSequence)this.trustStorePassword)) {
                this.isOverwriteRequired = true;
                this.trustStorePassword = this.promptForPasswordInput("Enter Trust store password: [ use default? ]");
                if (this.trustStorePassword.trim().isEmpty()) {
                    this.trustStorePassword = "ballerina";
                }
            }
        } else {
            this.trustStorePassword = configuredTrustStorePass;
        }
        if (!(trustStoreFile = new File(this.trustStoreLocation)).isAbsolute()) {
            this.trustStoreLocation = GatewayCmdUtils.getUnixPath(GatewayCmdUtils.getCLIHome() + File.separator + this.trustStoreLocation);
        }
        if (!(trustStoreFile = new File(this.trustStoreLocation)).exists()) {
            logger.error("Provided trust store location {} does not exist.", (Object)this.trustStoreLocation);
            throw new CLIRuntimeException("Provided trust store location does not exist.");
        }
        System.setProperty("javax.net.ssl.keyStoreType", "pkcs12");
        System.setProperty("javax.net.ssl.trustStoreType", "pkcs12");
        System.setProperty("javax.net.ssl.trustStore", this.trustStoreLocation);
        System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
        OAuthServiceImpl manager = new OAuthServiceImpl();
        String clientID = config.getToken().getClientId();
        String encryptedSecret = config.getToken().getClientSecret();
        if (!StringUtils.isEmpty((CharSequence)clientID.trim()) && !StringUtils.isEmpty((CharSequence)encryptedSecret.trim())) {
            try {
                this.clientSecret = GatewayCmdUtils.decrypt(encryptedSecret, this.password);
            }
            catch (CliLauncherException e) {
                this.clientSecret = null;
            }
        }
        if (StringUtils.isEmpty((CharSequence)clientID) || StringUtils.isEmpty((CharSequence)this.clientSecret)) {
            String[] clientInfo = manager.generateClientIdAndSecret(this.registrationEndpoint, this.username, this.password.toCharArray(), this.isInsecure);
            clientID = clientInfo[0];
            this.clientSecret = clientInfo[1];
        }
        String accessToken = manager.generateAccessToken(this.tokenEndpoint, this.username, this.password.toCharArray(), clientID, this.clientSecret, this.isInsecure);
        List<Object> apis = new ArrayList();
        RESTAPIServiceImpl service = new RESTAPIServiceImpl(this.publisherEndpoint, this.adminEndpoint, this.isInsecure);
        if (this.label != null) {
            apis = service.getAPIs(this.label, accessToken);
        } else {
            ExtendedAPI api = service.getAPI(this.apiName, this.version, accessToken);
            if (api != null) {
                apis.add(api);
            }
        }
        if (apis == null || apis.isEmpty()) {
            GatewayCmdUtils.deleteProject(File.separator + this.projectName);
            String errorMsg = this.label != null ? "No APIs found for the given label: " + this.label : "No Published APIs matched for name:" + this.apiName + ", version:" + this.version;
            throw new CLIRuntimeException(errorMsg);
        }
        List<ApplicationThrottlePolicyDTO> applicationPolicies = service.getApplicationPolicies(accessToken);
        List<SubscriptionThrottlePolicyDTO> subscriptionPolicies = service.getSubscriptionPolicies(accessToken);
        List<ClientCertMetadataDTO> clientCertificates = service.getClientCertificates(accessToken);
        logger.info(String.valueOf(clientCertificates));
        JsonProcessingUtils.saveApplicationThrottlePolicies(this.projectName, applicationPolicies);
        JsonProcessingUtils.saveSubscriptionThrottlePolicies(this.projectName, subscriptionPolicies);
        JsonProcessingUtils.saveClientCertMetadata(this.projectName, clientCertificates);
        try {
            GatewayCmdUtils.saveSwaggerDefinitionForMultipleAPIs(this.projectName, apis);
            JsonProcessingUtils.saveAPIMetadataForMultipleAPIs(this.projectName, apis, this.security);
            RouteUtils.saveGlobalEpAndBasepath(apis, this.isForcefully);
        }
        catch (Exception e) {
            for (ExtendedAPI extendedAPI : apis) {
                String apiId = HashUtils.generateAPIId(extendedAPI.getName(), extendedAPI.getVersion());
                GatewayCmdUtils.deletePerAPIFolder(this.projectName, apiId);
            }
            throw e;
        }
        if (!this.isOverwriteRequired) return;
        Config newConfig = new Config();
        Client client = new Client();
        client.setHttpRequestTimeout(1000000);
        newConfig.setClient(client);
        String string = GatewayCmdUtils.encrypt(this.clientSecret, this.password);
        String encryptedTrustStorePass = GatewayCmdUtils.encrypt(this.trustStorePassword, this.password);
        Token token = configTokenValues.setUsername(this.username).setClientId(clientID).setClientSecret(string).setTrustStoreLocation(this.trustStoreLocation).setTrustStorePassword(encryptedTrustStorePass).build();
        newConfig.setToken(token);
        newConfig.setCorsConfiguration(GatewayCmdUtils.getDefaultCorsConfig());
        GatewayCmdUtils.saveConfig(newConfig, this.toolkitConfigPath);
    }

    private static void init(String configPath) {
        try {
            Path configurationFile = Paths.get(configPath, new String[0]);
            if (!Files.exists(configurationFile, new LinkOption[0])) {
                logger.error("Configuration: {} Not found.", (Object)configPath);
                throw new CLIInternalException("Error occurred while loading configurations.");
            }
            Config config = TOMLConfigParser.parse(configPath, Config.class);
            GatewayCmdUtils.setConfig(config);
        }
        catch (ConfigParserException e) {
            logger.error("Error occurred while parsing the configurations {}", (Object)configPath, (Object)e);
            throw new CLIInternalException("Error occurred while loading configurations.");
        }
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }

    private String promptForPasswordInput(String msg) {
        outStream.println(msg);
        return new String(System.console().readPassword());
    }

    private String getBaseURLfromCmd(String defaultBaseURL) {
        String userInputURL = GatewayCmdUtils.promptForTextInput(outStream, "Enter APIM base URL [" + defaultBaseURL + "]: ").trim();
        return userInputURL;
    }

    private TokenBuilder setEndpoints(Token token) {
        boolean isRestVersionNeeded;
        TokenBuilder configTokenValues = new TokenBuilder();
        String restVersion = token.getRestVersion();
        this.publisherEndpoint = token.getPublisherEndpoint();
        this.adminEndpoint = token.getAdminEndpoint();
        this.registrationEndpoint = token.getRegistrationEndpoint();
        this.tokenEndpoint = token.getTokenEndpoint();
        configTokenValues.setPublisherEndpoint(this.publisherEndpoint);
        configTokenValues.setAdminEndpoint(this.adminEndpoint);
        configTokenValues.setRegistrationEndpoint(this.registrationEndpoint);
        configTokenValues.setTokenEndpoint(this.tokenEndpoint);
        configTokenValues.setRestVersion(restVersion);
        configTokenValues.setBaseURL(token.getBaseURL());
        boolean isEndPointsNeeded = StringUtils.isEmpty((CharSequence)this.publisherEndpoint) || StringUtils.isEmpty((CharSequence)this.adminEndpoint) || StringUtils.isEmpty((CharSequence)this.registrationEndpoint) || StringUtils.isEmpty((CharSequence)this.tokenEndpoint);
        boolean isBaseURLNeeded = this.publisherEndpoint.contains("{baseURL}") || this.adminEndpoint.contains("{baseURL}") || this.registrationEndpoint.contains("{baseURL}") || this.tokenEndpoint.contains("{baseURL}") || isEndPointsNeeded;
        boolean bl = isRestVersionNeeded = this.publisherEndpoint.contains("{restVersion}") || this.adminEndpoint.contains("{restVersion}") || this.registrationEndpoint.contains("{restVersion}") || isEndPointsNeeded;
        if (isEndPointsNeeded) {
            if (StringUtils.isEmpty((CharSequence)this.publisherEndpoint)) {
                this.publisherEndpoint = "{baseURL}/api/am/publisher/{restVersion}";
            }
            if (StringUtils.isEmpty((CharSequence)this.adminEndpoint)) {
                this.adminEndpoint = "{baseURL}/api/am/admin/{restVersion}";
            }
            if (StringUtils.isEmpty((CharSequence)this.registrationEndpoint)) {
                this.registrationEndpoint = "{baseURL}/client-registration/{restVersion}/register";
            }
            if (StringUtils.isEmpty((CharSequence)this.tokenEndpoint)) {
                this.tokenEndpoint = "{baseURL}/oauth2/token";
            }
        }
        if (isBaseURLNeeded) {
            if (StringUtils.isEmpty((CharSequence)this.baseURL)) {
                String userInputURL;
                this.baseURL = token.getBaseURL();
                if (StringUtils.isEmpty((CharSequence)this.baseURL)) {
                    this.baseURL = "https://localhost:9443";
                }
                if (!(userInputURL = this.getBaseURLfromCmd(this.baseURL)).isEmpty()) {
                    this.baseURL = userInputURL;
                    this.isOverwriteRequired = true;
                }
            }
            configTokenValues.setBaseURL(this.baseURL);
        }
        if (isRestVersionNeeded) {
            if (StringUtils.isEmpty((CharSequence)restVersion)) {
                restVersion = "v0.14";
            }
            this.informRestVersiontoUser(restVersion);
            configTokenValues.setRestVersion(restVersion);
        }
        if (isBaseURLNeeded || isRestVersionNeeded) {
            this.publisherEndpoint = this.publisherEndpoint.replace("{baseURL}", this.baseURL).replace("{restVersion}", restVersion);
            this.adminEndpoint = this.adminEndpoint.replace("{baseURL}", this.baseURL).replace("{restVersion}", restVersion);
            this.registrationEndpoint = this.registrationEndpoint.replace("{baseURL}", this.baseURL).replace("{restVersion}", restVersion);
            this.tokenEndpoint = this.tokenEndpoint.replace("{baseURL}", this.baseURL).replace("{restVersion}", restVersion);
        }
        this.validateURL(this.publisherEndpoint);
        this.validateURL(this.adminEndpoint);
        this.validateURL(this.registrationEndpoint);
        this.validateURL(this.tokenEndpoint);
        return configTokenValues;
    }

    private void validateURL(String urlString) {
        try {
            new URL(urlString);
        }
        catch (MalformedURLException e) {
            logger.error("Malformed URL provided {}", (Object)urlString);
            throw new CLIInternalException("Error occurred while setting up URL configurations.");
        }
    }

    private void informRestVersiontoUser(String restVersion) {
        outStream.println("You are using REST version - " + restVersion + " of API Manager. (If you want to change this, go to <MICROGW_HOME>/conf/toolkit-config.toml)");
    }

    private void validateAPIGetRequestParams(String label, String apiName, String version) {
        if (StringUtils.isEmpty((CharSequence)label) && (StringUtils.isEmpty((CharSequence)apiName) || StringUtils.isEmpty((CharSequence)version)) || StringUtils.isNotEmpty((CharSequence)label) && (StringUtils.isNotEmpty((CharSequence)apiName) || StringUtils.isNotEmpty((CharSequence)version)) || StringUtils.isEmpty((CharSequence)apiName) && StringUtils.isNotEmpty((CharSequence)version) || StringUtils.isNotEmpty((CharSequence)apiName) && StringUtils.isEmpty((CharSequence)version)) {
            throw GatewayCmdUtils.createUsageException("Either label (-l <label>) or API name (-a <api-name>) with version (-v <version>) should be provided.\n\nEx:\tmicro-gw setup accounts-project -l accounts\n\tmicro-gw setup pizzashack-project -a Pizzashack -v 1.0.0");
        }
    }

    private boolean checkAPIAndProceed(String apiId) {
        String UserResponse = GatewayCmdUtils.promptForTextInput(outStream, "The provided API already exists. Do you need to overwrite ? yes[y] or no[n] :");
        if (UserResponse.trim().isEmpty()) {
            throw new CLIRuntimeException("No argument is provided.");
        }
        if (UserResponse.toLowerCase().equals("n") || UserResponse.toLowerCase().equals("no")) {
            return false;
        }
        if (UserResponse.toLowerCase().equals("y") || UserResponse.toLowerCase().equals("yes")) {
            return true;
        }
        throw new CLIRuntimeException("Provided argument is not valid :" + UserResponse);
    }
}

