/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.OpenAPICodegenUtils;
import org.wso2.apimgt.gateway.cli.utils.RouteUtils;

@Parameters(commandNames={"add route"}, commandDescription="add api to the microgateway")
public class AddRouteCmd
implements GatewayLauncherCmd {
    private static final Logger logger = LoggerFactory.getLogger(AddRouteCmd.class);
    private static PrintStream outStream = System.out;
    @Parameter(names={"--project"}, hidden=true)
    private String projectName;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    @Parameter(names={"-e", "--endpoint"}, hidden=true)
    private String endpoint;
    @Parameter(names={"-ec", "--endpoint-config"}, hidden=true)
    private String endpointConfig;
    @Parameter(names={"-r", "--resource"}, hidden=true)
    private String resource_id;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() {
        String endpointConfigString;
        this.projectName = GatewayCmdUtils.buildProjectName(this.projectName);
        RouteUtils.setRoutesConfigPath(GatewayCmdUtils.getProjectMgwDefinitionFilePath(this.projectName));
        if ((this.resource_id == null || this.resource_id.isEmpty()) && (this.resource_id = GatewayCmdUtils.promptForTextInput(outStream, "Enter Resource ID: ")).trim().isEmpty()) {
            throw GatewayCmdUtils.createUsageException("Micro gateway add route failed: resource_id is not provided");
        }
        if (OpenAPICodegenUtils.getResource(this.projectName, this.resource_id) == null) {
            throw new CLIRuntimeException("Provided resource id is not available");
        }
        if (StringUtils.isEmpty((CharSequence)this.endpointConfig)) {
            if (StringUtils.isEmpty((CharSequence)this.endpoint) && (this.endpoint = GatewayCmdUtils.promptForTextInput(outStream, "Enter Endpoint URL for Resource " + this.resource_id + ": ")).trim().isEmpty()) {
                throw GatewayCmdUtils.createUsageException("Micro gateway setup failed: empty endpoint.");
            }
            endpointConfigString = "{\"prod\": {\"type\": \"http\", \"endpoints\" : [\"" + this.endpoint.trim() + "\"]}}";
        } else {
            endpointConfigString = OpenAPICodegenUtils.readJson(this.endpointConfig);
        }
        if (RouteUtils.hasResourceInRoutesConfig(this.resource_id)) {
            String UserResponse = GatewayCmdUtils.promptForTextInput(outStream, "For the provided resource id " + this.resource_id + " enpoint configuration already exist. Do you need to overwrite ? yes[y] or no[n] :");
            if (UserResponse.trim().isEmpty()) {
                throw new CLIRuntimeException("No argument is provided.");
            }
            if (UserResponse.toLowerCase().equals("n") || UserResponse.toLowerCase().equals("no")) {
                outStream.println("Add route command is aborted :" + this.resource_id);
                return;
            } else {
                if (!UserResponse.toLowerCase().equals("y") && !UserResponse.toLowerCase().equals("yes")) throw new CLIRuntimeException("Provided argument is not valid :" + UserResponse);
                RouteUtils.saveResourceRoute(this.resource_id, endpointConfigString);
                outStream.println("Successfully added route for resource ID : " + this.resource_id);
            }
            return;
        } else {
            RouteUtils.saveResourceRoute(this.resource_id, endpointConfigString);
            outStream.println("Successfully added route for resource ID : " + this.resource_id);
        }
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }
}

