/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.packerina.init.InitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerationContext;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerator;
import org.wso2.apimgt.gateway.cli.codegen.ThrottlePolicyGenerator;
import org.wso2.apimgt.gateway.cli.config.TOMLConfigParser;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.exception.ConfigParserException;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.ContainerConfig;
import org.wso2.apimgt.gateway.cli.model.config.Etcd;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.MgwDefinitionBuilder;
import org.wso2.apimgt.gateway.cli.utils.ToolkitLibExtractionUtils;

@Parameters(commandNames={"build"}, commandDescription="micro gateway build information")
public class BuildCmd
implements GatewayLauncherCmd {
    private static final Logger logger = LoggerFactory.getLogger(BuildCmd.class);
    private static PrintStream outStream = System.out;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    @Parameter(hidden=true, required=true)
    private List<String> mainArgs;
    @Parameter(names={"--compiled"}, hidden=true, arity=0)
    private boolean isCompiled;
    @Parameter(names={"-d", "--deployment-config"}, hidden=true)
    private String deploymentConfigPath;
    @Parameter(names={"--help", "-h", "?"}, hidden=true, description="for more information", help=true)
    private boolean helpFlag;

    @Override
    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = this.getCommandUsageInfo("build");
            outStream.println(commandUsageInfo);
            System.exit(1);
        }
        String projectName = GatewayCmdUtils.getSingleArgument(this.mainArgs);
        File projectLocation = new File(GatewayCmdUtils.getProjectDirectoryPath(projectName = projectName.replaceAll("[/\\\\]", "")));
        if (!projectLocation.exists()) {
            throw new CLIRuntimeException("Project " + projectName + " does not exist.");
        }
        ToolkitLibExtractionUtils.extractPlatformAndRuntime();
        File importedAPIDefLocation = new File(GatewayCmdUtils.getProjectAPIDefinitionsDirectoryPath(projectName));
        File addedAPIDefLocation = new File(GatewayCmdUtils.getProjectAPIFilesDirectoryPath(projectName));
        if (importedAPIDefLocation.list().length == 0 && addedAPIDefLocation.list().length == 0) {
            throw new CLIRuntimeException("Nothing to build. API definitions does not exist.");
        }
        if (importedAPIDefLocation.list().length > 0 && addedAPIDefLocation.list().length == 0 && !this.isCompiled) {
            return;
        }
        if (!this.isCompiled) {
            try {
                String toolkitConfigPath = GatewayCmdUtils.getMainConfigLocation();
                this.init(projectName, toolkitConfigPath, this.deploymentConfigPath);
                Etcd etcd = new Etcd();
                etcd.setEtcdEnabled(GatewayCmdUtils.getEtcdEnabled(projectName));
                GatewayCmdUtils.setEtcd(etcd);
                MgwDefinitionBuilder.build(projectName);
                CodeGenerator codeGenerator = new CodeGenerator();
                ThrottlePolicyGenerator policyGenerator = new ThrottlePolicyGenerator();
                policyGenerator.generate(GatewayCmdUtils.getProjectGenSrcDirectoryPath(projectName) + File.separator + "policies", projectName);
                GatewayCmdUtils.copyAndReplaceFolder(GatewayCmdUtils.getProjectInterceptorsDirectoryPath(projectName), GatewayCmdUtils.getProjectGenSrcInterceptorsDirectoryPath(projectName));
                codeGenerator.generate(projectName, true);
                MgwDefinitionBuilder.FindUnusedAPIInformation();
                InitHandler.initialize((Path)Paths.get(GatewayCmdUtils.getProjectGenDirectoryPath(projectName), new String[0]), null, new ArrayList(), null);
            }
            catch (IOException e) {
                throw new CLIInternalException("Error occured while generating ballerina code for the swagger file.");
            }
        }
        try {
            GatewayCmdUtils.createProjectGWDistribution(projectName);
            outStream.println("Build successful for the project - " + projectName);
        }
        catch (IOException e) {
            logger.error("Error occurred while creating the micro gateway distribution for the project {}.", (Object)projectName, (Object)e);
            throw new CLIInternalException("Error occurred while creating the micro gateway distribution for the project");
        }
    }

    @Override
    public String getName() {
        return "build";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }

    private void init(String projectName, String configPath, String deploymentConfig) {
        try {
            Path deploymentConfigFile;
            Path configurationFile = Paths.get(configPath, new String[0]);
            if (!Files.exists(configurationFile, new LinkOption[0])) {
                logger.error("Configuration: {} Not found.", (Object)configPath);
                throw new CLIInternalException("Error occurred while loading configurations.");
            }
            Config config = TOMLConfigParser.parse(configPath, Config.class);
            GatewayCmdUtils.setConfig(config);
            if (deploymentConfig != null && Files.exists(deploymentConfigFile = Paths.get(deploymentConfig, new String[0]), new LinkOption[0])) {
                GatewayCmdUtils.createDeploymentConfig(projectName, deploymentConfig);
            }
            String deploymentConfigPath = GatewayCmdUtils.getDeploymentConfigLocation(projectName);
            ContainerConfig containerConfig = TOMLConfigParser.parse(deploymentConfigPath, ContainerConfig.class);
            GatewayCmdUtils.setContainerConfig(containerConfig);
            CodeGenerationContext codeGenerationContext = new CodeGenerationContext();
            codeGenerationContext.setProjectName(projectName);
            GatewayCmdUtils.setCodeGenerationContext(codeGenerationContext);
        }
        catch (ConfigParserException e) {
            logger.error("Error occurred while parsing the configurations {}", (Object)configPath, (Object)e);
            throw new CLIInternalException("Error occurred while loading configurations.");
        }
        catch (IOException e) {
            throw new CLIInternalException("Error occured while reading the deployment configuration", e);
        }
    }
}

