/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.model.rest.ResourceRepresentation;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.OpenAPICodegenUtils;
import org.wso2.apimgt.gateway.cli.utils.RouteUtils;

@Parameters(commandNames={"desc resource"}, commandDescription="describe the given resource in the microgateway")
public class DescResourceCmd
implements GatewayLauncherCmd {
    private static final Logger logger = LoggerFactory.getLogger(DescResourceCmd.class);
    private static PrintStream outStream = System.out;
    @Parameter(hidden=true, required=true)
    private List<String> mainArgs;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    @Parameter(names={"--project"}, hidden=true)
    private String projectName;

    @Override
    public void execute() {
        this.projectName = GatewayCmdUtils.buildProjectName(this.projectName);
        String resource_id = GatewayCmdUtils.getSingleArgument(this.mainArgs);
        ResourceRepresentation resource = OpenAPICodegenUtils.getResource(this.projectName, resource_id);
        if (resource != null) {
            this.printResourceDetails(resource);
        } else {
            outStream.println("No resource available for the ID : " + resource_id);
        }
    }

    private void printResourceDetails(ResourceRepresentation resource) {
        outStream.println("Resource_id : " + resource.getId());
        outStream.println("API Name : " + resource.getApi());
        outStream.println("API version : " + resource.getId());
        outStream.println("Resource : " + resource.getName());
        outStream.println("Operation: " + resource.getMethod());
        outStream.println("\nEndpointConfiguration: ");
        outStream.println(RouteUtils.getResourceAsYaml(resource.getId()));
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }
}

