/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.RouteUtils;

@Parameters(commandNames={"function"}, commandDescription="custom function manilpulation")
public class FunctionCmd
implements GatewayLauncherCmd {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionCmd.class);
    private static PrintStream outStream = System.out;
    @Parameter(hidden=true, required=true)
    private List<String> mainArgs;
    @Parameter(names={"-A", "--add"}, hidden=true)
    private Boolean isAdd = false;
    @Parameter(names={"-U", "--update"}, hidden=true)
    private Boolean isUpdate = false;
    @Parameter(names={"-f", "--file"}, hidden=true)
    private String fileLocation;
    @Parameter(names={"-a", "--api"}, hidden=true)
    private String apiID;
    @Parameter(names={"-r", "--resource"}, hidden=true)
    private String resourceID;
    @Parameter(names={"-i", "--in"}, hidden=true)
    private String inFunction;
    @Parameter(names={"-o", "--out"}, hidden=true)
    private String outFunction;

    @Override
    public void execute() {
        String projectName = GatewayCmdUtils.getSingleArgument(this.mainArgs);
        RouteUtils.setRoutesConfigPath(GatewayCmdUtils.getProjectMgwDefinitionFilePath(projectName));
        File projectLocation = new File(GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "src");
        if (!projectLocation.exists()) {
            throw new CLIRuntimeException("Project " + projectName + " does not exist.");
        }
        try {
            File source = new File(this.fileLocation);
            FileUtils.copyFileToDirectory((File)source, (File)projectLocation);
            outStream.println("file copied");
        }
        catch (IOException e) {
            LOGGER.error("error occurred while copying file:" + e);
        }
        if (!this.isAdd.booleanValue()) {
            return;
        }
        if (this.inFunction != null) {
            if (this.apiID != null) {
                RouteUtils.addFunction(this.inFunction, "in", this.apiID);
            } else if (this.resourceID == null) {
                RouteUtils.AddGlobalFunction(this.inFunction, "in");
            }
        } else if (this.outFunction != null) {
            if (this.apiID != null) {
                RouteUtils.addFunction(this.outFunction, "out", this.apiID);
            } else if (this.resourceID == null) {
                RouteUtils.AddGlobalFunction(this.outFunction, "out");
            }
        }
    }

    @Override
    public String getName() {
        return "function";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }
}

