/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.packerina.init.InitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerator;
import org.wso2.apimgt.gateway.cli.codegen.ThrottlePolicyGenerator;
import org.wso2.apimgt.gateway.cli.config.TOMLConfigParser;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.exception.CliLauncherException;
import org.wso2.apimgt.gateway.cli.exception.ConfigParserException;
import org.wso2.apimgt.gateway.cli.model.config.Client;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.ContainerConfig;
import org.wso2.apimgt.gateway.cli.model.config.Etcd;
import org.wso2.apimgt.gateway.cli.model.config.Token;
import org.wso2.apimgt.gateway.cli.model.config.TokenBuilder;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.oauth.OAuthServiceImpl;
import org.wso2.apimgt.gateway.cli.rest.RESTAPIServiceImpl;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.ToolkitLibExtractionUtils;

@Parameters(commandNames={"import"}, commandDescription="pull the api from publisher")
public class ImportCmd
implements GatewayLauncherCmd {
    private static final Logger logger = LoggerFactory.getLogger(ImportCmd.class);
    private static PrintStream outStream = System.out;
    @Parameter(hidden=true, required=true)
    private List<String> mainArgs;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    @Parameter(names={"-u", "--username"}, hidden=true)
    private String username;
    @Parameter(names={"-p", "--password"}, hidden=true)
    private String password;
    @Parameter(names={"-l", "--label"}, hidden=true)
    private String label;
    @Parameter(names={"-s", "--server-url"}, hidden=true)
    private String baseURL;
    @Parameter(names={"-t", "--truststore"}, hidden=true)
    private String trustStoreLocation;
    @Parameter(names={"-w", "--truststore-pass"}, hidden=true)
    private String trustStorePassword;
    @Parameter(names={"-c", "--config"}, hidden=true)
    private String toolkitConfigPath;
    @Parameter(names={"-d", "--deployment-config"}, hidden=true)
    private String deploymentConfigPath;
    @Parameter(names={"-a", "--api-name"}, hidden=true)
    private String apiName;
    @Parameter(names={"-v", "--version"}, hidden=true)
    private String version;
    @Parameter(names={"-k", "--insecure"}, hidden=true, arity=0)
    private boolean isInsecure;
    @Parameter(names={"-b", "--security"}, hidden=true)
    private String security;
    @Parameter(names={"--help", "-h", "?"}, hidden=true, description="for more information", help=true)
    private boolean helpFlag;
    private String publisherEndpoint;
    private String adminEndpoint;
    private String registrationEndpoint;
    private String tokenEndpoint;
    private String clientSecret;
    private boolean isOverwriteRequired;

    @Override
    public void execute() {
        File trustStoreFile;
        String configuredTrustStorePass;
        String encryptedPass;
        if (this.helpFlag) {
            String commandUsageInfo = this.getCommandUsageInfo("import");
            outStream.println(commandUsageInfo);
            return;
        }
        String projectName = GatewayCmdUtils.getSingleArgument(this.mainArgs);
        File projectLocation = new File(GatewayCmdUtils.getProjectDirectoryPath(projectName));
        if (!projectLocation.exists()) {
            throw GatewayCmdUtils.createUsageException("Project " + projectName + " does not exist. Please execute the command 'micro-gw init " + projectName + "' to initialize the project.");
        }
        ToolkitLibExtractionUtils.extractPlatformAndRuntime();
        if (StringUtils.isEmpty((CharSequence)this.security)) {
            this.security = "oauth2";
        }
        if (StringUtils.isEmpty((CharSequence)this.toolkitConfigPath)) {
            this.toolkitConfigPath = GatewayCmdUtils.getMainConfigLocation();
        }
        ImportCmd.init(this.toolkitConfigPath, this.deploymentConfigPath, projectName);
        Config config = GatewayCmdUtils.getConfig();
        this.isOverwriteRequired = false;
        this.validateAPIGetRequestParams(this.label, this.apiName, this.version);
        String configuredUser = config.getToken().getUsername();
        if (StringUtils.isEmpty((CharSequence)configuredUser)) {
            if (StringUtils.isEmpty((CharSequence)this.username)) {
                this.isOverwriteRequired = true;
                this.username = GatewayCmdUtils.promptForTextInput(outStream, "Enter Username: ");
                if (this.username.trim().isEmpty()) {
                    throw GatewayCmdUtils.createUsageException("Micro gateway init failed: empty username.");
                }
            }
        } else {
            this.username = configuredUser;
        }
        if (StringUtils.isEmpty((CharSequence)this.password) && (this.password = this.promptForPasswordInput("Enter Password for " + this.username + ": ")).trim().isEmpty() && StringUtils.isEmpty((CharSequence)this.password)) {
            this.password = this.promptForPasswordInput("Password can't be empty; enter password for " + this.username + ": ");
            if (this.password.trim().isEmpty()) {
                throw GatewayCmdUtils.createUsageException("Micro gateway init failed: empty password.");
            }
        }
        Token configToken = config.getToken();
        TokenBuilder configTokenValues = this.setEndpoints(configToken);
        String configuredTrustStore = config.getToken().getTrustStoreLocation();
        if (StringUtils.isEmpty((CharSequence)configuredTrustStore)) {
            if (StringUtils.isEmpty((CharSequence)this.trustStoreLocation)) {
                this.isOverwriteRequired = true;
                this.trustStoreLocation = GatewayCmdUtils.promptForTextInput(outStream, "Enter Trust store location: [lib/platform/bre/security/ballerinaTruststore.p12]");
                if (this.trustStoreLocation.trim().isEmpty()) {
                    this.trustStoreLocation = "lib/platform/bre/security/ballerinaTruststore.p12";
                }
            }
        } else {
            this.trustStoreLocation = configuredTrustStore;
        }
        if (StringUtils.isEmpty((CharSequence)(encryptedPass = config.getToken().getTrustStorePassword()))) {
            configuredTrustStorePass = null;
        } else {
            try {
                configuredTrustStorePass = GatewayCmdUtils.decrypt(encryptedPass, this.password);
            }
            catch (CliLauncherException e) {
                configuredTrustStorePass = null;
            }
        }
        if (StringUtils.isEmpty(configuredTrustStorePass)) {
            if (StringUtils.isEmpty((CharSequence)this.trustStorePassword)) {
                this.isOverwriteRequired = true;
                this.trustStorePassword = this.promptForPasswordInput("Enter Trust store password: [ use default? ]");
                if (this.trustStorePassword.trim().isEmpty()) {
                    this.trustStorePassword = "ballerina";
                }
            }
        } else {
            this.trustStorePassword = configuredTrustStorePass;
        }
        if (!(trustStoreFile = new File(this.trustStoreLocation)).isAbsolute()) {
            this.trustStoreLocation = GatewayCmdUtils.getUnixPath(GatewayCmdUtils.getCLIHome() + File.separator + this.trustStoreLocation);
        }
        if (!(trustStoreFile = new File(this.trustStoreLocation)).exists()) {
            logger.error("Provided trust store location {} does not exist.", (Object)this.trustStoreLocation);
            throw new CLIRuntimeException("Provided trust store location does not exist.");
        }
        System.setProperty("javax.net.ssl.keyStoreType", "pkcs12");
        System.setProperty("javax.net.ssl.trustStoreType", "pkcs12");
        System.setProperty("javax.net.ssl.trustStore", this.trustStoreLocation);
        System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
        OAuthServiceImpl manager = new OAuthServiceImpl();
        String clientID = config.getToken().getClientId();
        String encryptedSecret = config.getToken().getClientSecret();
        if (!StringUtils.isEmpty((CharSequence)clientID.trim()) && !StringUtils.isEmpty((CharSequence)encryptedSecret.trim())) {
            try {
                this.clientSecret = GatewayCmdUtils.decrypt(encryptedSecret, this.password);
            }
            catch (CliLauncherException e) {
                this.clientSecret = null;
            }
        }
        if (StringUtils.isEmpty((CharSequence)clientID) || StringUtils.isEmpty((CharSequence)this.clientSecret)) {
            String[] clientInfo = manager.generateClientIdAndSecret(this.registrationEndpoint, this.username, this.password.toCharArray(), this.isInsecure);
            clientID = clientInfo[0];
            this.clientSecret = clientInfo[1];
        }
        String accessToken = manager.generateAccessToken(this.tokenEndpoint, this.username, this.password.toCharArray(), clientID, this.clientSecret, this.isInsecure);
        List<Object> apis = new ArrayList();
        RESTAPIServiceImpl service = new RESTAPIServiceImpl(this.publisherEndpoint, this.adminEndpoint, this.isInsecure);
        if (this.label != null) {
            apis = service.getAPIs(this.label, accessToken);
        } else {
            ExtendedAPI api2 = service.getAPI(this.apiName, this.version, accessToken);
            if (api2 != null) {
                apis.add(api2);
            }
        }
        if (this.security == null) {
            this.security = "oauth2";
        }
        apis.forEach(api -> api.setApiSecurity(this.security));
        if (apis.isEmpty()) {
            GatewayCmdUtils.deleteProject(File.separator + projectName);
            String errorMsg = this.label != null ? "No APIs found for the given label: " + this.label : "No Published APIs matched for name:" + this.apiName + ", version:" + this.version;
            throw new CLIRuntimeException(errorMsg);
        }
        Etcd etcd = new Etcd();
        etcd.setEtcdEnabled(GatewayCmdUtils.getEtcdEnabled(projectName));
        GatewayCmdUtils.setEtcd(etcd);
        List<ApplicationThrottlePolicyDTO> applicationPolicies = service.getApplicationPolicies(accessToken);
        List<SubscriptionThrottlePolicyDTO> subscriptionPolicies = service.getSubscriptionPolicies(accessToken);
        try {
            GatewayCmdUtils.saveSwaggerDefinitionForMultipleAPIs(projectName, apis);
            ThrottlePolicyGenerator policyGenerator = new ThrottlePolicyGenerator();
            policyGenerator.generate(GatewayCmdUtils.getProjectGenSrcDirectoryPath(projectName) + File.separator + "policies", applicationPolicies, subscriptionPolicies);
            CodeGenerator codeGenerator = new CodeGenerator();
            codeGenerator.generate(projectName, apis, true);
            InitHandler.initialize((Path)Paths.get(GatewayCmdUtils.getProjectGenDirectoryPath(projectName), new String[0]), null, new ArrayList(), null);
        }
        catch (Exception e) {
            throw new CLIInternalException("Exception occurred during codeGeneration process");
        }
        if (this.isOverwriteRequired) {
            Config newConfig = new Config();
            Client client = new Client();
            client.setHttpRequestTimeout(1000000);
            newConfig.setClient(client);
            String encryptedCS = GatewayCmdUtils.encrypt(this.clientSecret, this.password);
            String encryptedTrustStorePass = GatewayCmdUtils.encrypt(this.trustStorePassword, this.password);
            Token token = configTokenValues.setUsername(this.username).setClientId(clientID).setClientSecret(encryptedCS).setTrustStoreLocation(this.trustStoreLocation).setTrustStorePassword(encryptedTrustStorePass).build();
            newConfig.setToken(token);
            newConfig.setCorsConfiguration(GatewayCmdUtils.getDefaultCorsConfig());
            GatewayCmdUtils.saveConfig(newConfig, this.toolkitConfigPath);
        }
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }

    private String promptForTextInput(String msg) {
        outStream.println(msg);
        return System.console().readLine();
    }

    private static void init(String configPath, String deploymentConfig, String projectName) {
        try {
            Path deploymentConfigFile;
            Path configurationFile = Paths.get(configPath, new String[0]);
            if (!Files.exists(configurationFile, new LinkOption[0])) {
                logger.error("Configuration: {} Not found.", (Object)configPath);
                throw new CLIInternalException("Error occurred while loading configurations.");
            }
            Config config = TOMLConfigParser.parse(configPath, Config.class);
            GatewayCmdUtils.setConfig(config);
            if (deploymentConfig != null && Files.exists(deploymentConfigFile = Paths.get(deploymentConfig, new String[0]), new LinkOption[0])) {
                GatewayCmdUtils.createDeploymentConfig(projectName, deploymentConfig);
            }
            String deploymentConfigPath = GatewayCmdUtils.getDeploymentConfigLocation(projectName);
            ContainerConfig containerConfig = TOMLConfigParser.parse(deploymentConfigPath, ContainerConfig.class);
            GatewayCmdUtils.setContainerConfig(containerConfig);
        }
        catch (ConfigParserException e) {
            logger.error("Error occurred while parsing the configurations {}", (Object)configPath, (Object)e);
            throw new CLIInternalException("Error occurred while loading configurations.");
        }
        catch (IOException e) {
            throw new CLIInternalException("Error occured while reading the deployment configuration", e);
        }
    }

    private void validateAPIGetRequestParams(String label, String apiName, String version) {
        if (StringUtils.isEmpty((CharSequence)label) && (StringUtils.isEmpty((CharSequence)apiName) || StringUtils.isEmpty((CharSequence)version)) || StringUtils.isNotEmpty((CharSequence)label) && (StringUtils.isNotEmpty((CharSequence)apiName) || StringUtils.isNotEmpty((CharSequence)version)) || StringUtils.isEmpty((CharSequence)apiName) && StringUtils.isNotEmpty((CharSequence)version) || StringUtils.isNotEmpty((CharSequence)apiName) && StringUtils.isEmpty((CharSequence)version)) {
            throw GatewayCmdUtils.createUsageException("Either label (-l <label>) or API name (-a <api-name>) with version (-v <version>) should be provided.\n\nEx:\tmicro-gw setup accounts-project -l accounts\n\tmicro-gw setup pizzashack-project -a Pizzashack -v 1.0.0");
        }
    }

    private TokenBuilder setEndpoints(Token token) {
        boolean isRestVersionNeeded;
        TokenBuilder configTokenValues = new TokenBuilder();
        String restVersion = token.getRestVersion();
        this.publisherEndpoint = token.getPublisherEndpoint();
        this.adminEndpoint = token.getAdminEndpoint();
        this.registrationEndpoint = token.getRegistrationEndpoint();
        this.tokenEndpoint = token.getTokenEndpoint();
        configTokenValues.setPublisherEndpoint(this.publisherEndpoint);
        configTokenValues.setAdminEndpoint(this.adminEndpoint);
        configTokenValues.setRegistrationEndpoint(this.registrationEndpoint);
        configTokenValues.setTokenEndpoint(this.tokenEndpoint);
        configTokenValues.setRestVersion(restVersion);
        configTokenValues.setBaseURL(token.getBaseURL());
        boolean isEndPointsNeeded = StringUtils.isEmpty((CharSequence)this.publisherEndpoint) || StringUtils.isEmpty((CharSequence)this.adminEndpoint) || StringUtils.isEmpty((CharSequence)this.registrationEndpoint) || StringUtils.isEmpty((CharSequence)this.tokenEndpoint);
        boolean isBaseURLNeeded = this.publisherEndpoint.contains("{baseURL}") || this.adminEndpoint.contains("{baseURL}") || this.registrationEndpoint.contains("{baseURL}") || this.tokenEndpoint.contains("{baseURL}") || isEndPointsNeeded;
        boolean bl = isRestVersionNeeded = this.publisherEndpoint.contains("{restVersion}") || this.adminEndpoint.contains("{restVersion}") || this.registrationEndpoint.contains("{restVersion}") || isEndPointsNeeded;
        if (isEndPointsNeeded) {
            if (StringUtils.isEmpty((CharSequence)this.publisherEndpoint)) {
                this.publisherEndpoint = "{baseURL}/api/am/publisher/{restVersion}";
            }
            if (StringUtils.isEmpty((CharSequence)this.adminEndpoint)) {
                this.adminEndpoint = "{baseURL}/api/am/admin/{restVersion}";
            }
            if (StringUtils.isEmpty((CharSequence)this.registrationEndpoint)) {
                this.registrationEndpoint = "{baseURL}/client-registration/{restVersion}/register";
            }
            if (StringUtils.isEmpty((CharSequence)this.tokenEndpoint)) {
                this.tokenEndpoint = "{baseURL}/oauth2/token";
            }
        }
        if (isBaseURLNeeded) {
            if (StringUtils.isEmpty((CharSequence)this.baseURL)) {
                String userInputURL;
                this.baseURL = token.getBaseURL();
                if (StringUtils.isEmpty((CharSequence)this.baseURL)) {
                    this.baseURL = "https://localhost:9443";
                }
                if (!(userInputURL = this.getBaseURLfromCmd(this.baseURL)).isEmpty()) {
                    this.baseURL = userInputURL;
                    this.isOverwriteRequired = true;
                }
            }
            configTokenValues.setBaseURL(this.baseURL);
        }
        if (isRestVersionNeeded) {
            if (StringUtils.isEmpty((CharSequence)restVersion)) {
                restVersion = "v0.14";
            }
            this.informRestVersiontoUser(restVersion);
            configTokenValues.setRestVersion(restVersion);
        }
        if (isBaseURLNeeded || isRestVersionNeeded) {
            this.publisherEndpoint = this.publisherEndpoint.replace("{baseURL}", this.baseURL).replace("{restVersion}", restVersion);
            this.adminEndpoint = this.adminEndpoint.replace("{baseURL}", this.baseURL).replace("{restVersion}", restVersion);
            this.registrationEndpoint = this.registrationEndpoint.replace("{baseURL}", this.baseURL).replace("{restVersion}", restVersion);
            this.tokenEndpoint = this.tokenEndpoint.replace("{baseURL}", this.baseURL).replace("{restVersion}", restVersion);
        }
        this.validateURL(this.publisherEndpoint);
        this.validateURL(this.adminEndpoint);
        this.validateURL(this.registrationEndpoint);
        this.validateURL(this.tokenEndpoint);
        return configTokenValues;
    }

    private void validateURL(String urlString) {
        try {
            new URL(urlString);
        }
        catch (MalformedURLException e) {
            logger.error("Malformed URL provided {}", (Object)urlString);
            throw new CLIInternalException("Error occurred while setting up URL configurations.");
        }
    }

    private void informRestVersiontoUser(String restVersion) {
        outStream.println("You are using REST version - " + restVersion + " of API Manager. (If you want to change this, go to <MICROGW_HOME>/conf/toolkit-config.toml)");
    }

    private String getBaseURLfromCmd(String defaultBaseURL) {
        String userInputURL = this.promptForTextInput("Enter APIM base URL [" + defaultBaseURL + "]: ").trim();
        return userInputURL;
    }

    private String promptForPasswordInput(String msg) {
        outStream.println(msg);
        return new String(System.console().readPassword());
    }
}

