/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.ToolkitLibExtractionUtils;

@Parameters(commandNames={"init"}, commandDescription="initialize a new project")
public class InitCmd
implements GatewayLauncherCmd {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitCmd.class);
    private static final PrintStream OUT = System.out;
    @Parameter(hidden=true, required=true)
    private List<String> mainArgs;
    @Parameter(names={"-f", "--force"}, hidden=true, arity=0)
    private boolean isForceful;
    @Parameter(names={"-d", "--deployment-config"}, hidden=true)
    private String deploymentConfigPath;
    @Parameter(names={"--etcd"}, hidden=true, arity=0)
    private boolean isEtcdEnabled;
    @Parameter(names={"--help", "-h", "?"}, hidden=true, description="for more information", help=true)
    private boolean helpFlag;

    @Override
    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = this.getCommandUsageInfo("init");
            OUT.println(commandUsageInfo);
            return;
        }
        String workspace = GatewayCmdUtils.getUserDir();
        String projectName = GatewayCmdUtils.getSingleArgument(this.mainArgs);
        Path projectLocation = Paths.get(workspace + File.separator + projectName, new String[0]);
        boolean isDirectory = Files.isDirectory(projectLocation, new LinkOption[0]);
        if (isDirectory && !this.isForceful) {
            throw GatewayCmdUtils.createUsageException("Project name `" + projectName + "` already exist. use -f or --force to forcefully update the project directory.");
        }
        if (isDirectory) {
            GatewayCmdUtils.deleteProject(projectName);
        }
        ToolkitLibExtractionUtils.extractPlatformAndRuntime();
        InitCmd.init(projectName, this.deploymentConfigPath);
        GatewayCmdUtils.saveEtcdEnabled(projectName, this.isEtcdEnabled);
        OUT.println("Project '" + projectName + "' is initialized successfully.");
    }

    @Override
    public String getName() {
        return "init";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }

    private static void init(String projectName, String deploymentConfigPath) {
        try {
            GatewayCmdUtils.createProjectStructure(projectName);
            GatewayCmdUtils.createDeploymentConfig(projectName, deploymentConfigPath);
        }
        catch (IOException e) {
            LOGGER.error("Error occurred while generating project configurations", (Throwable)e);
            throw new CLIInternalException("Error occurred while loading configurations.");
        }
    }
}

