/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.RouteUtils;

@Parameters(commandNames={"list apis"}, commandDescription="list apis of the microgateway")
public class ListAPIsCmd
implements GatewayLauncherCmd {
    private static final String API_ID = "API ID";
    private static final String API_NAME = "Title";
    private static final String API_VERSION = "Version";
    private static final String BASEPATH = "Base Path";
    @Parameter(names={"--project"}, hidden=true)
    private String projectName;
    private static final Logger logger = LoggerFactory.getLogger(ListAPIsCmd.class);
    private static PrintStream outStream = System.out;

    @Override
    public void execute() {
        this.projectName = GatewayCmdUtils.buildProjectName(this.projectName);
        RouteUtils.setRoutesConfigPath(GatewayCmdUtils.getProjectMgwDefinitionFilePath(this.projectName));
        this.printAPIDetailsInTable(RouteUtils.listApis());
    }

    private void printAPIDetailsInTable(List<String[]> rows) {
        if (rows == null || rows.size() == 0) {
            outStream.println("\nNo APIs in the project");
        } else {
            String tableStructure = "%-33s%-20s%-10s%-80s\n";
            outStream.format(tableStructure, API_ID, API_NAME, API_VERSION, BASEPATH);
            for (String[] row : rows) {
                outStream.format(tableStructure, row[0], row[1], row[2], row[3]);
            }
        }
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }
}

