/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.ParameterException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.BuildCmd;
import org.wso2.apimgt.gateway.cli.cmd.DefaultCmd;
import org.wso2.apimgt.gateway.cli.cmd.ExtendedJCommander;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.cmd.HelpCmd;
import org.wso2.apimgt.gateway.cli.cmd.ImportCmd;
import org.wso2.apimgt.gateway.cli.cmd.InitCmd;
import org.wso2.apimgt.gateway.cli.cmd.ResetCmd;
import org.wso2.apimgt.gateway.cli.cmd.RunCmd;
import org.wso2.apimgt.gateway.cli.cmd.SetProjectCmd;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.exception.CliLauncherException;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;

public class Main {
    private static final String JC_UNKNOWN_OPTION_PREFIX = "Unknown option:";
    private static final String JC_EXPECTED_A_VALUE_AFTER_PARAMETER_PREFIX = "Expected a value after parameter";
    private static final String INTERNAL_ERROR_MESSAGE = "Internal error occurred while executing command.";
    private static final String MICRO_GW = "micro-gw: ";
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static PrintStream outStream = System.err;

    public static void main(String ... args) {
        try {
            Optional<GatewayLauncherCmd> optionalInvokedCmd = Main.getInvokedCmd(args);
            optionalInvokedCmd.ifPresent(GatewayLauncherCmd::execute);
        }
        catch (CliLauncherException e) {
            outStream.println(e.getMessages());
            logger.error("micro-gw: Error occurred while executing command.", (Throwable)e);
            Runtime.getRuntime().exit(1);
        }
        catch (CLIInternalException e) {
            outStream.println("micro-gw: Internal error occurred while executing command. - " + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            Runtime.getRuntime().exit(1);
        }
        catch (CLIRuntimeException e) {
            outStream.println(MICRO_GW + e.getTerminalMsg());
            logger.error(e.getMessage(), (Throwable)e);
            Runtime.getRuntime().exit(e.getExitCode());
        }
        catch (Exception e) {
            outStream.println("micro-gw: Internal error occurred while executing command.");
            logger.error(INTERNAL_ERROR_MESSAGE, (Throwable)e);
            Runtime.getRuntime().exit(1);
        }
    }

    private static Optional<GatewayLauncherCmd> getInvokedCmd(String ... args) {
        try {
            String parsedCmdName;
            DefaultCmd defaultCmd = new DefaultCmd();
            ExtendedJCommander cmdParser = new ExtendedJCommander(defaultCmd);
            defaultCmd.setParentCmdParser(cmdParser);
            HelpCmd helpCmd = new HelpCmd();
            cmdParser.addCommand("help", helpCmd);
            helpCmd.setParentCmdParser(cmdParser);
            InitCmd initCmd = new InitCmd();
            cmdParser.addCommand("init", initCmd);
            initCmd.setParentCmdParser(cmdParser);
            BuildCmd buildCmd = new BuildCmd();
            cmdParser.addCommand("build", buildCmd);
            buildCmd.setParentCmdParser(cmdParser);
            RunCmd runCmd = new RunCmd();
            cmdParser.addCommand("run", runCmd);
            runCmd.setParentCmdParser(cmdParser);
            ResetCmd resetCmd = new ResetCmd();
            cmdParser.addCommand("reset", resetCmd);
            resetCmd.setParentCmdParser(cmdParser);
            ImportCmd importCmd = new ImportCmd();
            cmdParser.addCommand("import", importCmd);
            importCmd.setParentCmdParser(cmdParser);
            SetProjectCmd setProjectCmd = new SetProjectCmd();
            cmdParser.addCommand("set", setProjectCmd);
            setProjectCmd.setParentCmdParser(cmdParser);
            if (args.length != 0) {
                cmdParser.setProgramName("micro-gw");
                cmdParser.parse(args);
                parsedCmdName = cmdParser.getParsedCommand();
                if (parsedCmdName == null) {
                    return Optional.of(defaultCmd);
                }
            } else {
                String errorMsg = "No arguments supplied";
                throw GatewayCmdUtils.createUsageException(errorMsg);
            }
            Map commanderMap = cmdParser.getCommands();
            return Optional.of((GatewayLauncherCmd)((JCommander)commanderMap.get(parsedCmdName)).getObjects().get(0));
        }
        catch (MissingCommandException e) {
            String errorMsg = "Unknown command '" + e.getUnknownCommand() + "'";
            throw GatewayCmdUtils.createUsageException(errorMsg);
        }
        catch (ParameterException e) {
            String msg = e.getMessage();
            if (msg == null) {
                throw GatewayCmdUtils.createUsageException("Internal error occurred");
            }
            if (msg.startsWith(JC_UNKNOWN_OPTION_PREFIX)) {
                String flag = msg.substring(JC_UNKNOWN_OPTION_PREFIX.length());
                throw GatewayCmdUtils.createUsageException("Unknown flag '" + flag.trim() + "'");
            }
            if (msg.startsWith(JC_EXPECTED_A_VALUE_AFTER_PARAMETER_PREFIX)) {
                String flag = msg.substring(JC_EXPECTED_A_VALUE_AFTER_PARAMETER_PREFIX.length());
                throw GatewayCmdUtils.createUsageException("Flag '" + flag.trim() + "' needs an argument");
            }
            throw GatewayCmdUtils.createUsageException(GatewayCmdUtils.makeFirstLetterLowerCase(msg));
        }
    }
}

