/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.model.config.Client;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.Token;
import org.wso2.apimgt.gateway.cli.model.config.TokenBuilder;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;

@Parameters(commandNames={"reset"}, commandDescription="reset configurations")
public class ResetCmd
implements GatewayLauncherCmd {
    private static PrintStream outStream = System.err;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    @Parameter(names={"-c", "--config"}, hidden=true)
    private String configPath;

    @Override
    public void execute() {
        Path configurationFile;
        if (StringUtils.isEmpty((CharSequence)this.configPath)) {
            this.configPath = GatewayCmdUtils.getMainConfigLocation();
        }
        if (!Files.exists(configurationFile = Paths.get(this.configPath, new String[0]), new LinkOption[0])) {
            outStream.println("Config: " + this.configPath + " Not found.");
            Runtime.getRuntime().exit(1);
        }
        Config newConfig = new Config();
        Client client = new Client();
        client.setHttpRequestTimeout(1000000);
        newConfig.setClient(client);
        Token token = new TokenBuilder().setBaseURL("").setRestVersion("").setPublisherEndpoint("").setAdminEndpoint("").setRegistrationEndpoint("").setTokenEndpoint("").setUsername("").setClientId("").setClientSecret("").setTrustStoreLocation("").setTrustStorePassword("").build();
        newConfig.setToken(token);
        newConfig.setCorsConfiguration(GatewayCmdUtils.getDefaultCorsConfig());
        GatewayCmdUtils.saveConfig(newConfig, this.configPath);
    }

    @Override
    public String getName() {
        return "reset";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }
}

