/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;

@Parameters(commandNames={"set"}, commandDescription="set working project")
public class SetProjectCmd
implements GatewayLauncherCmd {
    private static final PrintStream OUT = System.out;
    @Parameter(required=true, hidden=true)
    private List<String> mainArgs;

    @Override
    public void execute() {
        String projectFile = GatewayCmdUtils.getCLIHome() + File.separator + ".PROJECT";
        String projectPath = GatewayCmdUtils.getSingleArgument(this.mainArgs);
        if (this.isValidProjectPath(projectPath = new File(projectPath).getAbsolutePath())) {
            projectPath = projectPath.trim();
            try {
                FileUtils.writeStringToFile((File)new File(projectFile), (String)projectPath.trim(), (Charset)StandardCharsets.UTF_8, (boolean)false);
            }
            catch (IOException e) {
                throw new CLIRuntimeException("Failed to save working project.");
            }
        } else {
            throw new CLIRuntimeException("Invalid project directory.");
        }
        OUT.println("Working project is set to: " + projectPath);
    }

    private boolean isValidProjectPath(String path) {
        boolean isDir = Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0]);
        return isDir;
    }

    @Override
    public String getName() {
        return "set";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }
}

