/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.cmd.Main;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.HashingException;
import org.wso2.apimgt.gateway.cli.hashing.LibHashUtils;
import org.wso2.apimgt.gateway.cli.model.config.Etcd;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.ZipUtils;

@Parameters(commandNames={"setup"}, commandDescription="setup information")
public class SetupCmd
implements GatewayLauncherCmd {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetupCmd.class);
    private static PrintStream outStream = System.out;
    @Parameter(hidden=true, required=true)
    private List<String> mainArgs;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    @Parameter(names={"-u", "--username"}, hidden=true)
    private String username;
    @Parameter(names={"-p", "--password"}, hidden=true)
    private String password;
    @Parameter(names={"-l", "--label"}, hidden=true)
    private String label;
    @Parameter(names={"-s", "--server-url"}, hidden=true)
    private String baseURL;
    @Parameter(names={"-oa", "--openapi"}, hidden=true)
    private String openApi;
    @Parameter(names={"-e", "--endpoint"}, hidden=true)
    private String endpoint;
    @Parameter(names={"-ec", "--endpoint-config"}, hidden=true)
    private String endpointConfig;
    @Parameter(names={"-t", "--truststore"}, hidden=true)
    private String trustStoreLocation;
    @Parameter(names={"-w", "--truststore-pass"}, hidden=true)
    private String trustStorePassword;
    @Parameter(names={"-c", "--config"}, hidden=true)
    private String toolkitConfigPath;
    @Parameter(names={"-d", "--deployment-config"}, hidden=true)
    private String deploymentConfigPath;
    @Parameter(names={"-a", "--api-name"}, hidden=true)
    private String apiName;
    @Parameter(names={"-v", "--version"}, hidden=true)
    private String version;
    @Parameter(names={"-f", "--force"}, hidden=true, arity=0)
    private boolean isForcefully;
    @Parameter(names={"-k", "--insecure"}, hidden=true, arity=0)
    private boolean isInsecure;
    @Parameter(names={"-sec", "--security"}, hidden=true)
    private String security;
    @Parameter(names={"-b", "--basepath"}, hidden=true)
    private String basepath;
    @Parameter(names={"-etcd", "--enable-etcd"}, hidden=true, arity=0)
    private boolean isEtcdEnabled;
    private String[] addCmdArgs;

    void setArgsForAddCmd(String[] args) {
        String[] addCmdArgs = new String[args.length + 1];
        System.arraycopy(args, 1, addCmdArgs, 2, args.length - 1);
        addCmdArgs[0] = "import";
        addCmdArgs[1] = "--project";
        this.addCmdArgs = addCmdArgs;
    }

    @Override
    public void execute() {
        String workspace = GatewayCmdUtils.getUserDir();
        String projectName = GatewayCmdUtils.getSingleArgument(this.mainArgs);
        if (projectName.contains(" ")) {
            throw GatewayCmdUtils.createUsageException("Only one argument accepted as the project name. but provided: " + projectName);
        }
        if (StringUtils.isEmpty((CharSequence)this.toolkitConfigPath)) {
            this.toolkitConfigPath = GatewayCmdUtils.getMainConfigLocation();
        }
        if (new File(workspace + File.separator + projectName).exists() && !this.isForcefully) {
            throw GatewayCmdUtils.createUsageException("Project name `" + projectName + "` already exist. use -f or --force to forcefully update the project directory.");
        }
        if (new File(workspace + File.separator + projectName).exists()) {
            GatewayCmdUtils.deleteProject(projectName);
        }
        this.extractPlatformAndRuntime();
        SetupCmd.init(projectName, this.deploymentConfigPath);
        Etcd etcd = new Etcd();
        etcd.setEtcdEnabled(this.isEtcdEnabled);
        GatewayCmdUtils.setEtcd(etcd);
        LOGGER.debug("Etcd is enabled : " + this.isEtcdEnabled);
        if (this.openApi != null || this.apiName != null || this.label != null) {
            Main.main(this.addCmdArgs);
        }
        outStream.println("Setting up project " + projectName + " is successful.");
    }

    @Override
    public String getName() {
        return "setup";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }

    private static void init(String projectName, String deploymentConfigPath) {
        try {
            GatewayCmdUtils.createProjectStructure(projectName);
            GatewayCmdUtils.createDeploymentConfig(projectName, deploymentConfigPath);
        }
        catch (IOException e) {
            LOGGER.error("Error occurred while generating project configurations", (Throwable)e);
            throw new CLIInternalException("Error occurred while loading configurations.");
        }
    }

    private void extractPlatformAndRuntime() {
        try {
            String libPath = GatewayCmdUtils.getCLILibPath();
            String baloPath = "gateway" + File.separator + "balo";
            String breLibPath = "bre" + File.separator + "lib";
            String runtimeExtractedPath = libPath + File.separator + "runtime";
            String platformExtractedPath = GatewayCmdUtils.getCLILibPath() + File.separator + "platform";
            try {
                boolean isChangesDetected = LibHashUtils.detectChangesInLibraries();
                if (isChangesDetected) {
                    Files.deleteIfExists(Paths.get(runtimeExtractedPath, new String[0]));
                    Files.deleteIfExists(Paths.get(platformExtractedPath, new String[0]));
                }
            }
            catch (HashingException e) {
                LOGGER.error("Error while detecting changes in gateway libraries", (Throwable)e);
            }
            if (!Files.exists(Paths.get(runtimeExtractedPath, new String[0]), new LinkOption[0])) {
                ZipUtils.unzip(runtimeExtractedPath + ".zip", runtimeExtractedPath, false);
                GatewayCmdUtils.copyFolder(libPath + File.separator + baloPath, runtimeExtractedPath + File.separator + "lib" + File.separator + "repo");
                GatewayCmdUtils.copyFolder(libPath + File.separator + "gateway" + File.separator + "runtime", runtimeExtractedPath + File.separator + breLibPath);
            }
            if (!Files.exists(Paths.get(platformExtractedPath, new String[0]), new LinkOption[0])) {
                ZipUtils.unzip(platformExtractedPath + ".zip", platformExtractedPath, true);
                GatewayCmdUtils.copyFolder(libPath + File.separator + baloPath, platformExtractedPath + File.separator + "lib" + File.separator + "repo");
                GatewayCmdUtils.copyFolder(libPath + File.separator + "gateway" + File.separator + "platform", platformExtractedPath + File.separator + breLibPath);
            }
        }
        catch (IOException e) {
            String message = "Error while unzipping platform and runtime while project setup";
            LOGGER.error(message, (Throwable)e);
            throw new CLIInternalException(message);
        }
    }
}

