/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.cmd.ListAPIsCmd;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.OpenAPICodegenUtils;
import org.wso2.apimgt.gateway.cli.utils.RouteUtils;

@Parameters(commandNames={"update route"}, commandDescription="update routes configuration")
public class UpdateRouteCmd
implements GatewayLauncherCmd {
    private static final Logger logger = LoggerFactory.getLogger(ListAPIsCmd.class);
    private static PrintStream outStream = System.out;
    @Parameter(names={"-r", "--resource"}, hidden=true)
    private String resourceId;
    @Parameter(names={"-a", "--api"}, hidden=true)
    private String apiId;
    @Parameter(names={"--project"}, hidden=true, required=true)
    private String projectName;
    @Parameter(names={"-e", "--endpoint"}, hidden=true)
    private String endpoint;
    @Parameter(names={"-ec", "--endpoint-config"}, hidden=true)
    private String endpointConfig;

    @Override
    public void execute() {
        String endpointConfigString;
        if (this.projectName == null || this.projectName.isEmpty()) {
            throw new CLIRuntimeException("Project name is not provided.");
        }
        RouteUtils.setRoutesConfigPath(GatewayCmdUtils.getProjectMgwDefinitionFilePath(this.projectName));
        if ((this.apiId == null || this.apiId.isEmpty()) && (this.resourceId == null || this.resourceId.isEmpty())) {
            throw new CLIRuntimeException("Error: API Id or resource id is not provided.");
        }
        if (this.apiId != null && this.resourceId != null) {
            throw new CLIRuntimeException("Error: Please provide one Id.");
        }
        if (StringUtils.isEmpty((CharSequence)this.endpointConfig)) {
            if (StringUtils.isEmpty((CharSequence)this.endpoint) && (this.endpoint = GatewayCmdUtils.promptForTextInput(outStream, "Enter Endpoint URL: ")).trim().isEmpty()) {
                throw GatewayCmdUtils.createUsageException("Micro gateway setup failed: empty endpoint.");
            }
            endpointConfigString = "{\"prod\": {\"type\": \"http\", \"endpoints\" : [\"" + this.endpoint.trim() + "\"]}}";
        } else {
            endpointConfigString = OpenAPICodegenUtils.readJson(this.endpointConfig);
        }
        if (this.apiId != null) {
            RouteUtils.updateAPIRoute(this.apiId, endpointConfigString);
        } else {
            RouteUtils.updateResourceRoute(this.resourceId, endpointConfigString);
        }
        outStream.println("Update route command executed successfully.");
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }
}

