/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.codegen;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.wso2.apimgt.gateway.cli.constants.GeneratorConstants;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.hashing.HashUtils;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.template.GenSrcFile;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaService;
import org.wso2.apimgt.gateway.cli.model.template.service.ListenerEndpoint;
import org.wso2.apimgt.gateway.cli.utils.CodegenUtils;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.MgwDefinitionBuilder;
import org.wso2.apimgt.gateway.cli.utils.OpenAPICodegenUtils;

public class CodeGenerator {
    private static PrintStream outStream = System.out;

    public void generate(String projectName, List<ExtendedAPI> apis, boolean overwrite) throws IOException, BallerinaServiceGenException {
        String projectSrcPath = GatewayCmdUtils.getProjectGenSrcDirectoryPath(projectName);
        ArrayList<GenSrcFile> genFiles = new ArrayList<GenSrcFile>();
        ArrayList<BallerinaService> serviceList = new ArrayList<BallerinaService>();
        for (ExtendedAPI api : apis) {
            outStream.println("ID for API " + api.getName() + " : " + api.getId());
            String apiHashId = HashUtils.generateAPIId(api.getName(), api.getVersion());
            OpenAPI openApi = new OpenAPIV3Parser().read(GatewayCmdUtils.getProjectGenSwaggerPath(projectName, apiHashId));
            OpenAPICodegenUtils.setAdditionalConfig(api);
            BallerinaService ballerinaService = new BallerinaService();
            ballerinaService.setIsDevFirst(false);
            BallerinaService definitionContext = ballerinaService.buildContext(openApi, api);
            if (api.getIsDefaultVersion().booleanValue()) {
                definitionContext.setQualifiedServiceName(CodegenUtils.trim(api.getName()));
                genFiles.add(this.generateService(definitionContext));
                api.setIsDefaultVersion(false);
                OpenAPICodegenUtils.setAdditionalConfig(api);
                definitionContext.setQualifiedServiceName(CodegenUtils.trim(api.getName() + "_" + api.getVersion()));
            }
            serviceList.add(definitionContext);
            genFiles.add(this.generateService(definitionContext));
            genFiles.add(this.generateSwagger(definitionContext));
        }
        genFiles.add(this.generateMainBal(serviceList));
        genFiles.add(this.generateCommonEndpoints());
        CodegenUtils.writeGeneratedSources(genFiles, Paths.get(projectSrcPath, new String[0]), overwrite);
        GatewayCmdUtils.copyFilesToSources(GatewayCmdUtils.getProjectExtensionsDirectoryPath(projectName) + File.separator + "extension_filter.bal", projectSrcPath + File.separator + "extension_filter.bal");
        GatewayCmdUtils.copyFilesToSources(GatewayCmdUtils.getProjectExtensionsDirectoryPath(projectName) + File.separator + "token_revocation_extension.bal", projectSrcPath + File.separator + "token_revocation_extension.bal");
    }

    public void generate(String projectName, boolean overwrite) throws IOException {
        String projectSrcPath = GatewayCmdUtils.getProjectGenSrcDirectoryPath(projectName);
        ArrayList<GenSrcFile> genFiles = new ArrayList<GenSrcFile>();
        ArrayList<BallerinaService> serviceList = new ArrayList<BallerinaService>();
        String openApiPath = GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "api_definitions";
        Files.walk(Paths.get(openApiPath, new String[0]), new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith(".json")).forEach(path -> {
            ExtendedAPI api = OpenAPICodegenUtils.generateAPIFromOpenAPIDef(path.toString());
            String basepath = MgwDefinitionBuilder.getBasePath(api.getName(), api.getVersion());
            api.setContext(basepath);
            OpenAPICodegenUtils.setAdditionalConfigsDevFirst(api);
            OpenAPI openAPI = new OpenAPIV3Parser().read(path.toString());
            try {
                BallerinaService definitionContext = new BallerinaService().buildContext(openAPI, api);
                genFiles.add(this.generateService(definitionContext));
                serviceList.add(definitionContext);
            }
            catch (BallerinaServiceGenException e) {
                throw new CLIRuntimeException("Swagger definition cannot be parsed to ballerina code", e);
            }
            catch (IOException e) {
                throw new CLIInternalException("File write operations failed during ballerina code generation");
            }
        });
        genFiles.add(this.generateMainBal(serviceList));
        genFiles.add(this.generateCommonEndpoints());
        CodegenUtils.writeGeneratedSources(genFiles, Paths.get(projectSrcPath, new String[0]), overwrite);
        GatewayCmdUtils.copyFilesToSources(GatewayCmdUtils.getProjectExtensionsDirectoryPath(projectName) + File.separator + "extension_filter.bal", projectSrcPath + File.separator + "extension_filter.bal");
        GatewayCmdUtils.copyFilesToSources(GatewayCmdUtils.getProjectExtensionsDirectoryPath(projectName) + File.separator + "token_revocation_extension.bal", projectSrcPath + File.separator + "token_revocation_extension.bal");
    }

    private GenSrcFile generateService(BallerinaService context) throws IOException {
        String concatTitle = context.getQualifiedServiceName();
        String srcFile = concatTitle + ".bal";
        String mainContent = this.getContent(context, GeneratorConstants.DEFAULT_TEMPLATE_DIR, "service");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, mainContent);
    }

    private GenSrcFile generateMainBal(List<BallerinaService> services) throws IOException {
        String srcFile = "main.bal";
        String mainContent = this.getContent(services, GeneratorConstants.DEFAULT_TEMPLATE_DIR, "main");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, mainContent);
    }

    private GenSrcFile generateCommonEndpoints() throws IOException {
        String srcFile = "listeners.bal";
        ListenerEndpoint listnerEndpoint = new ListenerEndpoint().buildContext();
        String endpointContent = this.getContent(listnerEndpoint, GeneratorConstants.DEFAULT_TEMPLATE_DIR, "listeners");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, endpointContent);
    }

    private String getContent(Object endpoints, String templateDir, String templateName) throws IOException {
        Template template = CodegenUtils.compileTemplate(templateDir, templateName);
        Context context = Context.newBuilder((Object)endpoints).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE}).build();
        return template.apply(context);
    }

    public void generateGrpc(String projectName, String apiDef, boolean overwrite) throws IOException, BallerinaServiceGenException {
        String projectSrcPath = GatewayCmdUtils.getProjectGenSwaggerPath(projectName, "");
        String projectGrpcPath = GatewayCmdUtils.getProjectGrpcDirectoryPath();
        ArrayList<GenSrcFile> genFiles = new ArrayList<GenSrcFile>();
        File dir = new File(projectGrpcPath);
        File[] files = dir.listFiles();
        genFiles.add(this.generateCommonEndpoints());
        CodegenUtils.writeGeneratedSources(genFiles, Paths.get(projectSrcPath, new String[0]), overwrite);
        GatewayCmdUtils.copyFilesToSources(GatewayCmdUtils.getFiltersFolderLocation() + File.separator + "extension_filter.bal", projectSrcPath + File.separator + "extension_filter.bal");
        GatewayCmdUtils.copyFilesToSources(GatewayCmdUtils.getFiltersFolderLocation() + File.separator + "token_revocation_extension.bal", projectSrcPath + File.separator + "token_revocation_extension.bal");
        for (File file : dir.listFiles()) {
            String filePath = file.getAbsolutePath();
            String fileName = file.getName();
            FileSystem fileSys = FileSystems.getDefault();
            Path source = fileSys.getPath(filePath, new String[0]);
            Path destination = fileSys.getPath(projectSrcPath + File.separator + fileName, new String[0]);
            Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        File temp = new File(GatewayCmdUtils.getProjectGrpcSoloDirectoryPath());
        dir.delete();
        temp.delete();
    }

    private GenSrcFile generateSwagger(BallerinaService context) throws IOException {
        String concatTitle = context.getName();
        String srcFile = concatTitle + "_swagger" + ".json";
        String mainContent = this.getContent(context, GeneratorConstants.DEFAULT_TEMPLATE_DIR, "generateSwagger");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, mainContent);
    }
}

