/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.config;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.wso2.apimgt.gateway.cli.exception.ConfigParserException;

public class TOMLConfigParser {
    public static <T> T parse(String configFilePath, Class<T> type) throws ConfigParserException {
        String content;
        Path configurationFile = Paths.get(configFilePath, new String[0]);
        if (!Files.exists(configurationFile, new LinkOption[0])) {
            throw new ConfigParserException("Mandatory configuration file '" + configurationFile + "' does not exists.");
        }
        try {
            content = new String(Files.readAllBytes(configurationFile), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ConfigParserException("Cannot read the content of configuration file '" + configurationFile + "'.", e);
        }
        T loadedBean = TOMLConfigParser.parseString(content, type);
        return loadedBean;
    }

    public static void write(String configFilePath, Object content) throws ConfigParserException {
        Path configurationFile = Paths.get(configFilePath, new String[0]);
        if (!Files.exists(configurationFile, new LinkOption[0])) {
            throw new ConfigParserException("Mandatory configuration file '" + configurationFile + "' does not exists.");
        }
        TomlWriter tomlWriter = new TomlWriter();
        try {
            tomlWriter.write(content, new File(configFilePath));
        }
        catch (IOException e) {
            throw new ConfigParserException("Cannot write the content to configuration file '" + configurationFile + "'.", e);
        }
    }

    private static <T> T parseString(String configFileContent, Class<T> type) {
        return (T)new Toml().read(configFileContent).to(type);
    }
}

