/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.hashing;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.HashingException;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;

public class LibHashUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibHashUtils.class);
    private static final String MD5 = "MD5";

    public static boolean detectChangesInLibraries() throws HashingException {
        boolean iseDetected = false;
        try {
            Map<String, String> storedHashes;
            String hashFilePath = GatewayCmdUtils.getCLILibHashHolderFileLocation();
            if (Files.exists(Paths.get(hashFilePath, new String[0]), new LinkOption[0])) {
                storedHashes = GatewayCmdUtils.readFileToMap(hashFilePath);
            } else {
                storedHashes = new HashMap<String, String>();
                storedHashes.put("platform", "");
                storedHashes.put("runtime", "");
            }
            String libPath = GatewayCmdUtils.getCLILibPath();
            for (Map.Entry<String, String> entry : storedHashes.entrySet()) {
                String filePath = libPath + File.separator + entry.getKey() + ".zip";
                try {
                    String checkSum;
                    if (!Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]) || (checkSum = LibHashUtils.getFileCheckSum(filePath)).equals(entry.getValue())) continue;
                    logger.debug("Checksum difference detected for key : " + entry.getKey());
                    storedHashes.put(entry.getKey(), checkSum);
                    iseDetected = true;
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    logger.error("Error while calculating check sum for path : " + filePath, (Throwable)e);
                }
            }
            if (iseDetected) {
                GatewayCmdUtils.writeMapToFile(storedHashes, hashFilePath);
                return true;
            }
            logger.debug("No checksum difference detected in the lib directories");
            return false;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new HashingException("Error while gateway library change detection", e);
        }
    }

    private static String getFileCheckSum(String filePath) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(MD5);
        md.update(Files.readAllBytes(Paths.get(filePath, new String[0])));
        byte[] digest = md.digest();
        return DatatypeConverter.printHexBinary((byte[])digest).toUpperCase();
    }
}

