/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.model.definition;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.apimgt.gateway.cli.model.definition.APIDefinition;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class APIDefinitions {
    private Map<String, APIDefinition> apis = new LinkedHashMap<String, APIDefinition>();

    @JsonAnySetter
    public void setApis(String key, APIDefinition api) {
        this.apis.put(key, api);
    }

    public Map<String, APIDefinition> getApisMap() {
        return this.apis;
    }

    public APIDefinition getApiFromBasepath(String basepath) {
        return this.apis.get(basepath);
    }

    public String getBasepathFromAPI(String apiName, String apiVersion) {
        for (Map.Entry<String, APIDefinition> apiEntry : this.apis.entrySet()) {
            if (!apiEntry.getValue().getTitle().equals(apiName) || !apiEntry.getValue().getVersion().equals(apiVersion)) continue;
            apiEntry.getValue().setIsDefinitionUsed(true);
            return apiEntry.getKey();
        }
        return null;
    }
}

