/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.model.template.service;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;
import org.wso2.apimgt.gateway.cli.model.config.BasicAuth;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.ContainerConfig;
import org.wso2.apimgt.gateway.cli.model.config.Etcd;
import org.wso2.apimgt.gateway.cli.model.mgwcodegen.MgwEndpointConfigDTO;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaOpenAPIObject;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaOperation;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaPath;
import org.wso2.apimgt.gateway.cli.utils.CodegenUtils;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.MgwDefinitionBuilder;

public class BallerinaService
implements BallerinaOpenAPIObject<BallerinaService, OpenAPI> {
    private String name;
    private ExtendedAPI api;
    private ContainerConfig containerConfig;
    private Config config;
    private MgwEndpointConfigDTO endpointConfig;
    private String srcPackage;
    private String modelPackage;
    private String qualifiedServiceName;
    private Info info = null;
    private ExternalDocumentation externalDocs = null;
    private Set<Map.Entry<String, String>> security = null;
    private List<Tag> tags = null;
    private Set<Map.Entry<String, BallerinaPath>> paths = null;
    private Etcd etcd;
    private String basepath;
    private boolean isDevFirst = true;

    @Override
    public BallerinaService buildContext(OpenAPI openAPI) throws BallerinaServiceGenException {
        this.info = openAPI.getInfo();
        this.externalDocs = openAPI.getExternalDocs();
        this.tags = openAPI.getTags();
        this.containerConfig = GatewayCmdUtils.getContainerConfig();
        this.setSecuritySchemas(this.api.getApiSecurity());
        this.config = GatewayCmdUtils.getConfig();
        this.etcd = GatewayCmdUtils.getEtcd();
        this.setPaths(openAPI);
        return this;
    }

    @Override
    public BallerinaService buildContext(OpenAPI definition, ExtendedAPI api) throws BallerinaServiceGenException {
        this.name = CodegenUtils.trim(api.getName());
        this.api = api;
        this.qualifiedServiceName = CodegenUtils.trim(api.getName()) + "_" + this.replaceAllNonAlphaNumeric(api.getVersion());
        this.endpointConfig = api.getEndpointConfigRepresentation();
        this.setBasepath(api.getSpecificBasepath());
        return this.buildContext(definition);
    }

    @Override
    public BallerinaService getDefaultValue() {
        return null;
    }

    public BallerinaService srcPackage(String srcPackage) {
        if (srcPackage != null) {
            this.srcPackage = srcPackage.replaceFirst("\\.", "/");
        }
        return this;
    }

    public BallerinaService modelPackage(String modelPackage) {
        if (modelPackage != null) {
            this.modelPackage = modelPackage.replaceFirst("\\.", "/");
        }
        return this;
    }

    public String getSrcPackage() {
        return this.srcPackage;
    }

    public String getModelPackage() {
        return this.modelPackage;
    }

    public Info getInfo() {
        return this.info;
    }

    public Set<Map.Entry<String, String>> getSecurity() {
        return this.security;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Set<Map.Entry<String, BallerinaPath>> getPaths() {
        return this.paths;
    }

    private void setPaths(OpenAPI openAPI) throws BallerinaServiceGenException {
        if (openAPI.getPaths() == null) {
            return;
        }
        this.paths = new LinkedHashSet<Map.Entry<String, BallerinaPath>>();
        Paths pathList = openAPI.getPaths();
        for (Map.Entry path : pathList.entrySet()) {
            BallerinaPath balPath = new BallerinaPath().buildContext((PathItem)path.getValue(), this.api);
            balPath.getOperations().forEach(operation -> {
                String operationId = (String)operation.getKey() + "_" + UUID.randomUUID().toString().replaceAll("-", "_");
                ((BallerinaOperation)operation.getValue()).setOperationId(operationId);
                if (this.isDevFirst) {
                    String apiResponseInterceptor;
                    String apiRequestInterceptor;
                    String throttle_policy;
                    String responseInterceptor;
                    String requestInterceptor;
                    String basePath = MgwDefinitionBuilder.getBasePath(openAPI.getInfo().getTitle(), openAPI.getInfo().getVersion());
                    MgwEndpointConfigDTO epConfig = MgwDefinitionBuilder.getResourceEpConfigForCodegen(basePath, (String)path.getKey(), (String)operation.getKey());
                    if (epConfig != null) {
                        ((BallerinaOperation)operation.getValue()).setEpConfigDTO(epConfig);
                    }
                    if ((requestInterceptor = MgwDefinitionBuilder.getRequestInterceptor(basePath, (String)path.getKey(), (String)operation.getKey())) != null) {
                        ((BallerinaOperation)operation.getValue()).setRequestInterceptor(requestInterceptor);
                    }
                    if ((responseInterceptor = MgwDefinitionBuilder.getResponseInterceptor(basePath, (String)path.getKey(), (String)operation.getKey())) != null) {
                        ((BallerinaOperation)operation.getValue()).setResponseInterceptor(responseInterceptor);
                    }
                    if ((throttle_policy = MgwDefinitionBuilder.getThrottlePolicy(basePath, (String)path.getKey(), (String)operation.getKey())) != null) {
                        ((BallerinaOperation)operation.getValue()).setResourceTier(throttle_policy);
                    }
                    if ((apiRequestInterceptor = MgwDefinitionBuilder.getApiRequestInterceptor(basePath)) != null && !apiRequestInterceptor.equals(requestInterceptor)) {
                        ((BallerinaOperation)operation.getValue()).setApiRequestInterceptor(apiRequestInterceptor);
                    }
                    if ((apiResponseInterceptor = MgwDefinitionBuilder.getApiResponseInterceptor(basePath)) != null) {
                        ((BallerinaOperation)operation.getValue()).setApiResponseInterceptor(apiResponseInterceptor);
                    }
                }
            });
            this.paths.add(new AbstractMap.SimpleEntry(path.getKey(), balPath));
        }
    }

    private String replaceAllNonAlphaNumeric(String value) {
        return value.replaceAll("[^a-zA-Z0-9]+", "_");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MgwEndpointConfigDTO getEndpointConfig() {
        return this.endpointConfig;
    }

    public void setEndpointConfig(MgwEndpointConfigDTO endpointConfig) {
        this.endpointConfig = endpointConfig;
    }

    public ExtendedAPI getApi() {
        return this.api;
    }

    public void setApi(ExtendedAPI api) {
        this.api = api;
    }

    public String getQualifiedServiceName() {
        return this.qualifiedServiceName;
    }

    public void setQualifiedServiceName(String qualifiedServiceName) {
        this.qualifiedServiceName = qualifiedServiceName;
    }

    public ContainerConfig getContainerConfig() {
        return this.containerConfig;
    }

    public void setContainerConfig(ContainerConfig containerConfig) {
        this.containerConfig = containerConfig;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public String getBasepath() {
        return this.basepath;
    }

    public void setBasepath(String basepath) {
        this.basepath = basepath;
    }

    private void setSecuritySchemas(String schemas) {
        String[] schemasArray;
        Config config = GatewayCmdUtils.getConfig();
        BasicAuth basicAuth = new BasicAuth();
        boolean basic = false;
        boolean oauth2 = false;
        for (String s : schemasArray = schemas.trim().split("\\s*,\\s*")) {
            if (s.equalsIgnoreCase("basic")) {
                basic = true;
                continue;
            }
            if (!s.equalsIgnoreCase("oauth2")) continue;
            oauth2 = true;
        }
        if (basic && oauth2) {
            basicAuth.setOptional(true);
            basicAuth.setRequired(false);
        } else if (basic) {
            basicAuth.setRequired(true);
            basicAuth.setOptional(false);
        } else if (oauth2) {
            basicAuth.setOptional(false);
            basicAuth.setRequired(false);
        }
        config.setBasicAuth(basicAuth);
    }

    public void setIsDevFirst(boolean value) {
        this.isDevFirst = value;
    }
}

