/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.MutualSSL;
import org.wso2.apimgt.gateway.cli.model.rest.APIListDTO;
import org.wso2.apimgt.gateway.cli.model.rest.ClientCertMetadataDTO;
import org.wso2.apimgt.gateway.cli.model.rest.ClientCertificatesDTO;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyListDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyListDTO;
import org.wso2.apimgt.gateway.cli.rest.RESTAPIService;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.TokenManagementUtil;

public class RESTAPIServiceImpl
implements RESTAPIService {
    private static final Logger logger = LoggerFactory.getLogger(RESTAPIServiceImpl.class);
    private String publisherEp;
    private String adminEp;
    private boolean inSecure;

    public RESTAPIServiceImpl(String publisherEp, String adminEp, boolean inSecure) {
        this.publisherEp = publisherEp;
        this.adminEp = adminEp;
        this.inSecure = inSecure;
    }

    @Override
    public List<ExtendedAPI> getAPIs(String labelName, String accessToken) {
        APIListDTO apiListDTO;
        block10: {
            logger.debug("Retrieving APIs with label {}", (Object)labelName);
            HttpURLConnection urlConn = null;
            try {
                this.publisherEp = this.publisherEp.endsWith("/") ? this.publisherEp : this.publisherEp + "/";
                String urlStr = this.publisherEp + "apis?query=label:${label}%20status:PUBLISHED&expand=true&limit=500".replace("${label}", URLEncoder.encode(labelName, "UTF-8"));
                logger.debug("GET API URL: {}", (Object)urlStr);
                URL url = new URL(urlStr);
                urlConn = (HttpsURLConnection)url.openConnection();
                if (this.inSecure) {
                    ((HttpsURLConnection)urlConn).setHostnameVerifier((s, sslSession) -> true);
                }
                urlConn.setDoOutput(true);
                urlConn.setRequestMethod("GET");
                urlConn.setRequestProperty("Authorization", "Bearer " + accessToken);
                int responseCode = urlConn.getResponseCode();
                logger.debug("Response code: {}", (Object)responseCode);
                if (responseCode == 200) {
                    ObjectMapper mapper = new ObjectMapper();
                    String responseStr = TokenManagementUtil.getResponseString(urlConn.getInputStream());
                    logger.trace("Response body: {}", (Object)responseStr);
                    apiListDTO = (APIListDTO)mapper.readValue(responseStr, APIListDTO.class);
                    for (ExtendedAPI api : apiListDTO.getList()) {
                        this.setAdditionalConfigs(api);
                    }
                    break block10;
                }
                if (responseCode == 401) {
                    throw new CLIRuntimeException("Invalid user credentials or the user does not have required permissions");
                }
                throw new RuntimeException("Error occurred while getting token. Status code: " + responseCode);
            }
            catch (IOException e) {
                String msg = "Error while getting all APIs with label " + labelName;
                throw new RuntimeException(msg, e);
            }
            finally {
                if (urlConn != null) {
                    urlConn.disconnect();
                }
            }
        }
        logger.debug("Retrieving APIs with label {} was successful.", (Object)labelName);
        return apiListDTO.getList();
    }

    @Override
    public ExtendedAPI getAPI(String apiName, String version, String accessToken) {
        ExtendedAPI matchedAPI;
        block13: {
            logger.debug("Retrieving API with name {}, version {}", (Object)apiName, (Object)version);
            HttpURLConnection urlConn = null;
            matchedAPI = null;
            try {
                this.publisherEp = this.publisherEp.endsWith("/") ? this.publisherEp : this.publisherEp + "/";
                String urlStr = this.publisherEp + "apis?query=name:${name}%20version:${version}%20status:PUBLISHED&expand=true".replace("${name}", URLEncoder.encode(apiName, "UTF-8")).replace("${version}", URLEncoder.encode(version, "UTF-8"));
                logger.debug("GET API URL: {}", (Object)urlStr);
                URL url = new URL(urlStr);
                urlConn = (HttpsURLConnection)url.openConnection();
                if (this.inSecure) {
                    ((HttpsURLConnection)urlConn).setHostnameVerifier((s, sslSession) -> true);
                }
                urlConn.setDoOutput(true);
                urlConn.setRequestMethod("GET");
                urlConn.setRequestProperty("Authorization", "Bearer " + accessToken);
                int responseCode = urlConn.getResponseCode();
                logger.debug("Response code: {}", (Object)responseCode);
                if (responseCode == 200) {
                    ObjectMapper mapper = new ObjectMapper();
                    String responseStr = TokenManagementUtil.getResponseString(urlConn.getInputStream());
                    logger.trace("Response body: {}", (Object)responseStr);
                    APIListDTO apiList = (APIListDTO)mapper.readValue(responseStr, APIListDTO.class);
                    if (apiList != null) {
                        for (ExtendedAPI api : apiList.getList()) {
                            if (!apiName.equals(api.getName()) || !version.equals(api.getVersion())) continue;
                            matchedAPI = api;
                            break;
                        }
                        if (matchedAPI == null) {
                            Iterator<ExtendedAPI> iterator = matchedAPI;
                            return iterator;
                        }
                        this.setAdditionalConfigs(matchedAPI);
                        break block13;
                    }
                    if (responseCode == 401) {
                        throw new CLIRuntimeException("Invalid user credentials or the user does not have required permissions");
                    }
                    throw new CLIInternalException("No proper response received for get API request.");
                }
                throw new CLIInternalException("Error occurred while getting the token. Status code: " + responseCode);
            }
            catch (IOException e) {
                String msg = "Error while getting the API with name:" + apiName + ", version: " + version;
                throw new CLIInternalException(msg, e);
            }
            finally {
                if (urlConn != null) {
                    urlConn.disconnect();
                }
            }
        }
        logger.debug("Retrieving API with name {}, version {} was successful.", (Object)apiName, (Object)version);
        return matchedAPI;
    }

    private void setAdditionalConfigs(ExtendedAPI api) throws IOException {
        String endpointConfig = api.getEndpointConfig();
        Config config = GatewayCmdUtils.getConfig();
        if (config == null) {
            if (!api.getCorsConfiguration().getCorsConfigurationEnabled().booleanValue()) {
                api.setCorsConfiguration(GatewayCmdUtils.getDefaultCorsConfig());
            }
        } else if (config.getCorsConfiguration().getCorsConfigurationEnabled().booleanValue() && !api.getCorsConfiguration().getCorsConfigurationEnabled().booleanValue()) {
            api.setCorsConfiguration(config.getCorsConfiguration());
        }
    }

    @Override
    public List<ApplicationThrottlePolicyDTO> getApplicationPolicies(String accessToken) {
        ArrayList<ApplicationThrottlePolicyDTO> filteredPolicyDTOS;
        block10: {
            HttpURLConnection urlConn = null;
            filteredPolicyDTOS = new ArrayList<ApplicationThrottlePolicyDTO>();
            this.adminEp = this.adminEp.endsWith("/") ? this.adminEp : this.adminEp + "/";
            try {
                String urlStr = this.adminEp + "throttling/policies/application";
                URL url = new URL(urlStr);
                urlConn = (HttpsURLConnection)url.openConnection();
                if (this.inSecure) {
                    ((HttpsURLConnection)urlConn).setHostnameVerifier((s, sslSession) -> true);
                }
                urlConn.setDoOutput(true);
                urlConn.setRequestMethod("GET");
                urlConn.setRequestProperty("Authorization", "Bearer " + accessToken);
                int responseCode = urlConn.getResponseCode();
                if (responseCode == 200) {
                    ObjectMapper mapper = new ObjectMapper();
                    String responseStr = TokenManagementUtil.getResponseString(urlConn.getInputStream());
                    ApplicationThrottlePolicyListDTO appsList = (ApplicationThrottlePolicyListDTO)mapper.readValue(responseStr, ApplicationThrottlePolicyListDTO.class);
                    List<ApplicationThrottlePolicyDTO> policyDTOS = appsList.getList();
                    for (ApplicationThrottlePolicyDTO policyDTO : policyDTOS) {
                        if ("Unlimited".equalsIgnoreCase(policyDTO.getPolicyName())) continue;
                        filteredPolicyDTOS.add(policyDTO);
                    }
                    break block10;
                }
                if (responseCode == 401) {
                    throw new CLIRuntimeException("Invalid user credentials or the user does not have required permissions");
                }
                throw new RuntimeException("Error occurred while getting token. Status code: " + responseCode);
            }
            catch (IOException e) {
                String msg = "Error while creating the new token for token regeneration.";
                throw new RuntimeException(msg, e);
            }
            finally {
                if (urlConn != null) {
                    urlConn.disconnect();
                }
            }
        }
        return filteredPolicyDTOS;
    }

    @Override
    public List<SubscriptionThrottlePolicyDTO> getSubscriptionPolicies(String accessToken) {
        ArrayList<SubscriptionThrottlePolicyDTO> filteredPolicyDTOS;
        block10: {
            HttpURLConnection urlConn = null;
            filteredPolicyDTOS = new ArrayList<SubscriptionThrottlePolicyDTO>();
            this.adminEp = this.adminEp.endsWith("/") ? this.adminEp : this.adminEp + "/";
            try {
                String urlStr = this.adminEp + "throttling/policies/subscription";
                URL url = new URL(urlStr);
                urlConn = (HttpsURLConnection)url.openConnection();
                if (this.inSecure) {
                    ((HttpsURLConnection)urlConn).setHostnameVerifier((s, sslSession) -> true);
                }
                urlConn.setDoOutput(true);
                urlConn.setRequestMethod("GET");
                urlConn.setRequestProperty("Authorization", "Bearer " + accessToken);
                int responseCode = urlConn.getResponseCode();
                if (responseCode == 200) {
                    ObjectMapper mapper = new ObjectMapper();
                    String responseStr = TokenManagementUtil.getResponseString(urlConn.getInputStream());
                    SubscriptionThrottlePolicyListDTO subsList = (SubscriptionThrottlePolicyListDTO)mapper.readValue(responseStr, SubscriptionThrottlePolicyListDTO.class);
                    List<SubscriptionThrottlePolicyDTO> policyDTOS = subsList.getList();
                    for (SubscriptionThrottlePolicyDTO policyDTO : policyDTOS) {
                        if ("Unlimited".equalsIgnoreCase(policyDTO.getPolicyName())) continue;
                        filteredPolicyDTOS.add(policyDTO);
                    }
                    break block10;
                }
                if (responseCode == 401) {
                    throw new CLIRuntimeException("Invalid user credentials or the user does not have required permissions");
                }
                throw new RuntimeException("Error occurred while getting token. Status code: " + responseCode);
            }
            catch (IOException e) {
                String msg = "Error while creating the new token for token regeneration.";
                throw new RuntimeException(msg, e);
            }
            finally {
                if (urlConn != null) {
                    urlConn.disconnect();
                }
            }
        }
        return filteredPolicyDTOS;
    }

    @Override
    public List<ClientCertMetadataDTO> getClientCertificates(String accessToken) {
        ArrayList<ClientCertMetadataDTO> selectedCertificates;
        Config config;
        block12: {
            config = GatewayCmdUtils.getConfig();
            HttpURLConnection urlConn = null;
            selectedCertificates = new ArrayList<ClientCertMetadataDTO>();
            this.publisherEp = this.publisherEp.endsWith("/") ? this.publisherEp : this.publisherEp + "/";
            try {
                String urlStr = this.publisherEp + "clientCertificates";
                URL url = new URL(urlStr);
                urlConn = (HttpsURLConnection)url.openConnection();
                if (this.inSecure) {
                    ((HttpsURLConnection)urlConn).setHostnameVerifier((s, sslSession) -> true);
                }
                urlConn.setDoOutput(true);
                urlConn.setRequestMethod("GET");
                urlConn.setRequestProperty("Authorization", "Bearer " + accessToken);
                int responseCode = urlConn.getResponseCode();
                if (responseCode == 200) {
                    ObjectMapper mapper = new ObjectMapper();
                    String responseStr = TokenManagementUtil.getResponseString(urlConn.getInputStream());
                    ClientCertificatesDTO certList = (ClientCertificatesDTO)mapper.readValue(responseStr, ClientCertificatesDTO.class);
                    List<ClientCertMetadataDTO> certDTOS = certList.getCertificates();
                    for (ClientCertMetadataDTO certDTO : certDTOS) {
                        if ("Unlimited".equalsIgnoreCase(certDTO.getTier())) continue;
                        selectedCertificates.add(certDTO);
                    }
                    break block12;
                }
                if (responseCode == 401) {
                    throw new CLIRuntimeException("Invalid user credentials or the user does not have required permissions");
                }
                if (responseCode == 404 || responseCode == 400) {
                    selectedCertificates = null;
                    break block12;
                }
                throw new RuntimeException("Error occurred while getting token. Status code: " + responseCode);
            }
            catch (IOException e) {
                String msg = "Error while creating the new token for token regeneration.";
                throw new RuntimeException(msg, e);
            }
            finally {
                if (urlConn != null) {
                    urlConn.disconnect();
                }
            }
        }
        if (selectedCertificates != null) {
            MutualSSL clientDetails = new MutualSSL();
            clientDetails.setClientCertificates(selectedCertificates);
            config.setMutualSSL(clientDetails);
        }
        return selectedCertificates;
    }
}

