/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cipher.AESCipherTool;
import org.wso2.apimgt.gateway.cli.cipher.AESCipherToolException;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerationContext;
import org.wso2.apimgt.gateway.cli.config.TOMLConfigParser;
import org.wso2.apimgt.gateway.cli.constants.GatewayCliConstants;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.exception.CliLauncherException;
import org.wso2.apimgt.gateway.cli.exception.ConfigParserException;
import org.wso2.apimgt.gateway.cli.hashing.HashUtils;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.ContainerConfig;
import org.wso2.apimgt.gateway.cli.model.config.Etcd;
import org.wso2.apimgt.gateway.cli.model.rest.APICorsConfigurationDTO;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.utils.OpenAPICodegenUtils;
import org.wso2.apimgt.gateway.cli.utils.ZipUtils;

public class GatewayCmdUtils {
    private static final Logger logger = LoggerFactory.getLogger(GatewayCmdUtils.class);
    private static Config config;
    private static ContainerConfig containerConfig;
    private static CodeGenerationContext codeGenerationContext;
    private static Etcd etcd;
    private static final String algorithm = "AES";
    private static boolean verboseLogsEnabled;

    public static Etcd getEtcd() {
        return etcd;
    }

    public static void setEtcd(Etcd etcd) {
        GatewayCmdUtils.etcd = etcd;
    }

    public static void saveEtcdEnabled(String projectName, boolean isEnabled) {
        GatewayCmdUtils.createFileIfNotExist(GatewayCmdUtils.getProjectGenDirectoryPath(projectName), "internal.conf");
        HashMap<String, String> confMap = new HashMap<String, String>(1);
        confMap.put("isEtcdEnabled", String.valueOf(isEnabled));
        try {
            GatewayCmdUtils.writeMapToFile(confMap, GatewayCmdUtils.getProjectGenDirectoryPath(projectName) + File.separator + "internal.conf");
        }
        catch (IOException e) {
            throw new CLIInternalException("Error while writing etcdEnabled to the internal.conf file", e);
        }
    }

    public static boolean getEtcdEnabled(String projectName) {
        String internalConfPath = GatewayCmdUtils.getProjectGenDirectoryPath(projectName) + File.separator + "internal.conf";
        if (!new File(internalConfPath).exists()) {
            return false;
        }
        try {
            return Boolean.valueOf(GatewayCmdUtils.readFileToMap(internalConfPath).get("isEtcdEnabled"));
        }
        catch (IOException e) {
            throw new CLIInternalException("Error while reading the internal.conf file", e);
        }
        catch (ClassNotFoundException e) {
            throw new CLIInternalException("Error while while reading the internal.conf file", e);
        }
    }

    public static Config getConfig() {
        return config;
    }

    public static void setConfig(Config configFromFile) {
        config = configFromFile;
    }

    public static CodeGenerationContext getCodeGenerationContext() {
        return codeGenerationContext;
    }

    public static void setCodeGenerationContext(CodeGenerationContext codeGenerationContext) {
        GatewayCmdUtils.codeGenerationContext = codeGenerationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String path, boolean inResource) throws IOException {
        InputStream is;
        if (inResource) {
            path = GatewayCmdUtils.getUnixPath(path);
            is = ClassLoader.getSystemResourceAsStream(path);
        } else {
            is = new FileInputStream(new File(path));
        }
        InputStreamReader inputStreamREader = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            inputStreamREader = new InputStreamReader(is, StandardCharsets.UTF_8);
            br = new BufferedReader(inputStreamREader);
            String content = br.readLine();
            if (content == null) {
                String string = sb.toString();
                return string;
            }
            sb.append(content);
            while ((content = br.readLine()) != null) {
                sb.append('\n').append(content);
            }
        }
        finally {
            if (inputStreamREader != null) {
                try {
                    inputStreamREader.close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public static CliLauncherException createUsageException(String errorMsg) {
        CliLauncherException launcherException = new CliLauncherException();
        launcherException.addMessage("micro-gw: " + errorMsg);
        launcherException.addMessage("Run 'micro-gw help' for usage.");
        return launcherException;
    }

    public static String makeFirstLetterLowerCase(String s) {
        if (s == null) {
            return null;
        }
        char[] c = s.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    public static String encrypt(String value, String secret) {
        try {
            AESCipherTool cipherTool = new AESCipherTool(secret);
            return cipherTool.encrypt(value);
        }
        catch (AESCipherToolException e) {
            throw GatewayCmdUtils.createUsageException("failed to encrypt client secret");
        }
    }

    public static String decrypt(String value, String secret) {
        try {
            AESCipherTool cipherTool = new AESCipherTool(secret);
            return cipherTool.decrypt(value);
        }
        catch (AESCipherToolException e) {
            throw GatewayCmdUtils.createUsageException("failed to decrypt client secret");
        }
    }

    public static String getUserDir() {
        String currentDirProp = System.getProperty("current.dir");
        if (currentDirProp != null) {
            return currentDirProp;
        }
        return System.getProperty("user.dir");
    }

    public static String getCLIHome() {
        return System.getProperty("cli.home");
    }

    public static String getCLILibPath() {
        return GatewayCmdUtils.getCLIHome() + File.separator + "lib";
    }

    public static String getResourceFolderLocation() {
        return System.getProperty("cli.home") + File.separator + "resources";
    }

    public static String getLoggingPropertiesFileLocation() {
        return System.getProperty("cli.home") + File.separator + "conf" + File.separator + "logging.properties";
    }

    public static String getDefinitionsLocation() {
        return GatewayCmdUtils.getResourceFolderLocation() + File.separator + "definitions";
    }

    public static String getFiltersFolderLocation() {
        return GatewayCmdUtils.getResourceFolderLocation() + File.separator + "filters";
    }

    public static String getPoliciesFolderLocation() {
        return GatewayCmdUtils.getResourceFolderLocation() + File.separator + "policies";
    }

    private static String getConfigFolderLocation() {
        return GatewayCmdUtils.getResourceFolderLocation() + File.separator + "conf";
    }

    private static String getProjectTempFolderLocation(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "temp";
    }

    public static void createProjectStructure(String projectName) throws IOException {
        File projectDir = GatewayCmdUtils.createFolderIfNotExist(GatewayCmdUtils.getUserDir() + File.separator + projectName);
        String interceptorsPath = projectDir + File.separator + "interceptors";
        GatewayCmdUtils.createFolderIfNotExist(interceptorsPath);
        String extensionsPath = projectDir + File.separator + "extensions";
        GatewayCmdUtils.createFolderIfNotExist(extensionsPath);
        String targetDirPath = projectDir + File.separator + "target";
        GatewayCmdUtils.createFolderIfNotExist(targetDirPath);
        String confDirPath = projectDir + File.separator + "conf";
        GatewayCmdUtils.createFolderIfNotExist(confDirPath);
        String definitionsPath = projectDir + File.separator + "api_definitions";
        GatewayCmdUtils.createFolderIfNotExist(definitionsPath);
        String genDirPath = projectDir + File.separator + "gen";
        GatewayCmdUtils.createFolderIfNotExist(genDirPath);
        GatewayCmdUtils.createFileIfNotExist(projectDir.getPath(), "definition.yaml");
        GatewayCmdUtils.createFileIfNotExist(projectDir.getPath(), "policies.yaml");
        String policyResPath = GatewayCmdUtils.getDefinitionsLocation() + File.separator + "policies.yaml";
        File policyResFile = new File(policyResPath);
        File policesFile = new File(projectDir + File.separator + "policies.yaml");
        String extensionResPath = GatewayCmdUtils.getFiltersFolderLocation() + File.separator + "extension_filter.bal";
        File extensionResFile = new File(extensionResPath);
        File extensionFile = new File(extensionsPath + File.separator + "extension_filter.bal");
        String tokenRevocationResPath = GatewayCmdUtils.getFiltersFolderLocation() + File.separator + "token_revocation_extension.bal";
        File tokenRevocationResFile = new File(tokenRevocationResPath);
        File tokenRevocationFile = new File(extensionsPath + File.separator + "token_revocation_extension.bal");
        if (!Files.exists(extensionResFile.toPath(), new LinkOption[0])) {
            throw new CLIRuntimeException("Extension filter not found in CLI_HOME");
        }
        FileUtils.copyFile((File)extensionResFile, (File)extensionFile);
        if (!Files.exists(tokenRevocationResFile.toPath(), new LinkOption[0])) {
            throw new CLIRuntimeException("Token revocation extension not Found in CLI_HOME");
        }
        FileUtils.copyFile((File)tokenRevocationResFile, (File)tokenRevocationFile);
        if (!Files.exists(policyResFile.toPath(), new LinkOption[0])) {
            throw new CLIRuntimeException("Policy definition not found in CLI_HOME");
        }
        FileUtils.copyFile((File)policyResFile, (File)policesFile);
        GatewayCmdUtils.createGenDirectoryStructure(genDirPath);
    }

    public static void saveSwaggerDefinition(String projectName, String apiDefinition, String apiId) {
        if (apiDefinition.isEmpty()) {
            throw new CLIInternalException("No swagger definition is provided to generate API");
        }
        try {
            GatewayCmdUtils.writeContent(apiDefinition, new File(GatewayCmdUtils.getProjectGenSwaggerPath(projectName, apiId)));
        }
        catch (IOException e) {
            throw new CLIInternalException("Error while copying the swagger to the project directory");
        }
    }

    private static void saveSwaggerDefinitionForSingleAPI(String projectName, ExtendedAPI api) {
        String swaggerString = OpenAPICodegenUtils.generateSwaggerString(api);
        String apiId = HashUtils.generateAPIId(api.getName(), api.getVersion());
        GatewayCmdUtils.saveSwaggerDefinition(projectName, swaggerString, apiId);
    }

    public static void saveSwaggerDefinitionForMultipleAPIs(String projectName, List<ExtendedAPI> apis) {
        for (ExtendedAPI api : apis) {
            GatewayCmdUtils.saveSwaggerDefinitionForSingleAPI(projectName, api);
        }
    }

    public static void createProjectGWDistribution(String projectName) throws IOException {
        GatewayCmdUtils.createTargetGatewayDistStructure(projectName);
        String distPath = GatewayCmdUtils.getTargetDistPath(projectName);
        String gwDistPath = GatewayCmdUtils.getTargetGatewayDistPath(projectName);
        GatewayCmdUtils.copyFolder(GatewayCmdUtils.getCLIHome() + File.separator + "lib" + File.separator + "runtime", gwDistPath + File.separator + "runtime");
        GatewayCmdUtils.copyTargetDistBinScripts(projectName);
        GatewayCmdUtils.copyTargetDistBalx(projectName);
        GatewayCmdUtils.copyFilesToSources(GatewayCmdUtils.getConfigFolderLocation() + File.separator + "micro-gw.conf", gwDistPath + File.separator + "conf" + File.separator + "micro-gw.conf");
        String targetPath = GatewayCmdUtils.getProjectTargetDirectoryPath(projectName);
        String zipFileName = "micro-gw-" + projectName + ".zip";
        ZipUtils.zip(distPath, targetPath + File.separator + zipFileName);
        GatewayCmdUtils.cleanFolder(targetPath, (String[])ArrayUtils.add((Object[])GatewayCliConstants.PROJECTS_TARGET_DELETE_FILES, (Object)(projectName + ".balx")));
    }

    private static void createTargetGatewayDistStructure(String projectName) {
        String projectTargetPath = GatewayCmdUtils.getProjectTargetDirectoryPath(projectName);
        GatewayCmdUtils.createFolderIfNotExist(projectTargetPath);
        String distPath = GatewayCmdUtils.getTargetDistPath(projectName);
        GatewayCmdUtils.createFolderIfNotExist(distPath);
        String distMicroGWPath = GatewayCmdUtils.getTargetGatewayDistPath(projectName);
        GatewayCmdUtils.createFolderIfNotExist(distMicroGWPath);
        String distBinPath = distMicroGWPath + File.separator + "bin";
        GatewayCmdUtils.createFolderIfNotExist(distBinPath);
        String distConfPath = distMicroGWPath + File.separator + "conf";
        GatewayCmdUtils.createFolderIfNotExist(distConfPath);
        String logsDirPath = distMicroGWPath + File.separator + "logs";
        GatewayCmdUtils.createFolderIfNotExist(logsDirPath);
        GatewayCmdUtils.createFileIfNotExist(logsDirPath, "access_logs");
        String distExec = distMicroGWPath + File.separator + "exec";
        GatewayCmdUtils.createFolderIfNotExist(distExec);
        String apiUsageDir = distMicroGWPath + File.separator + "api-usage-data";
        GatewayCmdUtils.createFolderIfNotExist(apiUsageDir);
    }

    public static String loadStoredResourceHashes(String projectName) throws IOException {
        String resourceHashFileLocation = GatewayCmdUtils.getResourceHashHolderFileLocation(projectName);
        String content = null;
        if (new File(resourceHashFileLocation).exists()) {
            content = GatewayCmdUtils.readFileAsString(resourceHashFileLocation, false);
        }
        return content;
    }

    public static void storeResourceHashesFileContent(String content, String projectName) throws IOException {
        String tempDirPath = GatewayCmdUtils.getProjectTempFolderLocation(projectName);
        GatewayCmdUtils.createFolderIfNotExist(tempDirPath);
        String resourceHashesFileLocation = GatewayCmdUtils.getResourceHashHolderFileLocation(projectName);
        File pathFile = new File(resourceHashesFileLocation);
        if (!pathFile.exists()) {
            boolean created = pathFile.createNewFile();
            if (created) {
                logger.trace("Hashed file: {} created. ", (Object)resourceHashesFileLocation);
            } else {
                logger.error("Failed to create hash file: {} ", (Object)resourceHashesFileLocation);
                throw new CLIInternalException("Error occurred while setting up the workspace structure");
            }
        }
        GatewayCmdUtils.writeContent(content, pathFile);
    }

    public static String getSingleArgument(List<String> mainArgs) {
        if (mainArgs.size() != 1) {
            throw new CLIRuntimeException("Only one argument accepted, but provided: " + String.join((CharSequence)",", mainArgs));
        }
        return mainArgs.get(0);
    }

    private static String getResourceHashHolderFileLocation(String projectName) {
        return GatewayCmdUtils.getProjectTempFolderLocation(projectName) + File.separator + "hashes.json";
    }

    public static String getCLILibHashHolderFileLocation() {
        return GatewayCmdUtils.getCLIHome() + File.separator + "temp" + File.separator + "hashes";
    }

    private static String getTargetDistPath(String projectName) {
        return GatewayCmdUtils.getProjectTargetDirectoryPath(projectName) + File.separator + "distribution";
    }

    private static String getTargetGatewayDistPath(String projectName) {
        return GatewayCmdUtils.getTargetDistPath(projectName) + File.separator + "micro-gw-" + projectName;
    }

    private static void copyTargetDistBinScripts(String projectName) throws IOException {
        String targetPath = GatewayCmdUtils.getTargetGatewayDistPath(projectName);
        String binDir = targetPath + File.separator + "bin" + File.separator;
        String linuxShContent = GatewayCmdUtils.readFileAsString(GatewayCliConstants.GW_DIST_SH_PATH, true);
        linuxShContent = linuxShContent.replace("${label}", projectName);
        File shPathFile = new File(binDir + "gateway");
        GatewayCmdUtils.saveScript(linuxShContent, shPathFile);
        String winBatContent = GatewayCmdUtils.readFileAsString(GatewayCliConstants.GW_DIST_BAT_PATH, true);
        winBatContent = winBatContent.replace("${label}", projectName);
        File batPathFile = new File(binDir + "gateway.bat");
        GatewayCmdUtils.saveScript(winBatContent, batPathFile);
    }

    private static void copyTargetDistBalx(String projectName) throws IOException {
        String projectGenTargetDirectoryPath = GatewayCmdUtils.getProjectGenDirectoryPath(projectName) + File.separator + "target";
        String gatewayDistExecPath = GatewayCmdUtils.getTargetGatewayDistPath(projectName) + File.separator + "exec";
        File gatewayDistExecPathFile = new File(gatewayDistExecPath + File.separator + projectName + ".balx");
        File balxSourceFile = new File(projectGenTargetDirectoryPath + File.separator + projectName + ".balx");
        if (!balxSourceFile.exists()) {
            throw new CLIInternalException(projectName + ".balx could not be found in " + projectGenTargetDirectoryPath);
        }
        FileUtils.copyFile((File)balxSourceFile, (File)gatewayDistExecPathFile);
    }

    public static String getMainConfigLocation() {
        return GatewayCmdUtils.getCLIHome() + File.separator + "conf" + File.separator + "toolkit-config.toml";
    }

    private static String getProjectConfigDirPath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "conf";
    }

    public static String getDeploymentConfigLocation(String projectName) {
        return GatewayCmdUtils.getProjectConfigDirPath(projectName) + File.separator + "deployment-config.toml";
    }

    public static String getProjectDirectoryPath(String projectName) {
        return GatewayCmdUtils.getUserDir() + File.separator + projectName;
    }

    public static String getProjectGenDirectoryPath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "gen";
    }

    public static String getProjectGenSrcDirectoryPath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "gen" + File.separator + "src";
    }

    public static String getProjectExtensionsDirectoryPath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "extensions";
    }

    public static String getProjectInterceptorsDirectoryPath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "interceptors";
    }

    public static String getProjectGenSrcInterceptorsDirectoryPath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "gen" + File.separator + "src" + File.separator + "interceptors";
    }

    public static String getProjectGenSwaggerPath(String projectName, String apiId) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "gen" + File.separator + "api_definitions" + File.separator + apiId + "swagger.json";
    }

    public static String getProjectSwaggerPath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "api_definitions";
    }

    public static String getProjectGrpcDirectoryPath() {
        return GatewayCmdUtils.getUserDir() + File.separator + "grpc_service" + File.separator + "client";
    }

    public static String getProjectGrpcSoloDirectoryPath() {
        return GatewayCmdUtils.getUserDir() + File.separator + "grpc_service";
    }

    private static String getProjectTargetDirectoryPath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "target";
    }

    public static String getProjectAPIDefinitionsDirectoryPath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "gen" + File.separator + "api_definitions";
    }

    public static String getProjectMgwDefinitionFilePath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "definition.yaml";
    }

    public static void copyFolder(String source, String destination) throws IOException {
        File sourceFolder = new File(source);
        File destinationFolder = new File(destination);
        GatewayCmdUtils.copyFolder(sourceFolder, destinationFolder);
    }

    public static void copyAndReplaceFolder(String source, String destination) throws IOException {
        File sourceFolder = new File(source);
        File destinationFolder = new File(destination);
        if (destinationFolder.exists()) {
            GatewayCmdUtils.delete(destinationFolder);
        }
        GatewayCmdUtils.copyFolder(sourceFolder, destinationFolder);
    }

    public static void copyFilesToSources(String sourcePath, String destinationPath) throws IOException {
        Files.copy(Paths.get(sourcePath, new String[0]), Paths.get(destinationPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    private static void cleanFolder(String targetPath, String ... delete) throws IOException {
        File targetFolder = new File(targetPath);
        logger.debug("Cleaning the target folder: {}", (Object)targetPath);
        if (!targetFolder.isDirectory()) {
            logger.warn("Nothing to delete. Target folder {} is not a directory.", (Object)targetPath);
            return;
        }
        String[] files = targetFolder.list();
        if (files == null) {
            logger.warn("Nothing to delete. Target folder {} is empty.", (Object)targetPath);
            return;
        }
        for (String file : files) {
            for (String deleteFile : delete) {
                boolean success;
                if (!file.equals(deleteFile)) {
                    logger.trace("Keeping file: {}", (Object)file);
                    continue;
                }
                logger.trace("Deleting file: {}", (Object)file);
                File fileToDelete = new File(targetFolder, file);
                if (fileToDelete.isDirectory()) {
                    FileUtils.deleteDirectory((File)fileToDelete);
                    success = !fileToDelete.exists();
                } else {
                    success = fileToDelete.delete();
                }
                if (success) {
                    logger.trace("Deleting file {} is successful.", (Object)file);
                    continue;
                }
                logger.trace("Deleting file {} failed.", (Object)file);
            }
        }
        logger.debug("Cleaning the target folder {} complete.", (Object)targetPath);
    }

    private static void copyFolder(File sourceFolder, File destinationFolder) throws IOException {
        if (sourceFolder.isDirectory()) {
            String[] files;
            if (!destinationFolder.exists()) {
                boolean created = destinationFolder.mkdir();
                if (created) {
                    logger.trace("Directory: {} created. ", (Object)destinationFolder.getAbsolutePath());
                } else {
                    logger.error("Failed to create directory: {} ", (Object)destinationFolder.getAbsolutePath());
                    throw new CLIInternalException("Error occurred while setting up the workspace structure");
                }
            }
            if ((files = sourceFolder.list()) != null) {
                for (String file : files) {
                    File srcFile = new File(sourceFolder, file);
                    File destFile = new File(destinationFolder, file);
                    GatewayCmdUtils.copyFolder(srcFile, destFile);
                }
            }
        } else {
            Files.copy(sourceFolder.toPath(), destinationFolder.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            boolean success = destinationFolder.setWritable(true);
            if (!success) {
                logger.debug("Setting write permission failed for {}", (Object)destinationFolder.getAbsolutePath());
            }
        }
    }

    private static File createFolderIfNotExist(String path) {
        File folder = new File(path);
        if (!folder.exists() && !folder.isDirectory()) {
            boolean created = folder.mkdir();
            if (created) {
                logger.trace("Directory: {} created. ", (Object)path);
            } else {
                logger.error("Failed to create directory: {} ", (Object)path);
                throw new CLIInternalException("Error occurred while setting up the workspace structure");
            }
        }
        return folder;
    }

    public static void writeContent(String content, File file) throws IOException {
        FileWriter writer = null;
        writer = new FileWriter(file);
        writer.write(content);
        writer.flush();
    }

    private static void createFileIfNotExist(String path, String fileName) {
        String filePath = path + File.separator + fileName;
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                boolean created = file.createNewFile();
                if (!created) {
                    logger.error("Failed to create file: {} ", (Object)path);
                    throw new CLIInternalException("Error occurred while setting up the workspace structure");
                }
                logger.trace("File: {} created. ", (Object)path);
            }
            catch (IOException e) {
                logger.error("Failed to create file: {} ", (Object)path, (Object)e);
                throw new CLIInternalException("Error occurred while setting up the workspace structure");
            }
        }
    }

    public static void createDeploymentConfig(String projectName, String deploymentConfPath) throws IOException {
        String depConfig = GatewayCmdUtils.getProjectConfigDirPath(projectName) + File.separator + "deployment-config.toml";
        File file = new File(depConfig);
        if (deploymentConfPath == null) {
            if (!file.exists()) {
                boolean created = file.createNewFile();
                if (!created) {
                    throw new CLIInternalException("Failed to create the deployment configuration file: " + depConfig);
                }
                logger.debug("Deployment configuration file: {} created.", (Object)depConfig);
                String defaultConfig = GatewayCmdUtils.readFileAsString("default-deployment-config.toml", true);
                GatewayCmdUtils.writeContent(defaultConfig, file);
            }
        } else {
            File inputDepConfFile = new File(deploymentConfPath);
            if (inputDepConfFile.exists()) {
                String inputConfigContent = GatewayCmdUtils.readFileAsString(deploymentConfPath, false);
                try {
                    TOMLConfigParser.parse(deploymentConfPath, ContainerConfig.class);
                }
                catch (IllegalStateException | ConfigParserException e) {
                    throw new CLIRuntimeException("Error while reading deployment configuration file: " + deploymentConfPath + ". The content is invalid.", e);
                }
                GatewayCmdUtils.writeContent(inputConfigContent, file);
            } else {
                throw new CLIRuntimeException("Error while reading deployment configuration file. Probably the file path '" + deploymentConfPath + "' is invalid.");
            }
        }
    }

    public static ContainerConfig getContainerConfig() {
        return containerConfig;
    }

    public static void setContainerConfig(ContainerConfig containerConfig) {
        GatewayCmdUtils.containerConfig = containerConfig;
    }

    public static void saveConfig(Config config, String configPath) {
        try {
            TOMLConfigParser.write(configPath, config);
        }
        catch (ConfigParserException e) {
            System.err.println("Error occurred while parsing configuration, when persisting.");
        }
    }

    public static APICorsConfigurationDTO getDefaultCorsConfig() {
        APICorsConfigurationDTO corsConfigurationDTO = new APICorsConfigurationDTO();
        corsConfigurationDTO.setCorsConfigurationEnabled(true);
        corsConfigurationDTO.setAccessControlAllowOrigins(GatewayCliConstants.accessControlAllowOrigins);
        corsConfigurationDTO.setAccessControlAllowMethods(GatewayCliConstants.accessControlAllowMethods);
        corsConfigurationDTO.setAccessControlAllowHeaders(GatewayCliConstants.accessControlAllowHeaders);
        corsConfigurationDTO.setAccessControlAllowCredentials(false);
        return corsConfigurationDTO;
    }

    public static String getUnixPath(String path) {
        return path.replace(File.separator, "/");
    }

    private static void saveScript(String content, File path) throws IOException {
        block13: {
            try (FileWriter writer = new FileWriter(path);){
                writer.write(content);
                boolean success = path.setExecutable(true);
                if (success) {
                    logger.trace("File: {} is set to executable. ", (Object)path.getAbsolutePath());
                    break block13;
                }
                logger.error("Failed to set executable file: {} ", (Object)path.getAbsolutePath());
                throw new CLIInternalException("Error occurred while setting up the workspace structure");
            }
        }
    }

    public static void deleteProject(String projectPath) {
        File file = new File(projectPath);
        try {
            GatewayCmdUtils.delete(file);
        }
        catch (IOException e) {
            logger.error("Failed to delete project : {} ", (Object)projectPath, (Object)e);
        }
    }

    private static void delete(File file) throws IOException {
        for (File childFile : file.listFiles()) {
            if (childFile.isDirectory()) {
                GatewayCmdUtils.delete(childFile);
                continue;
            }
            if (childFile.delete()) continue;
            throw new IOException();
        }
        if (!file.delete()) {
            throw new IOException();
        }
    }

    public static void writeMapToFile(Map<String, String> map, String filePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(filePath);
             ObjectOutputStream obs = new ObjectOutputStream(fos);){
            obs.writeObject(map);
        }
    }

    /*
     * Exception decompiling
     */
    public static Map<String, String> readFileToMap(String filePath) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String promptForTextInput(PrintStream outStream, String msg) {
        outStream.println(msg);
        return System.console().readLine();
    }

    public static void deletePerAPIFolder(String projectName, String apiId) {
        try {
            GatewayCmdUtils.delete(new File(GatewayCmdUtils.getProjectAPIFilesDirectoryPath(projectName) + File.separator + apiId));
        }
        catch (IOException e) {
            throw new CLIInternalException("Delete folder is failed : " + apiId);
        }
    }

    private static String readGatewayProjectFile(String filePath) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        String projectPath = reader.readLine();
        return projectPath;
    }

    public static String findCurrentProject() {
        String projectFile = GatewayCmdUtils.getCLIHome() + File.separator + ".PROJECT";
        String fileContent = null;
        try {
            fileContent = GatewayCmdUtils.readGatewayProjectFile(projectFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileContent != null && Files.isDirectory(Paths.get(fileContent, new String[0]), new LinkOption[0])) {
            return fileContent.trim();
        }
        return null;
    }

    public static String buildProjectName(String knownName) {
        String projectName = knownName;
        if (StringUtils.isEmpty((CharSequence)knownName)) {
            String workingProject = GatewayCmdUtils.findCurrentProject();
            if (StringUtils.isEmpty((CharSequence)workingProject)) {
                throw new CLIRuntimeException("Project name is not provided.");
            }
            projectName = workingProject;
            logger.debug("Working project was set from config: " + projectName);
        }
        return projectName;
    }

    private static void createGenDirectoryStructure(String genDirPath) {
        String genDefinitionsPath = genDirPath + File.separator + "api_definitions";
        GatewayCmdUtils.createFolderIfNotExist(genDefinitionsPath);
        String genSrcPath = genDirPath + File.separator + "src";
        GatewayCmdUtils.createFolderIfNotExist(genSrcPath);
        String genPoliciesPath = genSrcPath + File.separator + "policies";
        GatewayCmdUtils.createFolderIfNotExist(genPoliciesPath);
    }

    public static String getAPIMetadataFilePath(String projectName, String apiId) {
        return GatewayCmdUtils.getProjectAPIFilesDirectoryPath(projectName) + File.separator + apiId + File.separator + "api-metadata.yaml";
    }

    public static String getProjectAPIFilesDirectoryPath(String projectName) {
        return GatewayCmdUtils.getProjectDirectoryPath(projectName) + File.separator + "api_definitions";
    }

    public static void saveAPIMetadataFile(String projectName, String apiId, String apiMetadataYaml) {
        if (!apiMetadataYaml.isEmpty()) {
            try {
                GatewayCmdUtils.writeContent(apiMetadataYaml, new File(GatewayCmdUtils.getAPIMetadataFilePath(projectName, apiId)));
            }
            catch (IOException e) {
                throw new CLIInternalException("Error while copying api-metaData to the project directory");
            }
        }
    }

    public static String getProjectAppThrottlePoliciesFilePath(String projectName) {
        return GatewayCmdUtils.getProjectAPIFilesDirectoryPath(projectName) + File.separator + "application-throttle-policies.json";
    }

    public static String getProjectSubscriptionThrottlePoliciesFilePath(String projectName) {
        return GatewayCmdUtils.getProjectAPIFilesDirectoryPath(projectName) + File.separator + "subscription-throttle-policies.json";
    }

    public static String getProjectClientCertMetadataFilePath(String projectName) {
        return GatewayCmdUtils.getProjectAPIFilesDirectoryPath(projectName) + File.separator + "client-cert-metadata.json";
    }

    public static void createPerAPIFolderStructure(String projectName, String apiId) {
        String apiFilesDirPath = GatewayCmdUtils.getProjectAPIFilesDirectoryPath(projectName);
        String apiDirPath = apiFilesDirPath + File.separator + apiId;
        GatewayCmdUtils.createFolderIfNotExist(apiDirPath);
    }

    public static String getProjectSwaggerFilePath(String projectName, String apiId) {
        return GatewayCmdUtils.getProjectAPIFilesDirectoryPath(projectName) + File.separator + apiId + File.separator + "swagger.json";
    }

    public static void printVerbose(String msg) {
        if (verboseLogsEnabled) {
            System.out.println("micro-gw: [verbose] " + msg);
        }
    }

    private static Boolean setVerboseEnabled() {
        String value = System.getProperty("VERBOSE_ENABLED");
        if (value != null && (value.equals("T") || value.equalsIgnoreCase("true"))) {
            return true;
        }
        return false;
    }

    static {
        verboseLogsEnabled = GatewayCmdUtils.setVerboseEnabled();
    }
}

