/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.hashing.HashUtils;
import org.wso2.apimgt.gateway.cli.model.rest.APIEndpointSecurityDTO;
import org.wso2.apimgt.gateway.cli.model.rest.APIMetadataDTO;
import org.wso2.apimgt.gateway.cli.model.rest.ClientCertMetadataDTO;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyListDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyListDTO;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;

public class JsonProcessingUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectMapper objectMapper_yaml = new ObjectMapper((JsonFactory)new YAMLFactory());

    private static APIEndpointSecurityDTO parseEndpointSecurityDefinition(String endpointSecurityString) {
        APIEndpointSecurityDTO endpointSecurity = null;
        if (endpointSecurityString != null) {
            try {
                endpointSecurity = (APIEndpointSecurityDTO)objectMapper.readValue(endpointSecurityString, APIEndpointSecurityDTO.class);
            }
            catch (IOException e) {
                throw new CLIInternalException("Error: endpoint security string cannot be parsed ");
            }
        }
        return endpointSecurity;
    }

    public static void saveSubscriptionThrottlePolicies(String projectName, List<SubscriptionThrottlePolicyDTO> list) {
        SubscriptionThrottlePolicyListDTO policyList = new SubscriptionThrottlePolicyListDTO();
        policyList.setList(list);
        try {
            objectMapper.writeValue(new File(GatewayCmdUtils.getProjectSubscriptionThrottlePoliciesFilePath(projectName)), (Object)policyList);
        }
        catch (JsonProcessingException e) {
            throw new CLIInternalException("Error: Cannot parse the SubscriptionThrottlePolicies Object to json");
        }
        catch (IOException e) {
            throw new CLIInternalException("Error: cannot write to the file : subscription-throttle-policies.json");
        }
    }

    public static void saveApplicationThrottlePolicies(String projectName, List<ApplicationThrottlePolicyDTO> list) {
        ApplicationThrottlePolicyListDTO policyList = new ApplicationThrottlePolicyListDTO();
        policyList.setList(list);
        try {
            objectMapper.writeValue(new File(GatewayCmdUtils.getProjectAppThrottlePoliciesFilePath(projectName)), (Object)policyList);
        }
        catch (JsonProcessingException e) {
            throw new CLIInternalException("Error: Cannot parse the ApplicationThrottlePolicies Object to json");
        }
        catch (IOException e) {
            throw new CLIInternalException("Error: cannot write to the file : application-throttle-policies.json");
        }
    }

    public static void saveClientCertMetadata(String projectName, List<ClientCertMetadataDTO> metadataList) {
        try {
            objectMapper.writeValue(new File(GatewayCmdUtils.getProjectClientCertMetadataFilePath(projectName)), metadataList);
        }
        catch (JsonProcessingException e) {
            throw new CLIInternalException("Error: Cannot parse the ApplicationThrottlePolicies Object to json");
        }
        catch (IOException e) {
            throw new CLIInternalException("Error: cannot write to the file : client-cert-metadata.json");
        }
    }

    private static void saveAPIMetadata(String projectName, ExtendedAPI api, String security) {
        APIMetadataDTO metaData = new APIMetadataDTO();
        metaData.setCorsConfigurationDTO(api.getCorsConfiguration());
        metaData.setSecurity(security);
        String apiId = HashUtils.generateAPIId(api.getName(), api.getVersion());
        try {
            String yamlString = objectMapper_yaml.writeValueAsString((Object)metaData);
            GatewayCmdUtils.saveAPIMetadataFile(projectName, apiId, yamlString);
        }
        catch (JsonProcessingException e) {
            throw new CLIInternalException("Error while mapping metadata object to a yaml string");
        }
    }

    public static void saveAPIMetadataForMultipleAPIs(String projectName, List<ExtendedAPI> apis, String security) {
        for (ExtendedAPI api : apis) {
            JsonProcessingUtils.saveAPIMetadata(projectName, api, security);
        }
    }

    public static void saveAPIMetadata(String projectName, String apiId, String security) {
        APIMetadataDTO metaData = new APIMetadataDTO();
        metaData.setSecurity(security);
        try {
            String yamlString = objectMapper_yaml.writeValueAsString((Object)metaData);
            GatewayCmdUtils.saveAPIMetadataFile(projectName, apiId, yamlString);
        }
        catch (JsonProcessingException e) {
            throw new CLIInternalException("Error while mapping metadata object to a yaml string");
        }
    }

    static APIMetadataDTO getAPIMetadata(String projectName, String apiId) {
        try {
            return (APIMetadataDTO)objectMapper_yaml.readValue(new File(GatewayCmdUtils.getAPIMetadataFilePath(projectName, apiId)), APIMetadataDTO.class);
        }
        catch (IOException e) {
            throw new CLIRuntimeException("Error while parsing the API metadata file");
        }
    }

    public static String getProjectSubscriptionThrottlePoliciesFilePath(String projectName) {
        return JsonProcessingUtils.getProjectAPIFilesDirectoryPath(projectName) + File.separator + "subscription-throttle-policies.json";
    }

    public static String getProjectClientCertMetadataFilePath(String projectName) {
        return JsonProcessingUtils.getProjectAPIFilesDirectoryPath(projectName) + File.separator + "client-cert-metadata.json";
    }

    public static String getProjectRoutesConfFilePath(String projectName) {
        return JsonProcessingUtils.getProjectDirectoryPath(projectName) + File.separator + "definition.yaml";
    }

    public static String getProjectDirectoryPath(String projectName) {
        return new File(projectName).getAbsolutePath();
    }

    public static String getProjectAPIFilesDirectoryPath(String projectName) {
        return JsonProcessingUtils.getProjectDirectoryPath(projectName) + File.separator + "api_definitions";
    }

    public static void saveAPIMetadataFile(String projectName, String apiId, String apiMetadataYaml) {
        if (!apiMetadataYaml.isEmpty()) {
            try {
                JsonProcessingUtils.writeContent(apiMetadataYaml, new File(GatewayCmdUtils.getAPIMetadataFilePath(projectName, apiId)));
            }
            catch (IOException e) {
                throw new CLIInternalException("Error while copying api-metaData to the project directory");
            }
        }
    }

    private static void writeContent(String content, File file) throws IOException {
        FileWriter writer = null;
        writer = new FileWriter(file);
        writer.write(content);
        writer.flush();
    }
}

