/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.model.definition.DefinitionConfig;
import org.wso2.apimgt.gateway.cli.model.mgwcodegen.MgwEndpointConfigDTO;
import org.wso2.apimgt.gateway.cli.model.rest.APICorsConfigurationDTO;
import org.wso2.apimgt.gateway.cli.model.route.EndpointListRouteDTO;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.RouteUtils;
import org.wso2.apimgt.gateway.cli.utils.YamlValidator;

public class MgwDefinitionBuilder {
    private static DefinitionConfig definitionConfig;
    private static String projectName;
    private static final Logger LOGGER;
    private static Map<String, String> requestInterceptorMap;
    private static Map<String, String> responseInterceptorMap;

    public static void build(String project) {
        projectName = project;
        String definitionPath = GatewayCmdUtils.getProjectMgwDefinitionFilePath(project);
        File definitionFile = new File(definitionPath);
        try {
            InputStream isSchema = MgwDefinitionBuilder.class.getClassLoader().getResourceAsStream("definition-schema.json");
            definitionConfig = YamlValidator.parse(definitionFile, isSchema, DefinitionConfig.class);
        }
        catch (IOException e) {
            throw new CLIRuntimeException("Error while reading the definition.yaml.", e);
        }
        try {
            MgwDefinitionBuilder.setInterceptors();
        }
        catch (IOException e) {
            throw new CLIRuntimeException("Error while reading the 'interceptors' directory");
        }
    }

    public static String getBasePath(String apiName, String apiVersion) {
        String basePath = definitionConfig.getApis().getBasepathFromAPI(apiName, apiVersion);
        if (basePath == null) {
            throw new CLIRuntimeException("Error: The API '" + apiName + "' and version '" + apiVersion + "' is not found in the " + "definition.yaml" + ".");
        }
        return basePath;
    }

    public static EndpointListRouteDTO getProdEndpointList(String basePath) {
        return definitionConfig.getApis().getApiFromBasepath(basePath).getProdEpList();
    }

    public static EndpointListRouteDTO getSandEndpointList(String basePath) {
        return definitionConfig.getApis().getApiFromBasepath(basePath).getProdEpList();
    }

    public static String getSecurity(String basePath) {
        return definitionConfig.getApis().getApiFromBasepath(basePath).getSecurity();
    }

    public static APICorsConfigurationDTO getCorsConfiguration(String basePath) {
        return definitionConfig.getApis().getApiFromBasepath(basePath).getCorsConfiguration();
    }

    public static MgwEndpointConfigDTO getResourceEpConfigForCodegen(String basePath, String path, String operation) {
        if (!MgwDefinitionBuilder.isResourceAvailable(basePath, path, operation)) {
            return null;
        }
        EndpointListRouteDTO prodList = definitionConfig.getApis().getApiFromBasepath(basePath).getPathsDefinition().getMgwResource(path).getEndpointListDefinition(operation).getProdEndpointList();
        EndpointListRouteDTO sandList = definitionConfig.getApis().getApiFromBasepath(basePath).getPathsDefinition().getMgwResource(path).getEndpointListDefinition(operation).getSandEndpointList();
        return RouteUtils.convertToMgwServiceMap(prodList, sandList);
    }

    public static String getRequestInterceptor(String basePath, String path, String operation) {
        if (!MgwDefinitionBuilder.isResourceAvailable(basePath, path, operation)) {
            return null;
        }
        String interceptor = definitionConfig.getApis().getApiFromBasepath(basePath).getPathsDefinition().getMgwResource(path).getEndpointListDefinition(operation).getRequestInterceptor();
        MgwDefinitionBuilder.validateInterceptorAvailability(requestInterceptorMap, interceptor, basePath, path, operation);
        return interceptor;
    }

    public static String getResponseInterceptor(String basePath, String path, String operation) {
        if (!MgwDefinitionBuilder.isResourceAvailable(basePath, path, operation)) {
            return null;
        }
        String interceptor = definitionConfig.getApis().getApiFromBasepath(basePath).getPathsDefinition().getMgwResource(path).getEndpointListDefinition(operation).getResponseInterceptor();
        MgwDefinitionBuilder.validateInterceptorAvailability(responseInterceptorMap, interceptor, basePath, path, operation);
        return interceptor;
    }

    public static String getThrottlePolicy(String basePath, String path, String operation) {
        if (!MgwDefinitionBuilder.isResourceAvailable(basePath, path, operation)) {
            return null;
        }
        return definitionConfig.getApis().getApiFromBasepath(basePath).getPathsDefinition().getMgwResource(path).getEndpointListDefinition(operation).getThrottlePolicy();
    }

    private static boolean isResourceAvailable(String basePath, String path, String operation) {
        if (definitionConfig.getApis().getApiFromBasepath(basePath) == null) {
            return false;
        }
        if (definitionConfig.getApis().getApiFromBasepath(basePath).getPathsDefinition().getMgwResource(path) == null) {
            return false;
        }
        return definitionConfig.getApis().getApiFromBasepath(basePath).getPathsDefinition().getMgwResource(path).getEndpointListDefinition(operation) != null;
    }

    public static String getApiRequestInterceptor(String basePath) {
        String interceptor = definitionConfig.getApis().getApiFromBasepath(basePath).getRequestInterceptor();
        MgwDefinitionBuilder.validateInterceptorAvailability(requestInterceptorMap, interceptor, basePath, null, null);
        return interceptor;
    }

    public static String getApiResponseInterceptor(String basePath) {
        String interceptor = definitionConfig.getApis().getApiFromBasepath(basePath).getResponseInterceptor();
        MgwDefinitionBuilder.validateInterceptorAvailability(responseInterceptorMap, interceptor, basePath, null, null);
        return interceptor;
    }

    private static void validateInterceptorAvailability(Map<String, String> interceptorMap, String interceptorName, String basePath, String path, String operation) {
        if (interceptorName == null) {
            return;
        }
        if (!interceptorMap.containsKey(interceptorName)) {
            String errorMsg = "The interceptor '" + interceptorName + "' mentioned under basePath:'" + basePath + "' ";
            if (path != null && operation != null) {
                errorMsg = errorMsg + "path:'" + path + "' operation:'" + operation + "' ";
            }
            errorMsg = errorMsg + "is not available in the interceptors directory.";
            throw new CLIRuntimeException(errorMsg);
        }
    }

    public static void FindUnusedAPIInformation() {
        definitionConfig.getApis().getApisMap().forEach((k, v) -> {
            if (!v.getIsDefinitionUsed()) {
                String msg = "API '" + v.getTitle() + "' version: '" + v.getVersion() + "' is not used but added to the " + "definition.yaml" + ".";
                LOGGER.warn(msg);
                GatewayCmdUtils.printVerbose(msg);
            }
        });
    }

    private static void setInterceptors() throws IOException {
        String interceptorsDirectoryPath = GatewayCmdUtils.getProjectInterceptorsDirectoryPath(projectName);
        Files.walk(Paths.get(interceptorsDirectoryPath, new String[0]), new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith(".bal")).forEach(path -> {
            String balSrcCode = null;
            try {
                balSrcCode = GatewayCmdUtils.readFileAsString(path.toString(), false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            MgwDefinitionBuilder.findRequestInterceptors(balSrcCode, path.toString());
            MgwDefinitionBuilder.findResponseInterceptors(balSrcCode, path.toString());
        });
    }

    private static void findInterceptors(String balSrcCode, String interceptorFilePath, boolean isRequestInterceptor, Map<String, String> interceptorMap) {
        String matchedString;
        String functionParameter = isRequestInterceptor ? "http:Request" : "http:Response";
        String functionRegex = "function\\s+\\w+\\s*\\(\\s*http:Caller\\s+\\w+\\s*,\\s*" + functionParameter + "\\s+\\w+\\s*\\)";
        String commentFunctionRegex = "//( |\\S)*" + functionRegex;
        Pattern p = Pattern.compile(functionRegex);
        Matcher m = p.matcher(balSrcCode);
        ArrayList<String> functionStringArray = new ArrayList<String>();
        while (m.find()) {
            matchedString = m.group();
            functionStringArray.add(matchedString);
        }
        p = Pattern.compile(commentFunctionRegex);
        m = p.matcher(balSrcCode);
        while (m.find()) {
            matchedString = m.group();
            functionStringArray.stream().filter(matchedString::endsWith).findFirst().ifPresent(functionStringArray::remove);
        }
        functionStringArray.forEach(f -> {
            String functionName = f.split(" ")[1];
            if (interceptorMap.containsKey(functionName)) {
                throw new CLIRuntimeException("The function '" + functionName + "' is declared twice in the following files. Please remove one of the.\n" + (String)interceptorMap.get(functionName) + "\n" + interceptorFilePath);
            }
            interceptorMap.put(functionName, interceptorFilePath);
        });
    }

    private static void findRequestInterceptors(String balSrcCode, String interceptorFilePath) {
        MgwDefinitionBuilder.findInterceptors(balSrcCode, interceptorFilePath, true, requestInterceptorMap);
    }

    private static void findResponseInterceptors(String balSrcCode, String interceptorFilePath) {
        MgwDefinitionBuilder.findInterceptors(balSrcCode, interceptorFilePath, false, responseInterceptorMap);
    }

    static {
        LOGGER = LoggerFactory.getLogger(MgwDefinitionBuilder.class);
        requestInterceptorMap = new HashMap<String, String>();
        responseInterceptorMap = new HashMap<String, String>();
    }
}

