/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import io.swagger.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.hashing.HashUtils;
import org.wso2.apimgt.gateway.cli.model.mgwcodegen.MgwEndpointConfigDTO;
import org.wso2.apimgt.gateway.cli.model.rest.ResourceRepresentation;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.route.RouteEndpointConfig;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.MgwDefinitionBuilder;
import org.wso2.apimgt.gateway.cli.utils.RouteUtils;

public class OpenAPICodegenUtils {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(OpenAPICodegenUtils.class);
    private static final String openAPISpec2 = "2";
    private static final String openAPISpec3 = "3";

    public static String generateAPIdForSwagger(String apiDefPath) {
        OpenAPI openAPI = new OpenAPIV3Parser().read(apiDefPath);
        String apiName = openAPI.getInfo().getTitle();
        String apiVersion = openAPI.getInfo().getVersion();
        return HashUtils.generateAPIId(apiName, apiVersion);
    }

    private static JsonNode generateJsonNode(String apiDefinition, boolean isFilePath) {
        try {
            if (isFilePath) {
                return objectMapper.readTree(new File(apiDefinition));
            }
            return objectMapper.readTree(apiDefinition);
        }
        catch (IOException e) {
            throw new CLIRuntimeException("Api Definition cannot be parsed.");
        }
    }

    private static String findSwaggerVersion(String apiDefinition, boolean isFilePath) {
        JsonNode rootNode = OpenAPICodegenUtils.generateJsonNode(apiDefinition, isFilePath);
        if (rootNode.has("swagger") && rootNode.get("swagger").asText().trim().startsWith(openAPISpec2)) {
            return openAPISpec2;
        }
        if (rootNode.has("openapi") && rootNode.get("openapi").asText().trim().startsWith(openAPISpec3)) {
            return openAPISpec3;
        }
        throw new CLIRuntimeException("Error while reading the swagger file, check again.");
    }

    static String generateSwaggerString(ExtendedAPI api) {
        String swaggerVersion;
        switch (swaggerVersion = OpenAPICodegenUtils.findSwaggerVersion(api.getApiDefinition(), false)) {
            case "2": {
                Swagger swagger = new SwaggerParser().parse(api.getApiDefinition());
                swagger.setBasePath(api.getContext() + "/" + api.getVersion());
                return Json.pretty((Object)swagger);
            }
            case "3": {
                return api.getApiDefinition();
            }
        }
        throw new CLIRuntimeException("Error: Swagger version is not identified");
    }

    static String[] getAPINameVersionFromSwagger(String apiDefPath) {
        OpenAPI openAPI = new OpenAPIV3Parser().read(apiDefPath);
        return new String[]{openAPI.getInfo().getTitle(), openAPI.getInfo().getVersion()};
    }

    public static String getBasePathFromSwagger(String apiDefPath) {
        Swagger swagger;
        String swaggerVersion = OpenAPICodegenUtils.findSwaggerVersion(apiDefPath, true);
        if (swaggerVersion.equals(openAPISpec2) && !StringUtils.isEmpty((CharSequence)(swagger = new SwaggerParser().read(apiDefPath)).getBasePath())) {
            return swagger.getBasePath();
        }
        return null;
    }

    public static ExtendedAPI generateAPIFromOpenAPIDef(String apiDefPath) {
        String apiId = UUID.randomUUID().toString();
        ExtendedAPI api = new ExtendedAPI();
        OpenAPI openAPI = new OpenAPIV3Parser().read(apiDefPath);
        api.setId(apiId);
        api.setName(openAPI.getInfo().getTitle());
        api.setVersion(openAPI.getInfo().getVersion());
        api.setTransport(Arrays.asList("http", "https"));
        return api;
    }

    public static List<ResourceRepresentation> listResourcesFromSwaggerForAPI(String projectName, String apiId) {
        ArrayList<ResourceRepresentation> resourceList = new ArrayList<ResourceRepresentation>();
        JsonNode openApiNode = OpenAPICodegenUtils.generateJsonNode(GatewayCmdUtils.getProjectSwaggerFilePath(projectName, apiId), true);
        OpenAPICodegenUtils.addResourcesToListFromSwagger(openApiNode, resourceList);
        return resourceList;
    }

    private static void addResourcesToList(List<ResourceRepresentation> resourcesList, String apiName, String apiVersion, String resourceName, String method) {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setId(HashUtils.generateResourceId(apiName, apiVersion, resourceName, method));
        resource.setName(resourceName);
        resource.setMethod(method);
        resource.setApi(apiName);
        resource.setVersion(apiVersion);
        resourcesList.add(resource);
    }

    private static void addResourcesToListFromSwagger(JsonNode apiDefNode, List<ResourceRepresentation> resourcesList) {
        String apiName = apiDefNode.get("info").get("title").asText();
        String apiVersion = apiDefNode.get("info").get("version").asText();
        apiDefNode.get("paths").fields().forEachRemaining(e -> ((JsonNode)e.getValue()).fieldNames().forEachRemaining(operation -> OpenAPICodegenUtils.addResourcesToList(resourcesList, apiName, apiVersion, (String)e.getKey(), operation)));
    }

    public static List<ResourceRepresentation> getAllResources(String projectName) {
        ArrayList<ResourceRepresentation> resourcesList = new ArrayList<ResourceRepresentation>();
        String projectAPIFilesPath = GatewayCmdUtils.getProjectAPIFilesDirectoryPath(projectName);
        try {
            Files.walk(Paths.get(projectAPIFilesPath, new String[0]), new FileVisitOption[0]).filter(path -> path.getFileName().toString().equals("swagger.json")).forEach(path -> {
                JsonNode openApiNode = OpenAPICodegenUtils.generateJsonNode(path.toString(), true);
                OpenAPICodegenUtils.addResourcesToListFromSwagger(openApiNode, resourcesList);
            });
            return resourcesList;
        }
        catch (IOException e) {
            throw new CLIInternalException("Error while navigating API Files directory.");
        }
    }

    public static ResourceRepresentation getResource(String projectName, String resource_id) {
        String projectAPIFilesPath = GatewayCmdUtils.getProjectAPIFilesDirectoryPath(projectName);
        ResourceRepresentation resource = new ResourceRepresentation();
        try {
            Files.walk(Paths.get(projectAPIFilesPath, new String[0]), new FileVisitOption[0]).filter(path -> path.getFileName().toString().equals("swagger.json")).forEach(path -> {
                JsonNode openApiNode = OpenAPICodegenUtils.generateJsonNode(path.toString(), true);
                String apiName = openApiNode.get("info").get("title").asText();
                String apiVersion = openApiNode.get("info").get("version").asText();
                openApiNode.get("paths").fields().forEachRemaining(e -> ((JsonNode)e.getValue()).fieldNames().forEachRemaining(operation -> {
                    if (HashUtils.generateResourceId(apiName, apiVersion, (String)e.getKey(), operation).equals(resource_id)) {
                        resource.setId(resource_id);
                        resource.setName((String)e.getKey());
                        resource.setMethod((String)operation);
                        resource.setApi(apiName);
                        resource.setVersion(apiVersion);
                    }
                }));
            });
        }
        catch (IOException e) {
            throw new CLIInternalException("Error while navigating API Files directory.");
        }
        if (resource.getId() == null) {
            return null;
        }
        return resource;
    }

    public static String readJson(String filePath) {
        String responseStr;
        try {
            responseStr = new String(Files.readAllBytes(Paths.get(filePath, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("Error while reading api definition.", (Throwable)e);
            throw new CLIInternalException("Error while reading api definition.");
        }
        return responseStr;
    }

    public static void setAdditionalConfigsDevFirst(ExtendedAPI api) {
        String basePath = MgwDefinitionBuilder.getBasePath(api.getName(), api.getVersion());
        MgwEndpointConfigDTO mgwEndpointConfigDTO = RouteUtils.convertToMgwServiceMap(MgwDefinitionBuilder.getProdEndpointList(basePath), MgwDefinitionBuilder.getSandEndpointList(basePath));
        api.setEndpointConfigRepresentation(mgwEndpointConfigDTO);
        api.setSpecificBasepath(basePath);
        String security = MgwDefinitionBuilder.getSecurity(basePath);
        if (security == null) {
            security = "oauth2";
        }
        api.setApiSecurity(security);
        api.setCorsConfiguration(MgwDefinitionBuilder.getCorsConfiguration(basePath));
    }

    public static void setAdditionalConfig(ExtendedAPI api) {
        RouteEndpointConfig endpointConfig = RouteUtils.parseEndpointConfig(api.getEndpointConfig(), api.getEndpointSecurity());
        api.setEndpointConfigRepresentation(RouteUtils.convertToMgwServiceMap(endpointConfig.getProdEndpointList(), endpointConfig.getSandboxEndpointList()));
        if (api.getIsDefaultVersion().booleanValue()) {
            api.setSpecificBasepath(api.getContext());
        } else {
            api.setSpecificBasepath(api.getContext() + "/" + api.getVersion());
        }
    }
}

