/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.hashing.HashUtils;
import org.wso2.apimgt.gateway.cli.model.mgwcodegen.MgwEndpointConfigDTO;
import org.wso2.apimgt.gateway.cli.model.mgwcodegen.MgwEndpointDTO;
import org.wso2.apimgt.gateway.cli.model.mgwcodegen.MgwEndpointListDTO;
import org.wso2.apimgt.gateway.cli.model.rest.APIEndpointSecurityDTO;
import org.wso2.apimgt.gateway.cli.model.rest.EndpointUrlTypeEnum;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.route.APIRouteEndpointConfig;
import org.wso2.apimgt.gateway.cli.model.route.EndpointListRouteDTO;
import org.wso2.apimgt.gateway.cli.model.route.EndpointType;
import org.wso2.apimgt.gateway.cli.model.route.RouteEndpointConfig;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.OpenAPICodegenUtils;

public class RouteUtils {
    private static final ObjectMapper OBJECT_MAPPER_YAML = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final ObjectMapper OBJECT_MAPPER_JSON = new ObjectMapper();
    private static final String BASE_PATHS = "basePaths";
    private static final String GLOBAL_ENDPOINTS = "globalEndpoints";
    private static final String RESOURCES = "resources";
    private static final String GLOBAL_FUNCTION = "resources";
    private static JsonNode routesConfig;
    private static String routesConfigPath;
    public static final String IN = "in";
    public static final String OUT = "out";
    public static final String FUNCTION_IN = "functionIn";
    public static final String FUNCTION_OUT = "functionOut";

    public static void saveGlobalEpAndBasepath(String apiDefPath, String basePath, String endpointConfigJson) {
        String apiId = OpenAPICodegenUtils.generateAPIdForSwagger(apiDefPath);
        String[] apiNameAndVersion = OpenAPICodegenUtils.getAPINameVersionFromSwagger(apiDefPath);
        String apiName = apiNameAndVersion[0];
        String apiVersion = apiNameAndVersion[1];
        JsonNode routesConfig = RouteUtils.getRoutesConfig();
        RouteUtils.addBasePath(routesConfig, apiId, basePath);
        RouteUtils.addGlobalEndpoint(routesConfig, apiName, apiVersion, apiId, endpointConfigJson);
        RouteUtils.writeRoutesConfig(routesConfig);
    }

    public static void saveGlobalEpAndBasepath(List<ExtendedAPI> apiList, boolean isForceFully) {
        JsonNode routesConfig = RouteUtils.getRoutesConfig();
        for (ExtendedAPI api : apiList) {
            String apiId = HashUtils.generateAPIId(api.getName(), api.getVersion());
            if (RouteUtils.hasApiInRoutesConfig(apiId) && !isForceFully) {
                throw GatewayCmdUtils.createUsageException("The provided API id '" + apiId + "' already has an endpointConfiguration. use -f or --force to forcefully update the endpointConfiguration");
            }
            APIRouteEndpointConfig apiEpConfig = new APIRouteEndpointConfig();
            apiEpConfig.setApiName(api.getName());
            apiEpConfig.setApiVersion(api.getVersion());
            RouteEndpointConfig endpointConfig = RouteUtils.parseEndpointConfig(api.getEndpointConfig(), api.getEndpointSecurity());
            apiEpConfig.setProdEndpointList(endpointConfig.getProdEndpointList());
            apiEpConfig.setSandboxEndpointList(endpointConfig.getSandboxEndpointList());
            RouteUtils.addBasePath(routesConfig, api);
            RouteUtils.addAPIRouteEndpointConfigAsGlobalEp(routesConfig, apiId, apiEpConfig);
        }
        RouteUtils.writeRoutesConfig(routesConfig);
    }

    private static void addBasePath(JsonNode rootNode, String apiId, String basePath) {
        JsonNode basePathsNode = rootNode.get(BASE_PATHS);
        String modifiedBasePath = basePath.startsWith("/") ? basePath : "/" + basePath;
        RouteUtils.validateBasePath(basePathsNode, modifiedBasePath);
        ArrayNode arrayNode = ((ObjectNode)basePathsNode).putArray(apiId);
        arrayNode.add(modifiedBasePath);
    }

    private static void addBasePath(JsonNode rootNode, ExtendedAPI api) {
        JsonNode basePathsNode = rootNode.get(BASE_PATHS);
        String apiId = HashUtils.generateAPIId(api.getName(), api.getVersion());
        String basePath = api.getContext() + "/" + api.getVersion();
        RouteUtils.validateBasePath(basePathsNode, basePath);
        ArrayNode arrayNode = ((ObjectNode)basePathsNode).putArray(apiId);
        arrayNode.add(basePath);
        if (api.getIsDefaultVersion().booleanValue()) {
            RouteUtils.validateBasePath(basePathsNode, api.getContext());
            arrayNode.add(api.getContext());
        }
    }

    private static void validateBasePath(JsonNode basePathsNode, String basePath) {
        AtomicBoolean isAvailable = new AtomicBoolean(true);
        basePathsNode.fields().forEachRemaining(api -> {
            for (JsonNode basePathEntry : (JsonNode)api.getValue()) {
                if (!basePathEntry.asText().equals(basePath)) continue;
                isAvailable.set(false);
            }
        });
        if (!isAvailable.get()) {
            throw new CLIRuntimeException("Error: The provided basePath: \"" + basePath + "\" is already used. Try another basePath");
        }
    }

    private static void addGlobalEndpoint(JsonNode rootNode, String apiName, String apiVersion, String apiId, String endpointConfigJson) {
        RouteEndpointConfig endpointConfig = RouteUtils.parseEndpointConfig(endpointConfigJson);
        APIRouteEndpointConfig apiEpConfig = new APIRouteEndpointConfig();
        apiEpConfig.setApiName(apiName);
        apiEpConfig.setApiVersion(apiVersion);
        apiEpConfig.setProdEndpointList(endpointConfig.getProdEndpointList());
        apiEpConfig.setSandboxEndpointList(endpointConfig.getSandboxEndpointList());
        RouteUtils.addAPIRouteEndpointConfigAsGlobalEp(rootNode, apiId, apiEpConfig);
    }

    private static void addAPIRouteEndpointConfigAsGlobalEp(JsonNode rootNode, String apiId, APIRouteEndpointConfig apiEpConfig) {
        JsonNode globalEpsNode = rootNode.get(GLOBAL_ENDPOINTS);
        ((ObjectNode)globalEpsNode).set(apiId, OBJECT_MAPPER_YAML.valueToTree((Object)apiEpConfig));
    }

    private static void writeRoutesConfig(JsonNode routesConfig) {
        try {
            OBJECT_MAPPER_YAML.writeValue(new File(routesConfigPath), (Object)routesConfig);
            RouteUtils.routesConfig = routesConfig;
        }
        catch (IOException e) {
            throw new CLIInternalException("Error while writing to the routes.yaml");
        }
    }

    private static JsonNode getRoutesConfig() {
        try {
            routesConfig = OBJECT_MAPPER_YAML.readTree(new File(routesConfigPath));
        }
        catch (IOException e) {
            throw new CLIInternalException("Error while reading the routesConfiguration in path : " + routesConfigPath);
        }
        if (routesConfig == null) {
            routesConfig = OBJECT_MAPPER_YAML.createObjectNode();
        }
        JsonNode basePathsNode = null;
        ObjectNode globalEpsNode = null;
        ObjectNode resourcesNode = null;
        ObjectNode globalFunctionNode = null;
        if (!routesConfig.isNull()) {
            basePathsNode = routesConfig.get(BASE_PATHS);
            globalEpsNode = routesConfig.get(GLOBAL_ENDPOINTS);
            resourcesNode = routesConfig.get("resources");
            globalFunctionNode = routesConfig.get("resources");
        }
        if (basePathsNode == null) {
            basePathsNode = OBJECT_MAPPER_YAML.createObjectNode();
            ((ObjectNode)routesConfig).set(BASE_PATHS, basePathsNode);
        }
        if (globalEpsNode == null) {
            globalEpsNode = OBJECT_MAPPER_YAML.createObjectNode();
            ((ObjectNode)routesConfig).set(GLOBAL_ENDPOINTS, (JsonNode)globalEpsNode);
        }
        if (resourcesNode == null) {
            resourcesNode = OBJECT_MAPPER_YAML.createObjectNode();
            ((ObjectNode)routesConfig).set("resources", (JsonNode)resourcesNode);
        }
        if (globalFunctionNode == null) {
            globalFunctionNode = OBJECT_MAPPER_YAML.createObjectNode();
            ((ObjectNode)routesConfig).set("resources", (JsonNode)globalFunctionNode);
        }
        return routesConfig;
    }

    public static String[] getBasePath(String apiId) {
        JsonNode rootNode = RouteUtils.getRoutesConfig();
        ArrayNode arrayNode = (ArrayNode)rootNode.get(BASE_PATHS).get(apiId);
        if (arrayNode.size() == 2) {
            return new String[]{arrayNode.get(0).asText(), arrayNode.get(1).asText()};
        }
        return new String[]{arrayNode.get(0).asText()};
    }

    static APIRouteEndpointConfig getGlobalEpConfig(String apiId) {
        APIRouteEndpointConfig apiRouteEndpointConfig;
        JsonNode rootNode = RouteUtils.getRoutesConfig();
        JsonNode globalEpConfig = rootNode.get(GLOBAL_ENDPOINTS).get(apiId);
        if (globalEpConfig == null) {
            return null;
        }
        try {
            apiRouteEndpointConfig = (APIRouteEndpointConfig)OBJECT_MAPPER_YAML.readValue(globalEpConfig.toString(), APIRouteEndpointConfig.class);
        }
        catch (IOException e) {
            throw new CLIInternalException("Error while mapping Global Endpoint JsonNode object to APIRouteEndpointConfig object");
        }
        return apiRouteEndpointConfig;
    }

    public static RouteEndpointConfig parseEndpointConfig(String endpointConfigJson, APIEndpointSecurityDTO endpointSecurity) {
        JsonNode rootNode;
        RouteEndpointConfig endpointConfig = new RouteEndpointConfig();
        EndpointListRouteDTO prodEndpointConfig = new EndpointListRouteDTO();
        EndpointListRouteDTO sandEndpointConfig = new EndpointListRouteDTO();
        prodEndpointConfig.setSecurityConfig(endpointSecurity);
        sandEndpointConfig.setSecurityConfig(endpointSecurity);
        try {
            rootNode = OBJECT_MAPPER_JSON.readTree(endpointConfigJson);
        }
        catch (IOException e) {
            throw new CLIRuntimeException("Error while parsing the endpointConfig JSON string");
        }
        JsonNode endpointTypeNode = rootNode.get("endpoint_type");
        String endpointType = endpointTypeNode.asText();
        if ("http".equalsIgnoreCase(endpointType) || "failover".equalsIgnoreCase(endpointType)) {
            JsonNode sandEndpointNode;
            JsonNode prodEndpointNode = rootNode.get("production_endpoints");
            if (prodEndpointNode != null) {
                prodEndpointConfig.addEndpoint(prodEndpointNode.get("url").asText());
            }
            if ((sandEndpointNode = rootNode.get("sandbox_endpoints")) != null) {
                sandEndpointConfig.addEndpoint(sandEndpointNode.get("url").asText());
            }
            if ("failover".equalsIgnoreCase(endpointType)) {
                JsonNode sandFailoverEndpointNode;
                prodEndpointConfig.setType(EndpointType.failover);
                sandEndpointConfig.setType(EndpointType.failover);
                JsonNode prodFailoverEndpointNode = rootNode.withArray("production_failovers");
                if (prodFailoverEndpointNode != null) {
                    for (JsonNode node : prodFailoverEndpointNode) {
                        prodEndpointConfig.addEndpoint(node.get("url").asText());
                    }
                }
                if ((sandFailoverEndpointNode = rootNode.withArray("sandbox_failovers")) != null) {
                    for (JsonNode node : sandFailoverEndpointNode) {
                        sandEndpointConfig.addEndpoint(node.get("url").asText());
                    }
                }
            } else {
                prodEndpointConfig.setType(EndpointType.http);
                sandEndpointConfig.setType(EndpointType.http);
            }
        } else if ("load_balance".equalsIgnoreCase(endpointType)) {
            JsonNode sandboxEndpoints;
            prodEndpointConfig.setType(EndpointType.load_balance);
            sandEndpointConfig.setType(EndpointType.load_balance);
            JsonNode prodEndpoints = rootNode.withArray("production_endpoints");
            if (prodEndpoints != null) {
                for (JsonNode node : prodEndpoints) {
                    prodEndpointConfig.addEndpoint(node.get("url").asText());
                }
            }
            if ((sandboxEndpoints = rootNode.withArray("sandbox_endpoints")) != null) {
                for (JsonNode node : sandboxEndpoints) {
                    sandEndpointConfig.addEndpoint(node.get("url").asText());
                }
            }
        }
        if (prodEndpointConfig.getEndpoints() != null && prodEndpointConfig.getEndpoints().size() > 0) {
            endpointConfig.setProdEndpointList(prodEndpointConfig);
        }
        if (sandEndpointConfig.getEndpoints() != null && sandEndpointConfig.getEndpoints().size() > 0) {
            endpointConfig.setSandboxEndpointList(sandEndpointConfig);
        }
        return endpointConfig;
    }

    public static List<String[]> listApis() {
        JsonNode rootNode = RouteUtils.getRoutesConfig();
        JsonNode basePathsNode = rootNode.get(BASE_PATHS);
        Iterator fields = basePathsNode.fields();
        ArrayList<String[]> apis = new ArrayList<String[]>();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            String key = (String)field.getKey();
            for (JsonNode value : (JsonNode)field.getValue()) {
                String[] row = new String[]{key, rootNode.get(GLOBAL_ENDPOINTS).get(key).get("name").asText(), rootNode.get(GLOBAL_ENDPOINTS).get(key).get("version").asText(), value.asText()};
                apis.add(row);
            }
        }
        return apis;
    }

    public static void saveResourceRoute(String resourceId, String endpointConfigJson) {
        RouteEndpointConfig endpointConfig = RouteUtils.parseEndpointConfig(endpointConfigJson);
        JsonNode rootNode = RouteUtils.getRoutesConfig();
        JsonNode resourcesNode = rootNode.get("resources");
        ((ObjectNode)resourcesNode).set(resourceId, OBJECT_MAPPER_YAML.valueToTree((Object)endpointConfig));
        RouteUtils.writeRoutesConfig(rootNode);
    }

    private static RouteEndpointConfig parseEndpointConfig(String endpointConfigJson) {
        try {
            RouteEndpointConfig endpointConfig = endpointConfigJson.startsWith("{") ? (RouteEndpointConfig)OBJECT_MAPPER_JSON.readValue(endpointConfigJson, RouteEndpointConfig.class) : (RouteEndpointConfig)OBJECT_MAPPER_YAML.readValue(endpointConfigJson, RouteEndpointConfig.class);
            return endpointConfig;
        }
        catch (IOException e) {
            throw new CLIRuntimeException("Error while parsing the provided endpointConfig Json");
        }
    }

    static MgwEndpointConfigDTO convertToMgwServiceMap(EndpointListRouteDTO prodEpListDTO, EndpointListRouteDTO sandEpListDTO) {
        MgwEndpointConfigDTO endpointConfigDTO = new MgwEndpointConfigDTO();
        MgwEndpointListDTO prod = null;
        MgwEndpointListDTO sandbox = null;
        if (prodEpListDTO != null) {
            prod = new MgwEndpointListDTO();
            prod.setEndpointUrlType(EndpointUrlTypeEnum.PROD);
            prod.setType(prodEpListDTO.getType());
            ArrayList<MgwEndpointDTO> prodEpList = new ArrayList<MgwEndpointDTO>();
            for (String ep : prodEpListDTO.getEndpoints()) {
                prodEpList.add(new MgwEndpointDTO(ep));
            }
            prod.setEndpoints(prodEpList);
        }
        if (sandEpListDTO != null) {
            sandbox = new MgwEndpointListDTO();
            sandbox.setEndpointUrlType(EndpointUrlTypeEnum.SAND);
            sandbox.setType(sandEpListDTO.getType());
            ArrayList<MgwEndpointDTO> sandEpList = new ArrayList<MgwEndpointDTO>();
            for (String ep : sandEpListDTO.getEndpoints()) {
                sandEpList.add(new MgwEndpointDTO(ep));
            }
            sandbox.setEndpoints(sandEpList);
        }
        endpointConfigDTO.setProdEndpointList(prod);
        endpointConfigDTO.setSandboxEndpointList(sandbox);
        return endpointConfigDTO;
    }

    private static RouteEndpointConfig getResourceEpConfig(String apiName, String apiVersion, String resourceName, String method) {
        try {
            String resourceId = HashUtils.generateResourceId(apiName, apiVersion, resourceName, method);
            JsonNode resourceNode = RouteUtils.getResourceJsonNode(resourceId);
            if (resourceNode != null) {
                return (RouteEndpointConfig)OBJECT_MAPPER_YAML.readValue(resourceNode.toString(), RouteEndpointConfig.class);
            }
            return null;
        }
        catch (IOException e) {
            throw new CLIInternalException("RouteEndpointConfig for the given resource cannot be parsed");
        }
    }

    private static JsonNode getResourceJsonNode(String resourceId) {
        JsonNode rootNode = RouteUtils.getRoutesConfig();
        return rootNode.get("resources").get(resourceId);
    }

    public static boolean hasResourceInRoutesConfig(String resourceId) {
        return RouteUtils.getResourceJsonNode(resourceId) != null;
    }

    public static String getResourceAsYaml(String resourceId) {
        JsonNode resourceNode = RouteUtils.getResourceJsonNode(resourceId);
        if (resourceNode != null) {
            try {
                return OBJECT_MAPPER_YAML.writeValueAsString((Object)resourceNode);
            }
            catch (JsonProcessingException e) {
                throw new CLIInternalException("Resource node cannot be parsed to a yaml");
            }
        }
        return "No endpoints available";
    }

    public static void addFunction(String function, String type, String apiID) {
        APIRouteEndpointConfig api = RouteUtils.getGlobalEpConfig(apiID);
        if (type.equals(IN)) {
            api.setFunctionIn(function);
        } else if (type.equals(OUT)) {
            api.setFunctionOut(function);
        }
        JsonNode jn = RouteUtils.getRoutesConfig();
        RouteUtils.addAPIRouteEndpointConfigAsGlobalEp(jn, apiID, api);
        RouteUtils.writeRoutesConfig(jn);
    }

    public static void AddGlobalFunction(String function, String type) {
        JsonNode rootNode = RouteUtils.getRoutesConfig();
        JsonNode jsonNode = rootNode.get("resources");
        if (type.equals(IN)) {
            ((ObjectNode)jsonNode).put(FUNCTION_IN, function);
        }
        if (type.equals(OUT)) {
            ((ObjectNode)jsonNode).put(FUNCTION_OUT, function);
        }
        RouteUtils.writeRoutesConfig(rootNode);
    }

    public static void updateResourceRoute(String id, String endpointConfigJson) {
        if (RouteUtils.getResourceJsonNode(id) == null) {
            throw new CLIRuntimeException("Provided Resource ID is not available : " + id);
        }
        RouteUtils.saveResourceRoute(id, endpointConfigJson);
    }

    public static void updateAPIRoute(String apiId, String endpointConfigJson) {
        JsonNode rootNode = RouteUtils.getRoutesConfig();
        APIRouteEndpointConfig apiEpConfig = RouteUtils.getGlobalEpConfig(apiId);
        if (apiEpConfig == null) {
            throw new CLIRuntimeException("Provided API ID is not available : " + apiId);
        }
        RouteUtils.addGlobalEndpoint(rootNode, apiEpConfig.getApiName(), apiEpConfig.getApiVersion(), apiId, endpointConfigJson);
        RouteUtils.writeRoutesConfig(rootNode);
    }

    public static boolean hasApiInRoutesConfig(String apiId) {
        return null != RouteUtils.getGlobalEpConfig(apiId);
    }

    public static void setRoutesConfigPath(String routesConfigPath) {
        RouteUtils.routesConfigPath = routesConfigPath;
    }
}

