/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;
import org.wso2.apimgt.gateway.cli.utils.ZipUtils;

public class ToolkitLibExtractionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolkitLibExtractionUtils.class);

    public static void extractPlatformAndRuntime() {
        try {
            String libPath = GatewayCmdUtils.getCLILibPath();
            String baloPath = "gateway" + File.separator + "balo";
            String breLibPath = "bre" + File.separator + "lib";
            String runtimeExtractedPath = libPath + File.separator + "runtime";
            String platformExtractedPath = GatewayCmdUtils.getCLILibPath() + File.separator + "platform";
            ToolkitLibExtractionUtils.extractBallerinaDist(platformExtractedPath, libPath, baloPath, breLibPath, true);
            ToolkitLibExtractionUtils.extractBallerinaDist(runtimeExtractedPath, libPath, baloPath, breLibPath, false);
        }
        catch (IOException e) {
            String message = "Error while unzipping platform and runtime while project setup";
            LOGGER.error(message, (Throwable)e);
            throw new CLIInternalException(message);
        }
    }

    private static void extractBallerinaDist(String destination, String libPath, String baloPath, String breLibPath, Boolean isAddToClasspath) throws IOException {
        if (!Files.exists(Paths.get(destination, new String[0]), new LinkOption[0])) {
            ZipUtils.unzip(destination + ".zip", destination, isAddToClasspath);
            GatewayCmdUtils.copyFolder(libPath + File.separator + baloPath, destination + File.separator + "lib" + File.separator + "repo");
            GatewayCmdUtils.copyFolder(libPath + File.separator + "gateway" + File.separator + "platform", destination + File.separator + breLibPath);
        }
    }
}

