/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;

public class YamlValidator {
    private static final Logger logger = LoggerFactory.getLogger(YamlValidator.class);

    public static <T> T parse(File file, InputStream isSchema, Class<T> type) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode jsonNode = mapper.readTree(file);
        if (jsonNode == null) {
            throw new IOException("Input file is invalid or empty");
        }
        JSONObject rawSchema = new JSONObject(new JSONTokener(isSchema));
        Schema schema = SchemaLoader.load((JSONObject)rawSchema);
        logger.debug("Loaded json schema");
        try {
            schema.validate((Object)new JSONObject(jsonNode.toString()));
        }
        catch (ValidationException e) {
            YamlValidator.handleValidationException(e, file.getName());
        }
        return (T)mapper.readValue(file, type);
    }

    private static void handleValidationException(ValidationException ex, String fileName) {
        StringBuilder msgBuilder = new StringBuilder();
        List allMsg = ex.getAllMessages();
        for (String msg : allMsg) {
            msgBuilder.append('\n' + msg);
        }
        throw new CLIRuntimeException("Invalid file: " + fileName + '\n' + msgBuilder.toString(), 1);
    }
}

