/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLIZipException;

public class ZipUtils {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtils.class);
    private static final String ADD_URL = "addURL";

    public static void zip(String sourceDirPath, String zipFilePath) throws IOException {
        Path p = Files.createFile(Paths.get(zipFilePath, new String[0]), new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            Path pp = Paths.get(sourceDirPath, new String[0]);
            Files.walk(pp, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException e) {
                    throw new CLIZipException("Error while including file " + path + " to the zip", e);
                }
            });
        }
        catch (CLIZipException e) {
            throw new IOException("Error while creating a zip from " + sourceDirPath, e);
        }
    }

    public static void unzip(String zipFilePath, String unzipLocation, boolean isAddToClasspath) throws IOException {
        if (!Files.exists(Paths.get(unzipLocation, new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(unzipLocation, new String[0]), new FileAttribute[0]);
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                Path filePath = Paths.get(unzipLocation, entry.getName());
                if (!entry.isDirectory()) {
                    ZipUtils.unzipFiles(zipInputStream, filePath);
                    if (filePath.toString().contains(File.separator + "bin" + File.separator)) {
                        filePath.toFile().setExecutable(true, false);
                    }
                    if (isAddToClasspath && entry.getName().endsWith(".jar")) {
                        ZipUtils.addJarToClasspath(new File(filePath.toString()));
                    }
                } else {
                    Files.createDirectories(filePath, new FileAttribute[0]);
                }
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
        }
    }

    private static void unzipFiles(ZipInputStream zipInputStream, Path unzipFilePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(unzipFilePath.toAbsolutePath().toString()));){
            byte[] bytesIn = new byte[1024];
            int read = 0;
            while ((read = zipInputStream.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }

    private static void addJarToClasspath(File jar) {
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            Class<?> clazz = cl.getClass();
            Method method = clazz.getSuperclass().getDeclaredMethod(ADD_URL, URL.class);
            method.setAccessible(true);
            method.invoke((Object)cl, jar.toURI().toURL());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException e) {
            logger.error("Error while adding jar : " + jar.getName() + " to the class path", (Throwable)e);
        }
    }
}

