/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils.grpc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.ballerinalang.net.grpc.builder.BallerinaFileBuilder;
import org.ballerinalang.net.grpc.exception.BalGenerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen.BalFileGenerationUtils;
import org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen.BalGenToolException;
import org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen.BalGenerationConstants;
import org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen.DescriptorsGenerator;
import org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen.OSDetector;

public class GRPCUtils {
    private final String protoPath;
    private static PrintStream outStream = System.out;
    private static final Logger LOG = LoggerFactory.getLogger(GRPCUtils.class);
    private String balOutPath = "";
    private String exePath;
    private String protocVersion = "3.4.0";
    private String mode = "stub";

    public GRPCUtils(String protoPath) {
        this.protoPath = protoPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Set<byte[]> dependant;
        byte[] root;
        if (this.protoPath == null) {
            String errorMessage = "Invalid proto file path. Please provide valid proto file location.";
            outStream.println(errorMessage);
            throw new BalGenToolException(errorMessage);
        }
        if (!this.protoPath.toLowerCase(Locale.ENGLISH).endsWith(".proto")) {
            String errorMessage = "Invalid file type. Please provide valid proto type file.";
            outStream.println(errorMessage);
            throw new BalGenToolException(errorMessage);
        }
        if (!Files.isReadable(Paths.get(this.protoPath, new String[0]))) {
            String errorMessage = "Provided service proto file is not readable. Please input valid proto file location.";
            outStream.println(errorMessage);
            throw new BalGenToolException(errorMessage);
        }
        try {
            this.downloadProtocexe();
        }
        catch (BalGenToolException e) {
            LOG.error("Error while generating protoc executable. ", (Throwable)e);
            throw new BalGenToolException("Error while generating protoc executable. ", e);
        }
        File descFile = this.createTempDirectory();
        StringBuilder msg = new StringBuilder();
        outStream.println("Initializing the gateway proxy code generation.");
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            List<String> protoFiles = this.readProperties(classLoader);
            for (String file : protoFiles) {
                try {
                    GRPCUtils.exportResource(file, classLoader);
                }
                catch (BalGenerationException | BalGenToolException e) {
                    msg.append("Error extracting resource file ").append(file).append(BalGenerationConstants.NEW_LINE_CHARACTER);
                    outStream.println(msg.toString());
                    LOG.error("Error exacting resource file " + file, e);
                }
            }
            msg.append("Successfully generated initial files.").append(BalGenerationConstants.NEW_LINE_CHARACTER);
            root = BalFileGenerationUtils.getProtoByteArray(this.exePath, this.protoPath, descFile.getAbsolutePath());
            if (root.length == 0) {
                throw new BalGenerationException("Error occurred at generating proto descriptor.");
            }
            LOG.info("Successfully generated root descriptor.");
            dependant = DescriptorsGenerator.generateDependentDescriptor(this.exePath, new File(this.protoPath).getAbsolutePath(), descFile.getAbsolutePath());
            LOG.info("Successfully generated dependent descriptor.");
        }
        finally {
            BalFileGenerationUtils.delete(new File("desc_gen"));
            BalFileGenerationUtils.delete(new File("google"));
            LOG.debug("Successfully deleted temporary files.");
        }
        try {
            BallerinaFileBuilder ballerinaFileBuilder = "".equals(this.balOutPath) ? new BallerinaFileBuilder(root, dependant) : new BallerinaFileBuilder(root, dependant, this.balOutPath);
            ballerinaFileBuilder.build(this.mode);
        }
        catch (BalGenerationException e) {
            LOG.error("Error generating ballerina file.", (Throwable)e);
            msg.append("Error generating ballerina file.").append(BalGenerationConstants.NEW_LINE_CHARACTER);
            outStream.println(msg.toString());
        }
        msg.append("Successfully generated ballerina file.").append(BalGenerationConstants.NEW_LINE_CHARACTER);
        outStream.println(msg.toString());
    }

    private void downloadProtocexe() {
        if (this.exePath == null) {
            this.exePath = "protoc-" + OSDetector.getDetectedClassifier() + ".exe";
            File exeFile = new File(this.exePath);
            this.exePath = exeFile.getAbsolutePath();
            if (!exeFile.isFile()) {
                outStream.println("Downloading proc executor ...");
                try {
                    boolean newFile = exeFile.createNewFile();
                    if (newFile) {
                        LOG.info("Successfully created new protoc exe file" + this.exePath);
                    }
                }
                catch (IOException e) {
                    throw new BalGenToolException("Exception occurred while creating new file for protoc exe. ", e);
                }
                String url = "http://repo1.maven.org/maven2/com/google/protobuf/protoc/" + this.protocVersion + "/protoc-" + this.protocVersion + "-" + OSDetector.getDetectedClassifier() + ".exe";
                try {
                    BalFileGenerationUtils.saveFile(new URL(url), this.exePath);
                    File file = new File(this.exePath);
                    BalFileGenerationUtils.grantPermission(file);
                }
                catch (IOException e) {
                    throw new BalGenToolException("Exception occurred while writing protoc executable to file. ", e);
                }
                outStream.println("Download successfully completed!");
            } else {
                BalFileGenerationUtils.grantPermission(exeFile);
                outStream.println("Continue with existing protoc executor.");
            }
        } else {
            outStream.println("Pre-Downloaded descriptor detected ...");
        }
    }

    private static void exportResource(String resourceName, ClassLoader classLoader) {
        try (InputStream initialStream = classLoader.getResourceAsStream(resourceName);
             FileOutputStream resStreamOut = new FileOutputStream(resourceName.replace("stdlib", "protobuf"));){
            int readBytes;
            if (initialStream == null) {
                throw new BalGenToolException("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            while ((readBytes = initialStream.read(buffer)) > 0) {
                ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
            }
        }
        catch (IOException e) {
            throw new BalGenToolException("Cannot find '" + resourceName + "' resource  at the jar.", e);
        }
    }

    private File createTempDirectory() {
        File metadataHome = new File("desc_gen");
        if (!metadataHome.exists() && !metadataHome.mkdir()) {
            throw new IllegalStateException("Couldn't create dir: " + metadataHome);
        }
        File googleHome = new File("google");
        this.createTempDirectory(googleHome);
        File protobufHome = new File(googleHome, "protobuf");
        this.createTempDirectory(protobufHome);
        File compilerHome = new File(protobufHome, "compiler");
        this.createTempDirectory(compilerHome);
        return new File(metadataHome, this.getProtoFileName() + "-descriptor.desc");
    }

    private void createTempDirectory(File dirName) {
        if (!dirName.exists() && !dirName.mkdir()) {
            throw new IllegalStateException("Couldn't create dir: " + dirName);
        }
    }

    private String getProtoFileName() {
        File file = new File(this.protoPath);
        return file.getName().replace(".proto", "");
    }

    private List<String> readProperties(ClassLoader classLoader) {
        ArrayList<String> protoFilesList = new ArrayList<String>();
        try (InputStream initialStream = classLoader.getResourceAsStream("standardProtos.properties");
             BufferedReader reader = new BufferedReader(new InputStreamReader(initialStream, StandardCharsets.UTF_8));){
            String fileName;
            while ((fileName = reader.readLine()) != null) {
                protoFilesList.add(fileName);
            }
        }
        catch (IOException e) {
            throw new BalGenToolException("Error in reading standardProtos.properties.", e);
        }
        return protoFilesList;
    }

    public void setBalOutPath(String balOutPath) {
        this.balOutPath = balOutPath;
    }

    public void setExePath(String exePath) {
        this.exePath = exePath;
    }

    public void setProtocVersion(String protocVersion) {
        this.protocVersion = protocVersion;
    }

    public static String readApi(String filePath) {
        String responseStr;
        try {
            responseStr = new String(Files.readAllBytes(Paths.get(filePath, new String[0])), "UTF-8");
        }
        catch (IOException e) {
            LOG.error("Error while reading api definition.", (Throwable)e);
            throw new CLIInternalException("Error while reading api definition.");
        }
        return responseStr;
    }
}

