/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen;

import com.google.protobuf.DescriptorProtos;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen.BalGenToolException;
import org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen.BalGenerationConstants;
import org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen.ProtocCommandBuilder;

public class BalFileGenerationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BalFileGenerationUtils.class);

    public static void createMetaFolder(String folderPath) {
        boolean isFileCreated = new File(folderPath).getParentFile().mkdirs();
        if (!isFileCreated) {
            LOG.debug("Meta folder did not create successfully '" + folderPath + "'");
        }
        byte[] dataBytes = new byte[]{};
        try {
            Path file = Paths.get(folderPath, new String[0]);
            Files.write(file, dataBytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new BalGenToolException("Error creating .desc meta files.", e);
        }
    }

    public static void generateDescriptor(String command) {
        Process process;
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows");
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (isWindows) {
            builder.command("cmd.exe", "/c", command);
        } else {
            builder.command("sh", "-c", command);
        }
        builder.directory(new File(System.getProperty("user.home")));
        try {
            process = builder.start();
        }
        catch (IOException e) {
            throw new BalGenToolException("Error in executing protoc command '" + command + "'.", e);
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new BalGenToolException("Process not successfully completed. Process is interrupted while running the protoC executor.", e);
        }
        if (process.exitValue() != 0) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), "UTF-8"));
                Throwable throwable = null;
                try {
                    try {
                        String err;
                        StringBuilder errMsg = new StringBuilder();
                        while ((err = bufferedReader.readLine()) != null) {
                            errMsg.append(System.lineSeparator()).append(err);
                        }
                        throw new BalGenToolException(errMsg.toString());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (bufferedReader != null) {
                        if (throwable != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            bufferedReader.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new BalGenToolException("Invalid command syntax.", e);
            }
        }
    }

    public static String getDescriptorPath(String protoPath) {
        return BalGenerationConstants.META_DEPENDENCY_LOCATION + protoPath.substring(protoPath.lastIndexOf(BalGenerationConstants.FILE_SEPARATOR), protoPath.length()).replace(".proto", "") + ".desc";
    }

    public static String resolveProtoFloderPath(String protoPath) {
        int idx = protoPath.lastIndexOf(BalGenerationConstants.FILE_SEPARATOR);
        String protofolderPath = "";
        if (idx > 0) {
            protofolderPath = protoPath.substring(0, idx);
        }
        return protofolderPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getProtoByteArray(String exePath, String protoPath, String descriptorPath) {
        String command = new ProtocCommandBuilder(exePath, protoPath, BalFileGenerationUtils.resolveProtoFloderPath(protoPath), descriptorPath).build();
        BalFileGenerationUtils.generateDescriptor(command);
        File initialFile = new File(descriptorPath);
        try (FileInputStream targetStream = new FileInputStream(initialFile);){
            DescriptorProtos.FileDescriptorSet set = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)targetStream);
            if (set.getFileList().size() <= 0) return new byte[0];
            byte[] byArray = set.getFile(0).toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BalGenToolException("Error reading generated descriptor file '" + descriptorPath + "'.", e);
        }
    }

    public static void delete(File file) {
        if (file != null && file.exists() && file.isDirectory()) {
            String[] files = file.list();
            if (files != null && files.length != 0) {
                for (String temp : files) {
                    File fileDelete = new File(file, temp);
                    if (fileDelete.isDirectory()) {
                        BalFileGenerationUtils.delete(fileDelete);
                    }
                    if (!fileDelete.delete()) continue;
                    LOG.debug("Successfully deleted file " + file.toString());
                }
            }
            if (file.delete()) {
                LOG.debug("Successfully deleted file " + file.toString());
            }
            if (file.getParentFile() != null && file.getParentFile().delete()) {
                LOG.debug("Successfully deleted parent file " + file.toString());
            }
        } else if (file != null && file.delete()) {
            LOG.debug("Successfully deleted parent file " + file.toString());
        }
    }

    public static void saveFile(URL url, String file) {
        try (InputStream in = url.openStream();
             FileOutputStream fos = new FileOutputStream(new File(file));){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) > -1) {
                fos.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new BalGenToolException("Error saving file '" + file + "'.", e);
        }
    }

    public static void grantPermission(File file) {
        boolean isExecutable = file.setExecutable(true);
        boolean isReadable = file.setReadable(true);
        boolean isWritable = file.setWritable(true);
        if (isExecutable && isReadable && isWritable) {
            LOG.debug("Successfully grated permission for protoc exe file");
        } else {
            LOG.debug("Failed to prowide execute permission to protoc executor.");
        }
    }

    public static String resolveProtoFolderPath(String protoPath) {
        int idx = protoPath.lastIndexOf(BalGenerationConstants.FILE_SEPARATOR);
        String protoFolderPath = "";
        if (idx > 0) {
            protoFolderPath = protoPath.substring(0, idx);
        }
        return protoFolderPath;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows");
    }
}

