/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen;

import com.google.protobuf.DescriptorProtos;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.ballerinalang.net.grpc.exception.BalGenerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen.BalFileGenerationUtils;
import org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen.BalGenToolException;
import org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen.BalGenerationConstants;
import org.wso2.apimgt.gateway.cli.utils.grpc.GrpcGen.ProtocCommandBuilder;

public class DescriptorsGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DescriptorsGenerator.class);
    public static final String TMP_DIRECTORY_PATH = System.getProperty("java.io.tmpdir");
    private static final CharSequence EMPTY_STRING = "";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<byte[]> generateDependentDescriptor(String exePath, String rootProtoPath, String rootDescriptorPath) {
        HashSet<byte[]> dependentDescSet = new HashSet<byte[]>();
        File tempDir = new File(TMP_DIRECTORY_PATH);
        File initialFile = new File(rootDescriptorPath);
        try (FileInputStream targetStream = new FileInputStream(initialFile);){
            DescriptorProtos.FileDescriptorSet descSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)targetStream);
            for (String dependentFilePath : descSet.getFile(0).getDependencyList()) {
                String protoFolderPath;
                String protoPath;
                String relativeDescFilepath;
                File dependentDescFile;
                boolean isDirectoryCreated;
                if (BalFileGenerationUtils.isWindows()) {
                    dependentFilePath = dependentFilePath.replaceAll("/", "\\\\");
                }
                if (!(isDirectoryCreated = (dependentDescFile = new File(tempDir, relativeDescFilepath = BalGenerationConstants.META_DEPENDENCY_LOCATION + dependentFilePath.substring(dependentFilePath.lastIndexOf(BalGenerationConstants.FILE_SEPARATOR), dependentFilePath.length()).replace(".proto", ".desc"))).getParentFile().mkdirs())) {
                    LOG.debug("Parent directories didn't create for the file '" + relativeDescFilepath);
                }
                if (!dependentFilePath.contains(BalGenerationConstants.GOOGLE_STANDARD_LIB)) {
                    protoPath = new File(BalFileGenerationUtils.resolveProtoFolderPath(rootProtoPath), dependentFilePath).getAbsolutePath();
                    protoFolderPath = BalFileGenerationUtils.resolveProtoFolderPath(rootProtoPath);
                } else {
                    protoPath = new File(tempDir, dependentFilePath).getAbsolutePath();
                    protoFolderPath = tempDir.getAbsolutePath();
                }
                String command = new ProtocCommandBuilder(exePath, protoPath, protoFolderPath, dependentDescFile.getAbsolutePath()).build();
                BalFileGenerationUtils.generateDescriptor(command);
                File childFile = new File(tempDir, relativeDescFilepath);
                try {
                    FileInputStream childStream = new FileInputStream(childFile);
                    Throwable throwable = null;
                    try {
                        byte[] dependentDesc;
                        DescriptorProtos.FileDescriptorSet childDescSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)childStream);
                        if (childDescSet.getFile(0).getDependencyCount() != 0) {
                            Set<byte[]> childList = DescriptorsGenerator.generateDependentDescriptor(exePath, rootProtoPath, childFile.getAbsolutePath());
                            dependentDescSet.addAll(childList);
                        }
                        if ((dependentDesc = childDescSet.getFile(0).toByteArray()).length == 0) {
                            throw new BalGenerationException("Error occurred at generating dependent proto descriptor for dependent proto '" + relativeDescFilepath + "'.");
                        }
                        dependentDescSet.add(dependentDesc);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (childStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)childStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)childStream).close();
                    }
                }
                catch (IOException e) {
                    throw new BalGenToolException("Error extracting dependent bal.", e);
                    return dependentDescSet;
                }
            }
        }
        catch (IOException e) {
            throw new BalGenToolException("Error parsing descriptor file " + initialFile, e);
        }
    }
}

