/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.util.RefUtils;
import io.swagger.v3.parser.util.SchemaTypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverFully {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolverFully.class);
    private boolean aggregateCombinators;
    private Map<String, Schema> schemas;
    private Map<String, Schema> resolvedModels = new HashMap<String, Schema>();
    private Map<String, Example> examples;
    private Map<String, Parameter> parameters;
    private Map<String, RequestBody> requestBodies;
    private Map<String, Header> headers;
    private Map<String, Link> links;
    private Map<String, Schema> resolvedProperties = new IdentityHashMap<String, Schema>();

    public ResolverFully() {
        this(true);
    }

    public ResolverFully(boolean aggregateCombinators) {
        this.aggregateCombinators = aggregateCombinators;
    }

    public void resolveFully(OpenAPI openAPI) {
        Paths paths;
        Components components = openAPI.getComponents();
        if (components != null && components.getRequestBodies() != null) {
            this.requestBodies = components.getRequestBodies();
            if (this.requestBodies == null) {
                this.requestBodies = new HashMap<String, RequestBody>();
            }
        }
        if (components != null && components.getSchemas() != null) {
            this.schemas = components.getSchemas();
            if (this.schemas == null) {
                this.schemas = new HashMap<String, Schema>();
            }
        }
        if (components != null && components.getExamples() != null) {
            this.examples = components.getExamples();
            if (this.examples == null) {
                this.examples = new HashMap<String, Example>();
            }
        }
        if (components != null && components.getHeaders() != null) {
            this.headers = components.getHeaders();
            if (this.headers == null) {
                this.headers = new HashMap<String, Header>();
            }
        }
        if (components != null && components.getParameters() != null) {
            this.parameters = components.getParameters();
            if (this.parameters == null) {
                this.parameters = new HashMap<String, Parameter>();
            }
        }
        if (components != null && components.getLinks() != null) {
            this.links = components.getLinks();
            if (this.links == null) {
                this.links = new HashMap<String, Link>();
            }
        }
        if ((paths = openAPI.getPaths()) != null) {
            for (String pathname : paths.keySet()) {
                PathItem pathItem = (PathItem)paths.get(pathname);
                this.resolvePath(pathItem);
            }
        }
    }

    public void resolvePath(PathItem pathItem) {
        for (Operation op : pathItem.readOperations()) {
            ApiResponses apiResponses;
            RequestBody refRequestBody;
            Content content;
            if (op.getParameters() != null) {
                for (Parameter parameter : op.getParameters()) {
                    Schema resolved;
                    Parameter parameter2;
                    Parameter parameter3 = parameter2 = parameter.get$ref() != null ? this.resolveParameter(parameter) : parameter;
                    if (parameter2.getSchema() != null && (resolved = this.resolveSchema(parameter2.getSchema())) != null) {
                        parameter2.setSchema(resolved);
                    }
                    if (parameter2.getContent() == null) continue;
                    content = parameter2.getContent();
                    for (Object key : content.keySet()) {
                        Schema resolvedSchema;
                        if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolvedSchema = this.resolveSchema(((MediaType)content.get(key)).getSchema())) == null) continue;
                        ((MediaType)content.get(key)).setSchema(resolvedSchema);
                    }
                }
            }
            if (op.getCallbacks() != null) {
                Map<String, Callback> callbacks = op.getCallbacks();
                for (String name : callbacks.keySet()) {
                    Object key;
                    Callback callback = callbacks.get(name);
                    if (callback == null) continue;
                    key = callback.keySet().iterator();
                    while (key.hasNext()) {
                        String callbackName = (String)key.next();
                        PathItem path = (PathItem)callback.get(callbackName);
                        if (path == null) continue;
                        this.resolvePath(path);
                    }
                }
            }
            if ((refRequestBody = op.getRequestBody()) != null) {
                RequestBody requestBody = refRequestBody.get$ref() != null ? this.resolveRequestBody(refRequestBody) : refRequestBody;
                op.setRequestBody(requestBody);
                if (requestBody.getContent() != null) {
                    content = requestBody.getContent();
                    for (Object key : content.keySet()) {
                        Schema resolved;
                        if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolved = this.resolveSchema(((MediaType)content.get(key)).getSchema())) == null) continue;
                        ((MediaType)content.get(key)).setSchema(resolved);
                    }
                }
            }
            if ((apiResponses = op.getResponses()) == null) continue;
            for (String code : apiResponses.keySet()) {
                ApiResponse response = (ApiResponse)apiResponses.get(code);
                if (response.getContent() != null) {
                    Content content2 = response.getContent();
                    for (String string : content2.keySet()) {
                        Object resolved;
                        if (((MediaType)content2.get(string)).getSchema() != null) {
                            resolved = this.resolveSchema(((MediaType)content2.get(string)).getSchema());
                            ((MediaType)response.getContent().get(string)).setSchema((Schema)resolved);
                        }
                        if (((MediaType)content2.get(string)).getExamples() == null) continue;
                        resolved = this.resolveExample(((MediaType)content2.get(string)).getExamples());
                        ((MediaType)response.getContent().get(string)).setExamples((Map<String, Example>)resolved);
                    }
                }
                this.resolveHeaders(response.getHeaders());
                Map<String, Link> links = response.getLinks();
                if (links == null) continue;
                for (Map.Entry entry : links.entrySet()) {
                    Link value = (Link)entry.getValue();
                    Link resolvedValue = value.get$ref() != null ? this.resolveLink(value) : value;
                    entry.setValue(resolvedValue);
                }
            }
        }
    }

    private void resolveHeaders(Map<String, Header> headers) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Header> header : headers.entrySet()) {
            Header value = header.getValue();
            Header resolvedValue = value.get$ref() != null ? this.resolveHeader(value) : value;
            Map<String, Example> examples = resolvedValue.getExamples();
            if (examples != null) {
                Map<String, Example> resolved = this.resolveExample(examples);
                resolvedValue.setExamples(resolved);
            }
            header.setValue(resolvedValue);
        }
    }

    public Header resolveHeader(Header header) {
        RefFormat refFormat = RefUtils.computeRefFormat(header.get$ref());
        String $ref = header.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.headers != null && !this.headers.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.headers.getOrDefault(referenceKey, header);
        }
        return header;
    }

    public Link resolveLink(Link link) {
        RefFormat refFormat = RefUtils.computeRefFormat(link.get$ref());
        String $ref = link.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.links != null && !this.links.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            Link link1 = this.links.getOrDefault(referenceKey, link);
            if (link1 == null) {
                return null;
            }
            this.resolveHeaders(link1.getHeaders());
            return link1;
        }
        return link;
    }

    public RequestBody resolveRequestBody(RequestBody requestBody) {
        RefFormat refFormat = RefUtils.computeRefFormat(requestBody.get$ref());
        String $ref = requestBody.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.requestBodies != null && !this.requestBodies.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.requestBodies.getOrDefault(referenceKey, requestBody);
        }
        return requestBody;
    }

    public Parameter resolveParameter(Parameter parameter) {
        String $ref = parameter.get$ref();
        RefFormat refFormat = RefUtils.computeRefFormat($ref);
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.parameters != null && !this.parameters.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.parameters.getOrDefault(referenceKey, parameter);
        }
        return parameter;
    }

    public Schema resolveSchema(Schema schema) {
        if (schema.get$ref() != null) {
            String ref = schema.get$ref();
            Schema resolved = this.schemas.get(ref = ref.substring(ref.lastIndexOf("/") + 1));
            if (resolved != null) {
                if (this.resolvedModels.containsKey(ref)) {
                    LOGGER.debug("avoiding infinite loop");
                    return this.resolvedModels.get(ref);
                }
                this.resolvedModels.put(ref, schema);
                Schema model = this.resolveSchema(resolved);
                this.resolvedModels.put(ref, model);
                return model;
            }
            return schema;
        }
        if (schema instanceof ArraySchema) {
            ArraySchema arrayModel = (ArraySchema)schema;
            if (arrayModel.getItems().get$ref() != null) {
                arrayModel.setItems(this.resolveSchema(arrayModel.getItems()));
            } else {
                arrayModel.setItems(arrayModel.getItems());
            }
            return arrayModel;
        }
        if (schema instanceof ObjectSchema) {
            ObjectSchema obj = (ObjectSchema)schema;
            if (obj.getProperties() != null) {
                LinkedHashMap<String, Schema> updated = new LinkedHashMap<String, Schema>();
                for (String propertyName : obj.getProperties().keySet()) {
                    Schema innerProperty = obj.getProperties().get(propertyName);
                    if (schema == innerProperty) continue;
                    if (this.resolvedProperties.get(propertyName) == null || this.resolvedProperties.get(propertyName) != innerProperty) {
                        LOGGER.debug("avoiding infinite loop");
                        Schema resolved2 = this.resolveSchema(innerProperty);
                        updated.put(propertyName, resolved2);
                        this.resolvedProperties.put(propertyName, resolved2);
                        continue;
                    }
                    updated.put(propertyName, this.resolvedProperties.get(propertyName));
                }
                obj.setProperties(updated);
            }
            return obj;
        }
        if (schema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)schema;
            boolean adjacent = false;
            if (this.aggregateCombinators) {
                Object resolved;
                Object resolved2;
                ArrayList<Schema> list;
                Schema resolvedProp;
                Schema prop;
                Map<String, Schema> properties;
                Schema model = SchemaTypeUtil.createSchema(composedSchema.getType(), composedSchema.getFormat());
                HashSet<String> requiredProperties = new HashSet<String>();
                HashSet<Object> examples = new HashSet<Object>();
                if (composedSchema.getAllOf() != null && composedSchema.getAnyOf() != null && composedSchema.getOneOf() != null || composedSchema.getAllOf() != null && composedSchema.getAnyOf() != null || composedSchema.getAllOf() != null && composedSchema.getOneOf() != null || composedSchema.getOneOf() != null && composedSchema.getAnyOf() != null) {
                    adjacent = true;
                }
                if (composedSchema.getAllOf() != null) {
                    for (Schema innerModel : composedSchema.getAllOf()) {
                        Schema resolved22 = this.resolveSchema(innerModel);
                        properties = resolved22.getProperties();
                        if (resolved22.getProperties() != null) {
                            for (String string : properties.keySet()) {
                                prop = resolved22.getProperties().get(string);
                                if (this.resolvedProperties.get(string) == null || this.resolvedProperties.get(string) != prop) {
                                    LOGGER.debug("avoiding infinite loop");
                                    resolvedProp = this.resolveSchema(prop);
                                    model.addProperties(string, resolvedProp);
                                    this.resolvedProperties.put(string, resolvedProp);
                                    continue;
                                }
                                model.addProperties(string, this.resolvedProperties.get(string));
                            }
                            if (resolved22.getRequired() != null) {
                                for (int i = 0; i < resolved22.getRequired().size(); ++i) {
                                    if (resolved22.getRequired().get(i) == null) continue;
                                    requiredProperties.add(resolved22.getRequired().get(i).toString());
                                }
                            }
                        }
                        if (requiredProperties.size() > 0) {
                            model.setRequired(new ArrayList<String>(requiredProperties));
                        }
                        if (resolved22.getExample() != null) {
                            examples.add(resolved22.getExample());
                        }
                        if (composedSchema.getExtensions() == null) continue;
                        Map<String, Object> extensions = composedSchema.getExtensions();
                        for (String key3 : extensions.keySet()) {
                            model.addExtension(key3, composedSchema.getExtensions().get(key3));
                        }
                    }
                }
                if (composedSchema.getOneOf() != null) {
                    if (!adjacent) {
                        list = new ArrayList<Schema>();
                        for (Schema innerModel : composedSchema.getOneOf()) {
                            resolved2 = this.resolveSchema(innerModel);
                            list.add((Schema)resolved2);
                        }
                        composedSchema.setOneOf(list);
                        return composedSchema;
                    }
                    for (Schema innerModel : composedSchema.getOneOf()) {
                        resolved = this.resolveSchema(innerModel);
                        properties = ((Schema)resolved).getProperties();
                        if (((Schema)resolved).getProperties() != null) {
                            for (String string : properties.keySet()) {
                                prop = ((Schema)resolved).getProperties().get(string);
                                if (this.resolvedProperties.get(string) == null || this.resolvedProperties.get(string) != prop) {
                                    LOGGER.debug("avoiding infinite loop");
                                    resolvedProp = this.resolveSchema(prop);
                                    model.addProperties(string, resolvedProp);
                                    this.resolvedProperties.put(string, resolvedProp);
                                    continue;
                                }
                                model.addProperties(string, this.resolvedProperties.get(string));
                            }
                            if (((Schema)resolved).getRequired() != null) {
                                for (int i = 0; i < ((Schema)resolved).getRequired().size(); ++i) {
                                    if (((Schema)resolved).getRequired().get(i) == null) continue;
                                    requiredProperties.add(((Schema)resolved).getRequired().get(i).toString());
                                }
                            }
                        }
                        if (requiredProperties.size() > 0) {
                            model.setRequired(new ArrayList<String>(requiredProperties));
                        }
                        if (((Schema)resolved).getExample() != null) {
                            examples.add(((Schema)resolved).getExample());
                        }
                        if (composedSchema.getExtensions() == null) continue;
                        Map<String, Object> extensions = composedSchema.getExtensions();
                        for (String key : extensions.keySet()) {
                            model.addExtension(key, composedSchema.getExtensions().get(key));
                        }
                    }
                }
                if (composedSchema.getAnyOf() != null) {
                    if (!adjacent) {
                        list = new ArrayList();
                        for (Schema innerModel : composedSchema.getAnyOf()) {
                            resolved2 = this.resolveSchema(innerModel);
                            list.add((Schema)resolved2);
                        }
                        composedSchema.setAnyOf(list);
                        return composedSchema;
                    }
                    for (Schema innerModel : composedSchema.getAnyOf()) {
                        resolved = this.resolveSchema(innerModel);
                        properties = ((Schema)resolved).getProperties();
                        if (((Schema)resolved).getProperties() != null) {
                            for (String string : properties.keySet()) {
                                prop = ((Schema)resolved).getProperties().get(string);
                                if (this.resolvedProperties.get(string) == null || this.resolvedProperties.get(string) != prop) {
                                    LOGGER.debug("avoiding infinite loop");
                                    resolvedProp = this.resolveSchema(prop);
                                    model.addProperties(string, resolvedProp);
                                    this.resolvedProperties.put(string, resolvedProp);
                                    continue;
                                }
                                model.addProperties(string, this.resolvedProperties.get(string));
                            }
                            if (((Schema)resolved).getRequired() != null) {
                                for (int i = 0; i < ((Schema)resolved).getRequired().size(); ++i) {
                                    if (((Schema)resolved).getRequired().get(i) == null) continue;
                                    requiredProperties.add(((Schema)resolved).getRequired().get(i).toString());
                                }
                            }
                        }
                        if (requiredProperties.size() > 0) {
                            model.setRequired(new ArrayList<String>(requiredProperties));
                        }
                        if (((Schema)resolved).getExample() != null) {
                            examples.add(((Schema)resolved).getExample());
                        }
                        if (composedSchema.getExtensions() == null) continue;
                        Map<String, Object> extensions = composedSchema.getExtensions();
                        for (String key : extensions.keySet()) {
                            model.addExtension(key, composedSchema.getExtensions().get(key));
                        }
                    }
                }
                if (schema.getExample() != null) {
                    model.setExample(schema.getExample());
                } else if (!examples.isEmpty()) {
                    model.setExample(examples);
                }
                return model;
            }
            if (composedSchema.getAllOf() != null) {
                composedSchema.allOf(composedSchema.getAllOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
            }
            if (composedSchema.getOneOf() != null) {
                composedSchema.oneOf(composedSchema.getOneOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
            }
            if (composedSchema.getAnyOf() != null) {
                composedSchema.anyOf(composedSchema.getAnyOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
            }
            return composedSchema;
        }
        if (schema.getProperties() != null) {
            Schema property;
            Schema model = schema;
            LinkedHashMap<String, Schema> updated = new LinkedHashMap<String, Schema>();
            Map<String, Schema> properties = model.getProperties();
            for (String propertyName : properties.keySet()) {
                property = model.getProperties().get(propertyName);
                if (this.resolvedProperties.get(propertyName) == null || this.resolvedProperties.get(propertyName) != property) {
                    LOGGER.debug("avoiding infinite loop");
                    Schema resolved = this.resolveSchema(property);
                    updated.put(propertyName, resolved);
                    this.resolvedProperties.put(propertyName, resolved);
                    continue;
                }
                updated.put(propertyName, this.resolvedProperties.get(propertyName));
            }
            for (String key : updated.keySet()) {
                property = (Schema)updated.get(key);
                if (!(property instanceof ObjectSchema)) continue;
                ObjectSchema op = (ObjectSchema)property;
                if (op.getProperties() != model.getProperties()) {
                    if (property.getType() == null) {
                        property.setType("object");
                    }
                    model.addProperties(key, property);
                    continue;
                }
                LOGGER.debug("not adding recursive properties, using generic object");
                ObjectSchema newSchema = new ObjectSchema();
                model.addProperties(key, newSchema);
            }
            return model;
        }
        return schema;
    }

    public Map<String, Example> resolveExample(Map<String, Example> examples) {
        Map<String, Example> resolveExamples = examples;
        if (examples != null) {
            for (String name : examples.keySet()) {
                if (examples.get(name).get$ref() == null) continue;
                String ref = examples.get(name).get$ref();
                ref = ref.substring(ref.lastIndexOf("/") + 1);
                Example sample = this.examples.get(ref);
                resolveExamples.replace(name, sample);
            }
        }
        return resolveExamples;
    }
}

