/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.LauncherCmd;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;
import org.wso2.apimgt.gateway.cli.utils.ToolkitLibExtractionUtils;

@Parameters(commandNames={"init"}, commandDescription="initialize a new project")
public class InitCmd
implements LauncherCmd {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitCmd.class);
    private static final PrintStream OUT = System.out;
    @Parameter(description="project", required=true)
    private String projectName;
    @Parameter(names={"-f", "--force"}, description="replace existing projects having same name", arity=0)
    private boolean isForceful;
    @Parameter(names={"-d", "--deployment-config"}, description="deployment-config file for docker/k8s")
    private String deploymentConfigPath;
    @Parameter(names={"--help", "-h", "?"}, description="print command help", help=true)
    private boolean helpFlag;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    @Parameter(names={"-a", "--api-definition"})
    private String apiDefinition;
    @Parameter(names={"--headers"})
    private String headers;
    @Parameter(names={"--values"})
    private String values;
    @Parameter(names={"-k", "--insecure"})
    private boolean insecure;

    @Override
    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = this.getCommandUsageInfo("init");
            OUT.println(commandUsageInfo);
            return;
        }
        String workspace = CmdUtils.getUserDir();
        Path projectLocation = Paths.get(workspace + File.separator + this.projectName, new String[0]);
        boolean isDirectory = Files.isDirectory(projectLocation, new LinkOption[0]);
        if (isDirectory && !this.isForceful) {
            throw CmdUtils.createUsageException("Project name `" + this.projectName + "` already exist. use -f or --force to forcefully update the project directory.");
        }
        if (isDirectory) {
            CmdUtils.deleteProject(this.projectName);
        }
        ToolkitLibExtractionUtils.extractPlatformAndRuntime();
        InitCmd.init(this.projectName, this.deploymentConfigPath, this.apiDefinition, this.headers, this.values, this.insecure);
        OUT.println("Project '" + this.projectName + "' is initialized successfully.");
        OUT.println("\n(Use \"micro-gw build " + this.projectName + "\" after copying the api definitions)");
        OUT.println("(Use \"micro-gw import " + this.projectName + " [-l]|[-a -v]\" to import APIs from WSO2 API Manager)");
    }

    @Override
    public String getName() {
        return "init";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }

    private static void init(String projectName, String deploymentConfigPath, String apiDefinition, String headers, String values, boolean insecure) {
        try {
            CmdUtils.createProjectStructure(projectName, apiDefinition, headers, values, insecure);
            CmdUtils.createDeploymentConfig(projectName, deploymentConfigPath);
        }
        catch (IOException e) {
            LOGGER.error("Error occurred while generating project configurations", (Throwable)e);
            throw new CLIInternalException("Error occurred while loading configurations.");
        }
    }
}

