/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.codegen;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.constants.GeneratorConstants;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.model.config.CodeGen;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.template.BallerinaToml;
import org.wso2.apimgt.gateway.cli.model.template.GenSrcFile;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaOperation;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaPath;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaService;
import org.wso2.apimgt.gateway.cli.model.template.service.ListenerEndpoint;
import org.wso2.apimgt.gateway.cli.protobuf.ProtobufParser;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;
import org.wso2.apimgt.gateway.cli.utils.CodegenUtils;
import org.wso2.apimgt.gateway.cli.utils.OpenAPICodegenUtils;

public class CodeGenerator {
    private static final Logger logger = LoggerFactory.getLogger(CodeGenerator.class);
    public static String projectName;
    private boolean generateGlobalFaultResponses = false;
    private boolean addApiNotFoundService = true;

    public void generate(String projectName, boolean overwrite) throws IOException {
        CodeGen codeGenConfig;
        String projectSrcPath = CmdUtils.getProjectTargetModulePath(projectName);
        ArrayList<GenSrcFile> genFiles = new ArrayList<GenSrcFile>();
        ArrayList<BallerinaService> serviceList = new ArrayList<BallerinaService>();
        String grpcDirLocation = CmdUtils.getGrpcDefinitionsDirPath(projectName);
        CodeGenerator.projectName = projectName;
        BallerinaToml ballerinaToml = new BallerinaToml();
        ballerinaToml.setToolkitHome(CmdUtils.getCLIHome());
        ArrayList<String> openAPIDirectoryLocations = new ArrayList<String>();
        String importedApisPath = CmdUtils.getProjectGenAPIDefinitionPath(projectName);
        String devApisPath = CmdUtils.getProjectAPIFilesDirectoryPath(projectName);
        if (Files.exists(Paths.get(devApisPath, new String[0]), new LinkOption[0])) {
            openAPIDirectoryLocations.add(devApisPath);
        }
        if (Files.exists(Paths.get(importedApisPath, new String[0]), new LinkOption[0])) {
            openAPIDirectoryLocations.add(importedApisPath);
        }
        OpenAPICodegenUtils.setInterceptors(projectName);
        openAPIDirectoryLocations.forEach(openApiPath -> {
            try {
                Files.walk(Paths.get(openApiPath, new String[0]), new FileVisitOption[0]).filter(path -> {
                    Path fileName = path.getFileName();
                    return fileName != null && (fileName.toString().endsWith(".json") || fileName.toString().endsWith(".yaml"));
                }).forEach(path -> {
                    try {
                        String openAPIAsJson;
                        OpenAPI openAPI = new OpenAPIV3Parser().read(path.toString());
                        String openAPIContent = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                        String openAPIContentAsJson = openAPIAsJson = OpenAPICodegenUtils.getOpenAPIAsJson(openAPI, openAPIContent, path);
                        if (path.toString().endsWith(".yaml")) {
                            openAPIContentAsJson = OpenAPICodegenUtils.convertYamlToJson(openAPIContent);
                        }
                        String openAPIVersion = OpenAPICodegenUtils.findSwaggerVersion(openAPIContentAsJson, false);
                        OpenAPICodegenUtils.validateOpenAPIDefinition(openAPI, path.toString(), openAPIVersion);
                        OpenAPICodegenUtils.setOauthSecuritySchemaList(openAPI);
                        OpenAPICodegenUtils.setSecuritySchemaList(openAPI);
                        OpenAPICodegenUtils.setOpenAPIDefinitionEndpointReferenceExtensions(openAPI.getExtensions());
                        ExtendedAPI api = OpenAPICodegenUtils.generateAPIFromOpenAPIDef(openAPI, openAPIAsJson);
                        OpenAPICodegenUtils.setAdditionalConfigsDevFirst(api, openAPI, path.toString());
                        BallerinaService definitionContext = new BallerinaService().buildContext(openAPI, api);
                        this.generateResourceFunctions(definitionContext, genFiles);
                        genFiles.add(this.generateService(definitionContext));
                        serviceList.add(definitionContext);
                        ballerinaToml.addDependencies(definitionContext);
                        this.copySwaggerToResourcesFolder(api.getName(), api.getVersion(), (Path)path);
                    }
                    catch (BallerinaServiceGenException e) {
                        throw new CLIRuntimeException("Swagger definition cannot be parsed to ballerina code", e);
                    }
                    catch (IOException e) {
                        throw new CLIInternalException("File write operations failed during ballerina code generation", e);
                    }
                });
            }
            catch (IOException e) {
                throw new CLIInternalException("File write operations failed during ballerina code generation", e);
            }
        });
        if (Paths.get(grpcDirLocation, new String[0]).toFile().exists()) {
            Files.walk(Paths.get(grpcDirLocation, new String[0]), new FileVisitOption[0]).filter(path -> {
                Path filename = path.getFileName();
                return filename != null && filename.toString().endsWith(".proto");
            }).forEach(path -> {
                String descriptorPath = CmdUtils.getProtoDescriptorPath(projectName, path.getFileName().toString());
                try {
                    ArrayList<OpenAPI> openAPIs = new ProtobufParser().generateOpenAPI(path.toString(), descriptorPath);
                    if (openAPIs.size() > 0) {
                        for (OpenAPI openAPI : openAPIs) {
                            String openAPIContent = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                            OpenAPICodegenUtils.setOauthSecuritySchemaList(openAPI);
                            OpenAPICodegenUtils.setSecuritySchemaList(openAPI);
                            this.createProtoOpenAPIFile(projectName, openAPI);
                            BallerinaService definitionContext = this.generateDefinitionContext(openAPI, openAPIContent, (Path)path, true);
                            this.generateResourceFunctions(definitionContext, genFiles);
                            genFiles.add(this.generateService(definitionContext));
                            serviceList.add(definitionContext);
                            ballerinaToml.addDependencies(definitionContext);
                        }
                    }
                }
                catch (IOException e) {
                    throw new CLIRuntimeException("Protobuf file cannot be parsed to ballerina code", e);
                }
                catch (BallerinaServiceGenException e) {
                    throw new CLIInternalException("File write operations failed during the ballerina code generation for the protobuf files", e);
                }
            });
        }
        this.generateGlobalFaultResponses = (codeGenConfig = CmdUtils.getConfig().getCodeGen()) != null ? codeGenConfig.getGlobalFaultResponses() : false;
        this.addApiNotFoundService = this.addApiNotFoundService(serviceList);
        genFiles.add(this.generateFaultResponses());
        genFiles.add(this.generateMainBal(serviceList));
        genFiles.add(this.generateOpenAPIJsonConstantsBal(serviceList));
        genFiles.add(this.generateTokenServices());
        genFiles.add(this.generateHealthCheckService());
        genFiles.add(this.generateCommonEndpoints());
        if (this.generateGlobalFaultResponses && this.addApiNotFoundService) {
            genFiles.add(this.generateAPINotFoundService());
        }
        CodegenUtils.writeGeneratedSources(genFiles, Paths.get(projectSrcPath, new String[0]), overwrite);
        ballerinaToml.addLibs(projectName);
        GenSrcFile toml = this.generateBallerinaTOML(ballerinaToml);
        String tomlPath = CmdUtils.getProjectTargetGenDirectoryPath(projectName) + File.separator + "Ballerina.toml";
        CodegenUtils.writeFile(Paths.get(tomlPath, new String[0]), toml.getContent());
        CmdUtils.copyFolder(CmdUtils.getProjectExtensionsDirectoryPath(projectName), projectSrcPath);
    }

    private boolean addApiNotFoundService(List<BallerinaService> serviceList) {
        if (this.generateGlobalFaultResponses) {
            for (BallerinaService ballerinaService : serviceList) {
                if (!"/*".equals(ballerinaService.getBasepath())) continue;
                for (Map.Entry<String, BallerinaPath> entry : ballerinaService.getPaths()) {
                    if (!"/*".equals(entry.getKey())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private BallerinaService generateDefinitionContext(OpenAPI openAPI, String openAPIContent, Path path, boolean isGrpc) throws IOException, BallerinaServiceGenException {
        ExtendedAPI api = isGrpc ? OpenAPICodegenUtils.generateGrpcAPIFromOpenAPI(openAPI) : OpenAPICodegenUtils.generateAPIFromOpenAPIDef(openAPI, openAPIContent);
        OpenAPICodegenUtils.setAdditionalConfigsDevFirst(api, openAPI, path.toString());
        BallerinaService definitionContext = new BallerinaService().buildContext(openAPI, api);
        return definitionContext;
    }

    private void copySwaggerToResourcesFolder(String apiName, String apiVersion, Path openAPIFilePath) throws IOException {
        String resourcesPath = CmdUtils.getProjectTargetModulePath(projectName) + File.separator + "resources";
        String fileExtension = openAPIFilePath.getFileName().toString().endsWith(".yaml") ? ".yaml" : ".json";
        String destinationFilename = apiName + "_" + apiVersion + fileExtension;
        CmdUtils.copyFilesToSources(openAPIFilePath.toString(), resourcesPath + File.separator + destinationFilename);
    }

    private GenSrcFile generateService(BallerinaService context) throws IOException {
        String concatTitle = context.getQualifiedServiceName();
        String srcFile = concatTitle + ".bal";
        String mainContent = this.getContent(context, "service");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, mainContent);
    }

    private GenSrcFile generateMainBal(List<BallerinaService> services) throws IOException {
        String srcFile = "main.bal";
        String mainContent = this.getContent(services, "main");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, mainContent);
    }

    private void generateResourceFunctions(BallerinaService context, List<GenSrcFile> genFiles) throws IOException {
        for (Map.Entry<String, BallerinaPath> pathEntry : context.getPaths()) {
            for (Map.Entry<String, BallerinaOperation> operation : pathEntry.getValue().getOperations()) {
                String concatTitle = context.getQualifiedServiceName() + "_" + operation.getValue().getOperationId();
                String srcFile = concatTitle + "_" + "resourceFunction" + ".bal";
                String mainContent = this.getContentForResourceFunction(operation.getValue(), "resourceFunction", context, pathEntry.getValue());
                genFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, mainContent));
            }
        }
    }

    private GenSrcFile generateBallerinaTOML(BallerinaToml toml) throws IOException {
        String srcFile = "ballerinaToml.toml";
        String mainContent = this.getContent(toml, "ballerinaToml");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, mainContent);
    }

    private GenSrcFile generateOpenAPIJsonConstantsBal(List<BallerinaService> services) throws IOException {
        String srcFile = "openAPIJsonConstants.json";
        String mainContent = this.getContent(services, "openAPIJsonConstants");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, mainContent);
    }

    private GenSrcFile generateCommonEndpoints() throws IOException {
        String srcFile = "listeners.bal";
        ListenerEndpoint listenerEndpoint = new ListenerEndpoint().buildContext();
        String endpointContent = this.getContent(listenerEndpoint, "listeners");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, endpointContent);
    }

    private GenSrcFile generateTokenServices() throws IOException {
        String srcFile = "tokenServices.bal";
        String endpointContent = this.getContentForTokenService(CmdUtils.getConfig(), "tokenServices");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, endpointContent);
    }

    private GenSrcFile generateHealthCheckService() throws IOException {
        String srcFile = "healthCheck.bal";
        String endpointContent = this.getContent(CmdUtils.getConfig(), "healthCheck");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, endpointContent);
    }

    private GenSrcFile generateAPINotFoundService() throws IOException {
        String srcFile = "apiNotFoundService.bal";
        String endpointContent = this.getContent(CmdUtils.getConfig(), "apiNotFoundService");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, endpointContent);
    }

    private GenSrcFile generateFaultResponses() throws IOException {
        String srcFile = "faultResponses.bal";
        String endpointContent = this.getContent(CmdUtils.getConfig(), "faultResponses");
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, endpointContent);
    }

    private String getContentForResourceFunction(Object endpoints, String templateName, BallerinaService service, BallerinaPath path) throws IOException {
        Template template = CodegenUtils.compileTemplate(GeneratorConstants.DEFAULT_TEMPLATE_DIR, templateName);
        Context context = Context.newBuilder(endpoints).combine("service", service).combine("path", path).resolver(MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE).build();
        return template.apply(context);
    }

    private String getContentForTokenService(Object endpoints, String templateName) throws IOException {
        Template template = CodegenUtils.compileTemplate(GeneratorConstants.DEFAULT_TEMPLATE_DIR, templateName);
        Context context = Context.newBuilder(endpoints).combine("generateGlobalFaultResponses", this.generateGlobalFaultResponses && this.addApiNotFoundService).resolver(MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE).build();
        return template.apply(context);
    }

    private String getContent(Object endpoints, String templateName) throws IOException {
        Template template = CodegenUtils.compileTemplate(GeneratorConstants.DEFAULT_TEMPLATE_DIR, templateName);
        Context context = Context.newBuilder(endpoints).resolver(MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE).build();
        return template.apply(context);
    }

    public void generateGrpc(String projectName, String apiDef, boolean overwrite) throws IOException {
        String projectSrcPath = CmdUtils.getProjectGenSwaggerPath(projectName, "");
        String projectGrpcPath = CmdUtils.getProjectGrpcDirectoryPath();
        ArrayList<GenSrcFile> genFiles = new ArrayList<GenSrcFile>();
        File dir = new File(projectGrpcPath);
        genFiles.add(this.generateCommonEndpoints());
        CodegenUtils.writeGeneratedSources(genFiles, Paths.get(projectSrcPath, new String[0]), overwrite);
        CmdUtils.copyFilesToSources(CmdUtils.getFiltersFolderLocation() + File.separator + "extension_filter.bal", projectSrcPath + File.separator + "extension_filter.bal");
        CmdUtils.copyFilesToSources(CmdUtils.getFiltersFolderLocation() + File.separator + "token_revocation_extension.bal", projectSrcPath + File.separator + "token_revocation_extension.bal");
        File[] fileList = dir.listFiles();
        if (fileList == null) {
            return;
        }
        for (File file : fileList) {
            String filePath = file.getAbsolutePath();
            String fileName = file.getName();
            FileSystem fileSys = FileSystems.getDefault();
            Path source = fileSys.getPath(filePath, new String[0]);
            Path destination = fileSys.getPath(projectSrcPath + File.separator + fileName, new String[0]);
            Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        File temp = new File(CmdUtils.getProjectGrpcSoloDirectoryPath());
        if (!dir.delete() || !temp.delete()) {
            logger.debug("Failed to delete GRPC temp files");
        }
    }

    private void createProtoOpenAPIFile(String projectName, OpenAPI openAPI) {
        String protoOpenAPIDirPath = CmdUtils.getProjectTargetGenGrpcSrcOpenAPIsDirectory(projectName);
        String fileName = openAPI.getInfo().getTitle() + "_" + openAPI.getInfo().getVersion().replace(".", "_") + ".yaml";
        String protoOpenAPIFilePath = protoOpenAPIDirPath + File.separator + fileName;
        try {
            CmdUtils.createFile(protoOpenAPIDirPath, fileName, true);
            CmdUtils.writeContent(Yaml.pretty(openAPI), new File(protoOpenAPIFilePath));
        }
        catch (IOException e) {
            throw new CLIInternalException("Error while writing openAPI files to the directory: " + protoOpenAPIDirPath + ".");
        }
    }
}

