/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.codegen;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.wso2.apimgt.gateway.cli.constants.GeneratorConstants;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ThrottlePolicyListMapper;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ThrottlePolicyMapper;
import org.wso2.apimgt.gateway.cli.model.template.GenSrcFile;
import org.wso2.apimgt.gateway.cli.model.template.policy.ThrottlePolicy;
import org.wso2.apimgt.gateway.cli.model.template.policy.ThrottlePolicyInitializer;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;
import org.wso2.apimgt.gateway.cli.utils.CodegenUtils;

public class ThrottlePolicyGenerator {
    public void generate(String outPath, List<ApplicationThrottlePolicyDTO> applicationPolicies, List<SubscriptionThrottlePolicyDTO> subscriptionPolicies) throws IOException {
        List<GenSrcFile> genSubsFiles;
        ArrayList<GenSrcFile> genFiles = new ArrayList<GenSrcFile>();
        List<GenSrcFile> genAppFiles = this.generateApplicationPolicies(applicationPolicies);
        if (genAppFiles != null) {
            genFiles.addAll(genAppFiles);
        }
        if ((genSubsFiles = this.generateSubscriptionPolicies(subscriptionPolicies)) != null) {
            genFiles.addAll(genSubsFiles);
        }
        GenSrcFile initGenFile = this.generateInitBal(applicationPolicies, subscriptionPolicies);
        genFiles.add(initGenFile);
        CodegenUtils.writeGeneratedSources(genFiles, Paths.get(outPath, new String[0]), true);
    }

    public void generate(String outPath, String projectName) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        String policyFileLocation = CmdUtils.getProjectDirectoryPath(projectName) + File.separator + "policies.yaml";
        ThrottlePolicyListMapper throttlePolicyListMapper = (ThrottlePolicyListMapper)mapper.readValue(new File(policyFileLocation), ThrottlePolicyListMapper.class);
        List<ThrottlePolicyMapper> applicationPolicies = throttlePolicyListMapper.getApplicationPolicies();
        List<ThrottlePolicyMapper> subscriptionPolicies = throttlePolicyListMapper.getSubscriptionPolicies();
        List<ThrottlePolicyMapper> resourcePolicies = throttlePolicyListMapper.getResourcePolicies();
        if (applicationPolicies == null && subscriptionPolicies == null && resourcePolicies == null) {
            return;
        }
        this.checkDuplicatePolicyNames(applicationPolicies, subscriptionPolicies, resourcePolicies);
        ArrayList<GenSrcFile> genFiles = new ArrayList<GenSrcFile>();
        GenSrcFile initGenFile = this.generateInitBal(applicationPolicies, subscriptionPolicies, resourcePolicies);
        genFiles.add(initGenFile);
        CodegenUtils.writeGeneratedSources(genFiles, Paths.get(outPath, new String[0]), true);
    }

    private List<GenSrcFile> generateGenericPolicies(List<ThrottlePolicyMapper> policies, GeneratorConstants.PolicyType type) throws IOException {
        if (policies == null) {
            return null;
        }
        ArrayList<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        for (ThrottlePolicyMapper policy : policies) {
            ThrottlePolicy policyContext = new ThrottlePolicy().buildContext(policy, type);
            sourceFiles.add(this.generatePolicy(policyContext));
        }
        return sourceFiles;
    }

    private List<GenSrcFile> generateApplicationPolicies(List<ApplicationThrottlePolicyDTO> applicationPolicies) throws IOException {
        if (applicationPolicies == null) {
            return null;
        }
        ArrayList<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        for (ApplicationThrottlePolicyDTO applicationPolicy : applicationPolicies) {
            ThrottlePolicy policyContext = new ThrottlePolicy().buildContext(applicationPolicy);
            sourceFiles.add(this.generatePolicy(policyContext));
        }
        return sourceFiles;
    }

    private List<GenSrcFile> generateSubscriptionPolicies(List<SubscriptionThrottlePolicyDTO> subscriptionPolicies) throws IOException {
        ArrayList<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        if (subscriptionPolicies == null) {
            return null;
        }
        for (SubscriptionThrottlePolicyDTO subscriptionPolicy : subscriptionPolicies) {
            ThrottlePolicy policyContext = new ThrottlePolicy().buildContext(subscriptionPolicy);
            sourceFiles.add(this.generatePolicy(policyContext));
        }
        return sourceFiles;
    }

    private GenSrcFile generateInitBal(List<ApplicationThrottlePolicyDTO> applicationPolicies, List<SubscriptionThrottlePolicyDTO> subscriptionPolicies) throws IOException {
        ThrottlePolicyInitializer context = new ThrottlePolicyInitializer();
        if (applicationPolicies != null) {
            context = context.buildAppContext(applicationPolicies);
        }
        if (subscriptionPolicies != null) {
            context = context.buildSubsContext(subscriptionPolicies);
        }
        return this.generateInitBalFile(context);
    }

    private GenSrcFile generateInitBal(List<ThrottlePolicyMapper> applicationPolicies, List<ThrottlePolicyMapper> subscriptionPolicies, List<ThrottlePolicyMapper> resourcePolicies) throws IOException {
        ThrottlePolicyInitializer context = new ThrottlePolicyInitializer();
        if (applicationPolicies != null) {
            context = context.buildPolicyContext(applicationPolicies, GeneratorConstants.PolicyType.APPLICATION);
        }
        if (subscriptionPolicies != null) {
            context = context.buildPolicyContext(subscriptionPolicies, GeneratorConstants.PolicyType.SUBSCRIPTION);
        }
        if (resourcePolicies != null) {
            context = context.buildPolicyContext(resourcePolicies, GeneratorConstants.PolicyType.RESOURCE);
        }
        return this.generateInitBalFile(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void writeBallerina(Object object, String templateDir, String templateName, String outPath) throws IOException {
        try (PrintWriter writer = null;){
            Template template = CodegenUtils.compileTemplate(templateDir, templateName);
            Context context = Context.newBuilder(object).resolver(MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE).build();
            writer = new PrintWriter(outPath, "UTF-8");
            writer.println(template.apply(context));
        }
    }

    private GenSrcFile generatePolicy(ThrottlePolicy context) throws IOException {
        String concatTitle = context.getPolicyType() + "_" + context.getName();
        String srcFile = concatTitle + ".bal";
        String mainContent = this.getContent(context);
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, mainContent);
    }

    private GenSrcFile generateInitBalFile(ThrottlePolicyInitializer context) throws IOException {
        String concatTitle = "throttle_policy_initializer";
        String srcFile = concatTitle + ".bal";
        String mainContent = this.getPolicyInitContent(context);
        return new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, srcFile, mainContent);
    }

    private String getContent(ThrottlePolicy object) throws IOException {
        Template template = CodegenUtils.compileTemplate(GeneratorConstants.DEFAULT_TEMPLATE_DIR, "policy");
        Context context = Context.newBuilder(object).resolver(MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE).build();
        return template.apply(context);
    }

    private String getPolicyInitContent(ThrottlePolicyInitializer object) throws IOException {
        Template template = CodegenUtils.compileTemplate(GeneratorConstants.DEFAULT_TEMPLATE_DIR, "policy_init");
        Context context = Context.newBuilder(object).resolver(MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE).build();
        return template.apply(context);
    }

    private void checkDuplicatePolicyNames(List<ThrottlePolicyMapper> applicationPolicies, List<ThrottlePolicyMapper> subscriptionPolicies, List<ThrottlePolicyMapper> resourcePolicies) {
        List resPolicyNames;
        HashSet resPolicySet;
        List subPolicyNames;
        HashSet subPolicySet;
        List appPolicyNames;
        HashSet appPolicySet;
        if (applicationPolicies != null && (appPolicySet = new HashSet(appPolicyNames = applicationPolicies.stream().map(ThrottlePolicyMapper::getName).collect(Collectors.toList()))).size() < applicationPolicies.size()) {
            throw new CLIRuntimeException("Application policies contains duplicate names in the policies.yaml file");
        }
        if (subscriptionPolicies != null && (subPolicySet = new HashSet(subPolicyNames = subscriptionPolicies.stream().map(ThrottlePolicyMapper::getName).collect(Collectors.toList()))).size() < subscriptionPolicies.size()) {
            throw new CLIRuntimeException("Subscription policies contains duplicate names in the policies.yaml file");
        }
        if (resourcePolicies != null && (resPolicySet = new HashSet(resPolicyNames = resourcePolicies.stream().map(ThrottlePolicyMapper::getName).collect(Collectors.toList()))).size() < resourcePolicies.size()) {
            throw new CLIRuntimeException("Resource policies contains duplicate names in the policies.yaml file");
        }
    }
}

