/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.model.route;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.wso2.apimgt.gateway.cli.exception.CLICompileTimeException;
import org.wso2.apimgt.gateway.cli.model.mgwcodegen.AdvanceEndpointConfigDTO;
import org.wso2.apimgt.gateway.cli.model.rest.APIEndpointSecurityDTO;
import org.wso2.apimgt.gateway.cli.model.route.EndpointType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EndpointListRouteDTO {
    private APIEndpointSecurityDTO securityConfig = null;
    private EndpointType type = null;
    private List<String> endpoints = null;
    private String name;
    private AdvanceEndpointConfigDTO advanceEndpointConfig = null;

    @JsonProperty(value="securityConfig")
    public APIEndpointSecurityDTO getSecurityConfig() {
        return this.securityConfig;
    }

    public void setSecurityConfig(APIEndpointSecurityDTO securityConfig) {
        this.securityConfig = securityConfig;
    }

    @JsonProperty(value="type")
    public EndpointType getType() {
        return this.type;
    }

    public void setType(EndpointType type) {
        this.type = type;
    }

    @JsonProperty(value="urls", required=true)
    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AdvanceEndpointConfigDTO getAdvanceEndpointConfig() {
        return this.advanceEndpointConfig;
    }

    public void setAdvanceEndpointConfig(AdvanceEndpointConfigDTO advanceEndpointConfig) {
        this.advanceEndpointConfig = advanceEndpointConfig;
    }

    public void addEndpoint(String endpoint) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        }
        if (!this.endpoints.contains(endpoint)) {
            this.endpoints.add(endpoint);
        }
    }

    public void validateEndpoints() throws CLICompileTimeException {
        if (this.endpoints != null) {
            for (String endpoint : this.endpoints) {
                this.validateEndpointUrl(endpoint);
            }
        }
    }

    private void validateEndpointUrl(String endpointUrl) throws CLICompileTimeException {
        if (endpointUrl.trim().matches("etcd\\s*\\(.*,.*\\)")) {
            String temp = endpointUrl.substring(endpointUrl.indexOf("(") + 1, endpointUrl.indexOf(")"));
            String[] entries = temp.split(",");
            if (entries.length != 2) {
                throw new CLICompileTimeException("'etcd' key containing string should be provided as 'etcd (etcd_key, default_url)'.");
            }
        } else {
            try {
                new URL(endpointUrl);
            }
            catch (MalformedURLException e) {
                throw new CLICompileTimeException("Malformed Url is provided :" + endpointUrl, e);
            }
        }
    }
}

