/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.model.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.wso2.apimgt.gateway.cli.exception.CLIInternalException;
import org.wso2.apimgt.gateway.cli.model.template.BallerinaLibrary;
import org.wso2.apimgt.gateway.cli.model.template.service.BallerinaService;
import org.wso2.apimgt.gateway.cli.utils.CmdUtils;

public class BallerinaToml {
    private List<String> dependencies = new ArrayList<String>();
    private List<BallerinaLibrary> libs = new ArrayList<BallerinaLibrary>();
    private String toolkitHome;
    private String mgwVersion;

    public BallerinaToml() {
        this.init();
    }

    private void init() {
        Properties pom = new Properties();
        String pomPath = "/META-INF/maven/org.wso2.am.microgw/org.wso2.micro.gateway.cli/pom.properties";
        try (InputStream is = this.getClass().getResourceAsStream(pomPath);){
            if (is != null) {
                pom.load(is);
                this.mgwVersion = pom.getProperty("version");
            }
        }
        catch (IOException e) {
            throw new CLIInternalException("Failed to initialize target ballerina project");
        }
    }

    public void addDependencies(BallerinaService api) {
        if (api != null && api.getLibVersions() != null) {
            HashMap<String, String> moduleVersionMap = api.getLibVersions();
            for (Map.Entry<String, String> entry : moduleVersionMap.entrySet()) {
                String dependency = "\"" + entry.getKey() + "\" = \"" + entry.getValue() + "\"";
                this.dependencies.add(dependency);
            }
        }
    }

    public void addLibs(String projectName) {
        List<String> jars = CmdUtils.getExternalJarDependencies(projectName);
        for (String jar : jars) {
            String path = jar.replace('\\', '/');
            BallerinaLibrary lib = new BallerinaLibrary();
            lib.setPath(path);
            this.libs.add(lib);
        }
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public List<BallerinaLibrary> getLibs() {
        return this.libs;
    }

    public void setLibs(List<BallerinaLibrary> libs) {
        this.libs = libs;
    }

    public String getToolkitHome() {
        return this.toolkitHome;
    }

    public void setToolkitHome(String toolkitHome) {
        if (toolkitHome != null) {
            this.toolkitHome = toolkitHome.replace('\\', '/');
        }
    }

    public String getMgwVersion() {
        return this.mgwVersion;
    }

    public void setMgwVersion(String mgwVersion) {
        this.mgwVersion = mgwVersion;
    }
}

